/*
 * Decompiled with CFR 0.152.
 */
package play.template2;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.net.URL;
import play.template2.exceptions.GTCompilationException;

public abstract class IO {
    public static String readContentAsString(File file, String encoding) {
        FileInputStream is = null;
        try {
            is = new FileInputStream(file);
            StringWriter result = new StringWriter();
            PrintWriter out = new PrintWriter(result);
            BufferedReader reader = new BufferedReader(new InputStreamReader((InputStream)is, encoding));
            String line = null;
            while ((line = reader.readLine()) != null) {
                out.println(line);
            }
            String string = result.toString();
            return string;
        }
        catch (IOException e) {
            throw new GTCompilationException("Error reading the file " + file, e);
        }
        finally {
            if (is != null) {
                try {
                    ((InputStream)is).close();
                }
                catch (Exception e) {}
            }
        }
    }

    public static String readContentAsString(URL fileURL, String encoding) {
        InputStream is = null;
        try {
            is = fileURL.openStream();
            StringWriter result = new StringWriter();
            PrintWriter out = new PrintWriter(result);
            BufferedReader reader = new BufferedReader(new InputStreamReader(is, encoding));
            String line = null;
            while ((line = reader.readLine()) != null) {
                out.println(line);
            }
            String string = result.toString();
            return string;
        }
        catch (IOException e) {
            throw new GTCompilationException("Error reading the file " + fileURL, e);
        }
        finally {
            if (is != null) {
                try {
                    is.close();
                }
                catch (Exception e) {}
            }
        }
    }

    public static String readContentAsString(File file) {
        return IO.readContentAsString(file, "utf-8");
    }

    public static String readContentAsString(URL fileURL) {
        return IO.readContentAsString(fileURL, "utf-8");
    }

    public static void write(byte[] data, File file) {
        FileOutputStream os = null;
        try {
            os = new FileOutputStream(file);
            ((OutputStream)os).write(data);
            os.flush();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        finally {
            try {
                if (os != null) {
                    ((OutputStream)os).close();
                }
            }
            catch (Exception e) {}
        }
    }

    public static byte[] readContent(File file) {
        FileInputStream is = null;
        try {
            is = new FileInputStream(file);
            byte[] result = new byte[(int)file.length()];
            ((InputStream)is).read(result);
            byte[] byArray = result;
            return byArray;
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        finally {
            if (is != null) {
                try {
                    ((InputStream)is).close();
                }
                catch (Exception e) {}
            }
        }
    }

    public static File getFileFromURL(URL urlFile) {
        if (urlFile.getProtocol().equals("file")) {
            return new File(urlFile.getFile());
        }
        return null;
    }

    public static FileInfo getFileInfo(URL fileURL) {
        File file = IO.getFileFromURL(fileURL);
        if (file == null) {
            return new FileInfo(0L, 0L);
        }
        return new FileInfo(file.lastModified(), file.length());
    }

    public static class FileInfo {
        public final long lastModified;
        public final long size;

        public FileInfo(long lastModified, long size) {
            this.lastModified = lastModified;
            this.size = size;
        }
    }
}

