/*
 * Decompiled with CFR 0.152.
 */
package play.modules.gtengineplugin;

import play.Play;
import play.PlayPlugin;
import play.modules.gtengineplugin.TemplateLoader;
import play.templates.Template;
import play.vfs.VirtualFile;

public class GTEnginePlugin
extends PlayPlugin {
    private String[] relativePathsToIgnore = new String[]{"{play}/framework/templates/tags/errors.tag", "{play}/framework/templates/tags/fixture.tag", "{play}/framework/templates/tags/selenium.html", "{module:crud}/"};

    private synchronized void init() {
        this.fixTemplatesPathOrder();
        TemplateLoader.init();
    }

    private void fixTemplatesPathOrder() {
        int index = 0;
        for (VirtualFile vf : Play.templatesPath) {
            if (vf.child("__faster_groovy_templates.txt").exists()) {
                if (index == 1) break;
                Play.templatesPath.remove(index);
                Play.templatesPath.add(1, vf);
                break;
            }
            ++index;
        }
    }

    public void onLoad() {
        this.init();
    }

    public void onApplicationStart() {
        this.init();
    }

    public Template loadTemplate(VirtualFile file) {
        String relativePath = file.relativePath();
        if (!relativePath.endsWith("/conf/routes")) {
            for (String pathToIgnore : this.relativePathsToIgnore) {
                if (!relativePath.startsWith(pathToIgnore)) continue;
                return null;
            }
        }
        Template t = TemplateLoader.load(file);
        return t;
    }
}

