/*
 * Decompiled with CFR 0.152.
 */
package play.modules.gtengineplugin;

import java.io.File;
import java.net.MalformedURLException;
import java.util.ArrayList;
import java.util.List;
import play.Logger;
import play.Play;
import play.classloading.GTTypeResolver1xImpl;
import play.exceptions.TemplateCompilationException;
import play.exceptions.TemplateNotFoundException;
import play.modules.gtengineplugin.GTTemplate;
import play.modules.gtengineplugin.gt_integration.GTFileResolver1xImpl;
import play.modules.gtengineplugin.gt_integration.GTJavaExtensionMethodResolver1x;
import play.modules.gtengineplugin.gt_integration.GTTagContextBridge;
import play.modules.gtengineplugin.gt_integration.PreCompilerFactory;
import play.template2.GTFileResolver;
import play.template2.GTJavaBase;
import play.template2.GTTagContext;
import play.template2.GTTemplateInstanceFactoryLive;
import play.template2.GTTemplateLocation;
import play.template2.GTTemplateLocationReal;
import play.template2.GTTemplateLocationWithEmbeddedSource;
import play.template2.GTTemplateRepo;
import play.template2.compile.GTCompiler;
import play.template2.compile.GTGroovyPimpTransformer;
import play.template2.compile.GTJavaCompileToClass;
import play.template2.compile.GTPreCompilerFactory;
import play.template2.exceptions.GTCompilationException;
import play.template2.exceptions.GTCompilationExceptionWithSourceInfo;
import play.template2.exceptions.GTTemplateNotFound;
import play.templates.Template;
import play.vfs.VirtualFile;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TemplateLoader {
    private static GTTemplateRepo templateRepo;

    public static void init() {
        if (templateRepo != null && Play.mode == Play.Mode.PROD) {
            return;
        }
        GTTagContext.singleton = new GTTagContextBridge();
        GTGroovyPimpTransformer.gtJavaExtensionMethodResolver = new GTJavaExtensionMethodResolver1x();
        GTTemplateInstanceFactoryLive.protectionDomain = Play.classloader.protectionDomain;
        GTFileResolver.impl = new GTFileResolver1xImpl(Play.templatesPath);
        if (Boolean.parseBoolean(Play.configuration.getProperty("save-gttemplate-source-to-disk", "false"))) {
            GTCompiler.srcDestFolder = new File(Play.applicationPath, "generated-src");
        }
        File folderToDumpClassesIn = null;
        if (System.getProperty("precompile") != null) {
            folderToDumpClassesIn = new File(Play.applicationPath, "precompiled/java");
        } else if (Play.mode != Play.Mode.PROD) {
            folderToDumpClassesIn = new File(Play.applicationPath, "tmp/gttemplates");
        }
        GTJavaCompileToClass.typeResolver = new GTTypeResolver1xImpl();
        templateRepo = new GTTemplateRepo((ClassLoader)Play.classloader, Play.mode == Play.Mode.DEV, (GTPreCompilerFactory)new PreCompilerFactory(), Play.usePrecompiled, folderToDumpClassesIn);
    }

    public static Template load(VirtualFile file) {
        GTTemplateLocationReal templateLocation = null;
        try {
            templateLocation = new GTTemplateLocationReal(file.relativePath(), file.getRealFile().toURI().toURL());
        }
        catch (MalformedURLException e) {
            throw new RuntimeException(e);
        }
        GTJavaBase gtJavaBase = TemplateLoader.getGTTemplateInstance((GTTemplateLocation)templateLocation);
        return new GTTemplate((GTTemplateLocation)templateLocation, gtJavaBase);
    }

    protected static GTJavaBase getGTTemplateInstance(GTTemplateLocation templateLocation) {
        try {
            return templateRepo.getTemplateInstance(templateLocation);
        }
        catch (GTTemplateNotFound e) {
            throw new TemplateNotFoundException(e.queryPath);
        }
        catch (GTCompilationExceptionWithSourceInfo e) {
            GTTemplate t = new GTTemplate(e.templateLocation);
            t.loadSource();
            throw new TemplateCompilationException((Template)t, Integer.valueOf(e.oneBasedLineNo), e.specialMessage);
        }
        catch (GTCompilationException e) {
            throw new RuntimeException(e.getMessage(), e);
        }
    }

    public static Template load(String key, String source) {
        GTTemplateLocationWithEmbeddedSource tl = new GTTemplateLocationWithEmbeddedSource(key, source);
        GTJavaBase gtJavaBase = TemplateLoader.getGTTemplateInstance((GTTemplateLocation)tl);
        return new GTTemplate((GTTemplateLocation)tl, gtJavaBase);
    }

    public static Template load(String key, String source, boolean reload) {
        GTTemplateLocationWithEmbeddedSource tl = new GTTemplateLocationWithEmbeddedSource(key, source);
        templateRepo.removeTemplate((GTTemplateLocation)tl);
        GTJavaBase gtJavaBase = TemplateLoader.getGTTemplateInstance((GTTemplateLocation)tl);
        return new GTTemplate((GTTemplateLocation)tl, gtJavaBase);
    }

    public static Template loadString(String source) {
        GTTemplateLocationWithEmbeddedSource templateLocation = new GTTemplateLocationWithEmbeddedSource(source);
        GTTemplateRepo.TemplateInfo ti = templateRepo.compileTemplate((GTTemplateLocation)templateLocation);
        GTJavaBase gtJavaBase = ti.templateInstanceFactory.create(templateRepo);
        return new GTTemplate((GTTemplateLocation)templateLocation, gtJavaBase);
    }

    public static void cleanCompiledCache() {
        TemplateLoader.init();
    }

    public static void cleanCompiledCache(String key) {
        templateRepo.removeTemplate(new GTTemplateLocation(key));
    }

    public static Template load(String path) {
        Template template = null;
        for (VirtualFile vf : Play.templatesPath) {
            VirtualFile tf;
            if (vf == null || !(tf = vf.child(path)).exists()) continue;
            template = TemplateLoader.load(tf);
            break;
        }
        if (template == null) {
            VirtualFile tf = Play.getVirtualFile((String)path);
            if (tf != null && tf.exists()) {
                template = TemplateLoader.load(tf);
            } else {
                throw new TemplateNotFoundException(path);
            }
        }
        return template;
    }

    public static List<Template> getAllTemplate() {
        ArrayList<Template> res = new ArrayList<Template>();
        for (VirtualFile virtualFile : Play.templatesPath) {
            TemplateLoader.scan(res, virtualFile);
        }
        for (VirtualFile root : Play.roots) {
            VirtualFile vf = root.child("conf/routes");
            if (vf == null || !vf.exists()) continue;
            Template template = TemplateLoader.load(vf);
        }
        return res;
    }

    private static void scan(List<Template> templates, VirtualFile current) {
        if (!(current.isDirectory() || current.getName().startsWith(".") || current.getName().endsWith(".scala.html"))) {
            long start = System.currentTimeMillis();
            Template template = TemplateLoader.load(current);
            if (Logger.isTraceEnabled()) {
                Logger.trace((String)"%sms to load %s", (Object[])new Object[]{System.currentTimeMillis() - start, current.getName()});
            }
            templates.add(template);
        } else if (current.isDirectory() && !current.getName().startsWith(".")) {
            for (VirtualFile virtualFile : current.list()) {
                TemplateLoader.scan(templates, virtualFile);
            }
        }
    }
}

