/*
 * Decompiled with CFR 0.152.
 */
package play.template2;

import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class GTLineMapper {
    private final Integer[] lineLookup;
    private static final Pattern lineNoP = Pattern.compile(".*//lineNo:(\\d+)$");

    public GTLineMapper(Integer[] lineLookup) {
        this.lineLookup = lineLookup;
    }

    public GTLineMapper(String[] preCompiledLines) {
        this.lineLookup = this.generateLineLookup(preCompiledLines);
    }

    public String getLineLookupAsString() {
        StringBuilder sb = new StringBuilder();
        for (Integer i : this.lineLookup) {
            sb.append(',');
            if (i == null) {
                sb.append("null");
                continue;
            }
            sb.append(i);
        }
        return sb.toString().substring(1);
    }

    public int translateLineNo(int originalLineNo) {
        int line = originalLineNo - 1;
        if (line >= this.lineLookup.length) {
            line = this.lineLookup.length - 1;
        }
        while (line >= 0) {
            Integer i = this.lineLookup[line];
            if (i != null) {
                return i;
            }
            --line;
        }
        return 1;
    }

    private Integer[] generateLineLookup(String[] precompiledSrcLines) {
        Integer[] mapping = new Integer[precompiledSrcLines.length];
        int i = 0;
        for (String line : precompiledSrcLines) {
            Matcher m = lineNoP.matcher(line);
            if (m.find()) {
                mapping[i] = Integer.parseInt(m.group(1));
            }
            ++i;
        }
        return mapping;
    }
}

