/*
 * Decompiled with CFR 0.152.
 */
package play.template2.compile;

import java.lang.reflect.Method;
import play.template2.compile.GTPreCompiler;
import play.template2.exceptions.GTCompilationExceptionWithSourceInfo;

public class GTInternalTagsCompiler {
    public boolean generateCodeForGTFragments(String tagName, String contentMethodName, GTPreCompiler.SourceContext sc, int startLine) {
        Method tagMethod = null;
        try {
            tagMethod = this.getClass().getMethod("tag_" + tagName, String.class, String.class, GTPreCompiler.SourceContext.class, Integer.TYPE);
        }
        catch (Exception e) {
            return false;
        }
        try {
            tagMethod.invoke((Object)this, tagName, contentMethodName, sc, startLine);
        }
        catch (Exception e) {
            throw new GTCompilationExceptionWithSourceInfo("Error generating code for tag '" + tagName + "'", sc.templateLocation, startLine + 1, e);
        }
        return true;
    }

    public void tag_list(String tagName, String contentMethodName, GTPreCompiler.SourceContext sc, int startLine) {
        sc.jprintln(" clearElseFlag();", startLine);
        sc.jprintln(" String as = (String)tagArgs.get(\"as\");");
        sc.jprintln(" String itemName = (as==null?\"_\":as);");
        sc.jprintln(" as = (as == null ? \"\" : as);");
        sc.jprintln(" Object _items = tagArgs.get(\"items\");");
        sc.jprintln(" if (_items == null ) _items = tagArgs.get(\"arg\");");
        sc.jprintln(" if (_items == null ) return ;");
        sc.jprintln(" int i=0;");
        sc.jprintln(" Iterator it = convertToIterator(_items);");
        sc.jprintln(" while( it.hasNext()) {");
        sc.jprintln("   Object item = it.next();");
        sc.jprintln("   i++;");
        sc.jprintln("   binding.setProperty(itemName, item);");
        sc.jprintln("   binding.setProperty(as+\"_index\", i);");
        sc.jprintln("   binding.setProperty(as+\"_isLast\", !it.hasNext());");
        sc.jprintln("   binding.setProperty(as+\"_isFirst\", i==1);");
        sc.jprintln("   binding.setProperty(as+\"_parity\", (i%2==0?\"even\":\"odd\"));");
        sc.jprintln("   " + contentMethodName + "();");
        sc.jprintln(" }");
        sc.jprintln(" if(i==0) { setElseFlag(); }");
    }

    public void tag_if(String tagName, String contentMethodName, GTPreCompiler.SourceContext sc, int startLine) {
        sc.jprintln(" Object e = tagArgs.get(\"arg\");", startLine);
        sc.jprintln(" clearElseFlag();");
        sc.jprintln(" if(evaluateCondition(e)) {" + contentMethodName + "();} else { setElseFlag(); }");
    }

    public void tag_ifnot(String tagName, String contentMethodName, GTPreCompiler.SourceContext sc, int startLine) {
        sc.jprintln(" Object e = tagArgs.get(\"arg\");", startLine);
        sc.jprintln(" clearElseFlag();");
        sc.jprintln(" if(!evaluateCondition(e)) {" + contentMethodName + "();} else { setElseFlag(); }");
    }

    public void tag_else(String tagName, String contentMethodName, GTPreCompiler.SourceContext sc, int startLine) {
        sc.jprintln(" if( elseFlagIsSet()) {" + contentMethodName + "();}", startLine);
        sc.jprintln(" clearElseFlag();");
    }

    public void tag_elseif(String tagName, String contentMethodName, GTPreCompiler.SourceContext sc, int startLine) {
        sc.jprintln(" if( elseFlagIsSet()) {", startLine);
        this.tag_if(tagName, contentMethodName, sc, startLine);
        sc.jprintln(" }");
    }

    public void tag_extends(String tagName, String contentMethodName, GTPreCompiler.SourceContext sc, int startLine) {
        String templateNameVar = "_tn_" + sc.nextMethodIndex++;
        sc.jprintln(" String " + templateNameVar + " = (String)tagArgs.get(\"arg\");", startLine);
        sc.jprintln(" play.template2.GTTemplateLocationReal templateLocation = this.resolveTemplateLocation( " + templateNameVar + " );");
        sc.jprintln(" if(templateLocation == null ) {throw new play.template2.exceptions.GTTemplateNotFoundWithSourceInfo(" + templateNameVar + ", this.templateLocation, " + (startLine + 1) + ");}");
        sc.jprintln(" this.extendsTemplateLocation = templateLocation;");
    }

    public void tag_doLayout(String tagName, String contentMethodName, GTPreCompiler.SourceContext sc, int startLine) {
        sc.jprintln(" if( this.extendingTemplate == null) throw new play.template2.exceptions.GTRuntimeException(\"No template is currently extending this template\");", startLine);
        sc.jprintln(" this.insertOutput(this.extendingTemplate);");
    }
}

