/*
 * Decompiled with CFR 0.152.
 */
package play.modules.gtengineplugin.gt_integration;

import java.io.File;
import java.net.MalformedURLException;
import java.util.List;
import play.Play;
import play.template2.GTFileResolver;
import play.template2.GTTemplateLocationReal;
import play.vfs.VirtualFile;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GTFileResolver1xImpl
implements GTFileResolver.Resolver {
    protected final File[] templateFolders;

    public GTFileResolver1xImpl(List<VirtualFile> templatesPaths) {
        this.templateFolders = new File[templatesPaths.size()];
        int i = 0;
        for (VirtualFile vf : templatesPaths) {
            this.templateFolders[i] = vf.getRealFile();
            ++i;
        }
    }

    public GTTemplateLocationReal getTemplateLocationReal(String queryPath) {
        for (File folder : this.templateFolders) {
            File file;
            if (folder == null) {
                file = new File(queryPath);
                if (!file.exists() || !file.isFile()) continue;
                try {
                    return new GTTemplateLocationReal(VirtualFile.open((File)file).relativePath(), file.toURI().toURL());
                }
                catch (MalformedURLException e) {
                    throw new RuntimeException(e);
                }
            }
            file = new File(folder, queryPath);
            if (!file.exists() || !file.isFile()) continue;
            try {
                return new GTTemplateLocationReal(VirtualFile.open((File)file).relativePath(), file.toURI().toURL());
            }
            catch (MalformedURLException e) {
                throw new RuntimeException(e);
            }
        }
        VirtualFile tf = Play.getVirtualFile((String)queryPath);
        if (tf != null && tf.exists() && !tf.isDirectory()) {
            try {
                return new GTTemplateLocationReal(tf.relativePath(), tf.getRealFile().toURI().toURL());
            }
            catch (MalformedURLException e) {
                throw new RuntimeException(e);
            }
        }
        return null;
    }

    public GTTemplateLocationReal getTemplateLocationFromRelativePath(String relativePath) {
        VirtualFile vf = VirtualFile.fromRelativePath((String)relativePath);
        if (vf == null || !vf.exists() || vf.isDirectory()) {
            return null;
        }
        try {
            return new GTTemplateLocationReal(relativePath, vf.getRealFile().toURI().toURL());
        }
        catch (MalformedURLException e) {
            throw new RuntimeException(e);
        }
    }
}

