/*
 * Decompiled with CFR 0.152.
 */
package play.template2;

import java.util.HashMap;
import java.util.Map;
import java.util.Stack;
import play.template2.GTTagContext;

class GTTagContextDefaultImpl
extends GTTagContext {
    static ThreadLocal<Stack<GTTagContext.GTTagContextInfo>> currentStack = new ThreadLocal();

    GTTagContextDefaultImpl() {
    }

    @Override
    public void init() {
        currentStack.set(new Stack());
        this.enterTag("ROOT");
    }

    @Override
    public void enterTag(String name) {
        currentStack.get().add(new GTTagContextInfoImpl(name));
    }

    @Override
    public void exitTag() {
        currentStack.get().pop();
    }

    @Override
    public GTTagContext.GTTagContextInfo current() {
        return currentStack.get().peek();
    }

    @Override
    public GTTagContext.GTTagContextInfo parent() {
        if (currentStack.get().size() < 2) {
            return null;
        }
        return (GTTagContext.GTTagContextInfo)currentStack.get().get(currentStack.get().size() - 2);
    }

    @Override
    public boolean hasParentTag(String name) {
        for (int i = currentStack.get().size() - 1; i >= 0; --i) {
            if (!name.equals(((GTTagContext.GTTagContextInfo)currentStack.get().get(i)).getTagName())) continue;
            return true;
        }
        return false;
    }

    @Override
    public GTTagContext.GTTagContextInfo parent(String name) {
        for (int i = currentStack.get().size() - 1; i >= 0; --i) {
            if (!name.equals(((GTTagContext.GTTagContextInfo)currentStack.get().get(i)).getTagName())) continue;
            return (GTTagContext.GTTagContextInfo)currentStack.get().get(i);
        }
        return null;
    }

    public static class GTTagContextInfoImpl
    implements GTTagContext.GTTagContextInfo {
        private final String tagName;
        private final Map<String, Object> data = new HashMap<String, Object>();

        protected GTTagContextInfoImpl(String tagName) {
            this.tagName = tagName;
        }

        @Override
        public String getTagName() {
            return this.tagName;
        }

        @Override
        public Map<String, Object> getData() {
            return this.data;
        }

        public String toString() {
            return this.tagName + "" + this.data;
        }
    }
}

