/*
 * Decompiled with CFR 0.152.
 */
package play.template2;

import java.util.ArrayList;
import play.template2.GTTemplateRepo;
import play.template2.compile.GTJavaCompileToClass;
import play.template2.compile.GTPreCompiler;
import play.template2.exceptions.GTAppClassException;
import play.template2.exceptions.GTException;
import play.template2.exceptions.GTRuntimeException;
import play.template2.exceptions.GTRuntimeExceptionForwarder;
import play.template2.exceptions.GTRuntimeExceptionWithSourceInfo;
import play.template2.exceptions.GTTemplateRuntimeException;

public class GTExceptionFixer {
    private final GTTemplateRepo templateRepo;

    public GTExceptionFixer(GTTemplateRepo templateRepo) {
        this.templateRepo = templateRepo;
    }

    protected FixedStackTrace fixStackTrace(StackTraceElement[] seList) {
        GTTemplateRepo.TemplateInfo prevTi = null;
        GTTemplateRepo.TemplateInfo errorTI = null;
        String errorInAppClassName = null;
        boolean haveFoundErrorLocation = false;
        int errorLine = 0;
        ArrayList<StackTraceElement> newSElist = new ArrayList<StackTraceElement>();
        StackTraceElement[] arr$ = seList;
        int len$ = arr$.length;
        for (int i$ = 0; i$ < len$; ++i$) {
            StackTraceElement se;
            StackTraceElement orgSe = se = arr$[i$];
            String appClassName = null;
            String clazz = se.getClassName();
            int lineNo = 0;
            GTTemplateRepo.TemplateInfo ti = null;
            if (clazz.startsWith(GTPreCompiler.generatedPackageName)) {
                int i = clazz.indexOf("$");
                if (i > 0) {
                    clazz = clazz.substring(0, i);
                }
                boolean groovy = false;
                if (clazz.endsWith("G")) {
                    groovy = true;
                    clazz = clazz.substring(0, clazz.length() - 1);
                }
                ti = this.templateRepo.classname2TemplateInfo.get(clazz);
                if (se.getMethodName().equals("_renderTemplate")) {
                    se = null;
                } else if (ti != null) {
                    if (ti == prevTi) {
                        se = null;
                    } else if (se.getLineNumber() <= 0) {
                        se = null;
                    } else {
                        prevTi = ti;
                        lineNo = groovy ? ti.getGroovyLineMapper().translateLineNo(se.getLineNumber()) : ti.getJavaLineMapper().translateLineNo(se.getLineNumber());
                        se = new StackTraceElement(ti.templateLocation.relativePath, "", "line", lineNo);
                    }
                }
            } else if (clazz.startsWith("org.codehaus.groovy.") || clazz.startsWith("groovy.") || clazz.startsWith("sun.reflect.") || clazz.startsWith("java.lang.reflect.")) {
                se = null;
            } else if (se.getLineNumber() > 0 && GTJavaCompileToClass.typeResolver.isApplicationClass(clazz)) {
                appClassName = se.getClassName();
                lineNo = se.getLineNumber();
            }
            if (se == null) continue;
            if (!haveFoundErrorLocation) {
                if (appClassName == null) {
                    if (errorTI == null && ti != null && se != orgSe) {
                        errorTI = ti;
                        errorLine = lineNo;
                        haveFoundErrorLocation = true;
                    }
                } else {
                    errorInAppClassName = appClassName;
                    errorLine = lineNo;
                    haveFoundErrorLocation = true;
                }
            }
            newSElist.add(se);
        }
        StackTraceElement[] newStackTranceArray = newSElist.toArray(new StackTraceElement[0]);
        return new FixedStackTrace(errorTI, errorInAppClassName, errorLine, newStackTranceArray);
    }

    public GTException fixException(Throwable e) {
        while (e instanceof GTRuntimeExceptionForwarder) {
            Throwable cause = e.getCause();
            if (cause != null && cause.getStackTrace().length == 0) {
                cause.setStackTrace(e.getStackTrace());
            }
            e = cause;
        }
        StackTraceElement[] seList = e.getStackTrace();
        if (e instanceof GTTemplateRuntimeException) {
            for (int i = 0; i < seList.length; ++i) {
                String clazz = seList[i].getClassName();
                if (!clazz.startsWith(GTPreCompiler.generatedPackageName)) continue;
                StackTraceElement[] l = new StackTraceElement[seList.length - i];
                for (int n = i; n < seList.length; ++n) {
                    l[n - i] = seList[n];
                }
                seList = l;
                break;
            }
            if (e.getCause() != null) {
                e = e.getCause();
            }
        }
        FixedStackTrace fixedStackTrace = this.fixStackTrace(seList);
        GTException newE = null;
        newE = e instanceof GTRuntimeExceptionWithSourceInfo ? (GTRuntimeExceptionWithSourceInfo)e : (fixedStackTrace.errorTI != null ? new GTRuntimeExceptionWithSourceInfo(e.getMessage(), e, fixedStackTrace.errorTI.templateLocation, fixedStackTrace.errorLine) : (fixedStackTrace.errorInAppClassName != null ? new GTAppClassException(e.getMessage(), e, fixedStackTrace.errorInAppClassName, fixedStackTrace.errorLine) : new GTRuntimeException(e.getMessage(), e)));
        newE.setStackTrace(fixedStackTrace.stackTraceElements);
        for (Throwable cause = newE.getCause(); cause != null; cause = cause.getCause()) {
            cause.setStackTrace(this.fixStackTrace((StackTraceElement[])cause.getStackTrace()).stackTraceElements);
        }
        return newE;
    }

    protected static class FixedStackTrace {
        public final GTTemplateRepo.TemplateInfo errorTI;
        public final String errorInAppClassName;
        public final int errorLine;
        public final StackTraceElement[] stackTraceElements;

        public FixedStackTrace(GTTemplateRepo.TemplateInfo errorTI, String errorInAppClassName, int errorLine, StackTraceElement[] stackTraceElements) {
            this.errorTI = errorTI;
            this.errorInAppClassName = errorInAppClassName;
            this.errorLine = errorLine;
            this.stackTraceElements = stackTraceElements;
        }
    }
}

