/*
 * Decompiled with CFR 0.152.
 */
package play.template2;

import groovy.lang.Binding;
import groovy.lang.Script;
import java.io.OutputStream;
import java.io.StringWriter;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.commons.collections.iterators.ArrayIterator;
import play.template2.GTContentRenderer;
import play.template2.GTFileResolver;
import play.template2.GTGroovyBase;
import play.template2.GTRenderingResult;
import play.template2.GTTagContext;
import play.template2.GTTemplateLocation;
import play.template2.GTTemplateLocationReal;
import play.template2.GTTemplateRepo;
import play.template2.exceptions.GTCompilationException;
import play.template2.exceptions.GTRuntimeException;
import play.template2.exceptions.GTTemplateNotFoundWithSourceInfo;
import play.template2.exceptions.GTTemplateRuntimeException;
import play.template2.legacy.GTContentRendererFakeClosure;

public abstract class GTJavaBase
extends GTRenderingResult {
    public static final String executeNextElseKeyName = "_executeNextElse";
    public StringWriter out;
    protected Script groovyScript = null;
    public Binding binding;
    private final Class<? extends GTGroovyBase> groovyClass;
    protected Map<String, Object> orgArgs = null;
    public GTTemplateLocationReal extendsTemplateLocation = null;
    public GTJavaBase extendedTemplate = null;
    public GTJavaBase extendingTemplate = null;
    public GTContentRenderer contentRenderer;
    public GTTemplateRepo templateRepo;
    public final GTTemplateLocation templateLocation;
    public static ThreadLocal<Map<Object, Object>> layoutData = new ThreadLocal();

    public GTJavaBase(Class<? extends GTGroovyBase> groovyClass, GTTemplateLocation templateLocation) {
        this.groovyClass = groovyClass;
        this.templateLocation = templateLocation;
        this.initNewOut();
    }

    @Override
    public void writeOutput(OutputStream ps, String encoding) {
        if (this.extendedTemplate != null) {
            this.extendedTemplate.writeOutput(ps, encoding);
            return;
        }
        super.writeOutput(ps, encoding);
    }

    public void insertOutput(GTRenderingResult otherTemplate) {
        this.allOuts.addAll(otherTemplate.allOuts);
        this.initNewOut();
    }

    protected void insertNewOut(StringWriter outToInsert) {
        this.allOuts.add(outToInsert);
        this.initNewOut();
    }

    protected void initNewOut() {
        this.out = new StringWriter();
        this.allOuts.add(this.out);
    }

    public void renderTemplate(Map<String, Object> args) throws GTTemplateNotFoundWithSourceInfo, GTRuntimeException {
        layoutData.set(new HashMap());
        this.allOuts.clear();
        this.initNewOut();
        GTContentRendererFakeClosure.initRendering();
        this.extendsTemplateLocation = null;
        this.extendedTemplate = null;
        this.extendingTemplate = null;
        this.internalRenderTemplate(args, true, null);
    }

    public void internalRenderTemplate(Map<String, Object> args, boolean startingNewRendering, GTJavaBase callingTemplate) throws GTTemplateNotFoundWithSourceInfo, GTRuntimeException {
        if (startingNewRendering) {
            GTTagContext.singleton.init();
        }
        try {
            this.orgArgs = new HashMap<String, Object>(args);
            this.binding = new Binding(new HashMap<String, Object>(args));
            this.binding.setProperty("java_class", (Object)this);
            this.groovyScript = this.groovyClass.newInstance();
            this.groovyScript.setBinding(this.binding);
            this._renderTemplate();
            if (this.extendsTemplateLocation != null) {
                if (callingTemplate == null) {
                    this.extendedTemplate = this.templateRepo.getTemplateInstance(this.extendsTemplateLocation);
                    this.extendedTemplate.extendingTemplate = this;
                    this.extendedTemplate.internalRenderTemplate(this.orgArgs, false, null);
                } else {
                    callingTemplate.extendsTemplateLocation = this.extendsTemplateLocation;
                }
            }
        }
        catch (GTCompilationException e) {
            throw e;
        }
        catch (Throwable e) {
            throw this.templateRepo.fixException(e);
        }
    }

    protected abstract void _renderTemplate();

    protected void enterTag(String tagName) {
        GTTagContext.singleton.enterTag(tagName);
    }

    protected void leaveTag(String tagName) {
        GTTagContext.singleton.exitTag();
    }

    public abstract Class getRawDataClass();

    public abstract String convertRawDataToString(Object var1);

    public abstract String escapeHTML(String var1);

    public abstract String escapeXML(String var1);

    public abstract String escapeCsv(String var1);

    public String objectToString(Object o) {
        Class rawDataClass = this.getRawDataClass();
        if (rawDataClass != null && rawDataClass.isAssignableFrom(o.getClass())) {
            return this.convertRawDataToString(o);
        }
        if (!this.templateLocation.relativePath.endsWith(".html") || GTTagContext.singleton.hasParentTag("verbatim")) {
            if (this.templateLocation.relativePath.endsWith(".xml")) {
                return this.escapeXML(o.toString());
            }
            if (this.templateLocation.relativePath.endsWith(".csv")) {
                return this.escapeCsv(o.toString());
            }
            return o.toString();
        }
        return this.escapeHTML(o.toString());
    }

    public boolean evaluateCondition(Object test) {
        if (test != null) {
            if (test instanceof Boolean) {
                return (Boolean)test;
            }
            if (test instanceof String) {
                return ((String)test).length() > 0;
            }
            if (test instanceof Number) {
                return ((Number)test).intValue() != 0;
            }
            if (test instanceof Collection) {
                return !((Collection)test).isEmpty();
            }
            return true;
        }
        return false;
    }

    protected void invokeTagFile(String tagName, String tagFilePath, GTContentRenderer contentRenderer, Map<String, Object> tagArgs) {
        GTTemplateLocationReal tagTemplateLocation = GTFileResolver.impl.getTemplateLocationReal(tagFilePath);
        if (tagTemplateLocation == null) {
            throw new GTTemplateRuntimeException("Cannot find tag-file '" + tagFilePath + "'");
        }
        GTJavaBase tagTemplate = this.templateRepo.getTemplateInstance(tagTemplateLocation);
        tagTemplate.contentRenderer = contentRenderer;
        HashMap<String, Object> completeTagArgs = new HashMap<String, Object>(this.orgArgs);
        completeTagArgs.put("_caller", this.binding.getVariables());
        completeTagArgs.put("_body", (Object)new GTContentRendererFakeClosure(this, contentRenderer));
        for (String key : tagArgs.keySet()) {
            completeTagArgs.put("_" + key, tagArgs.get(key));
        }
        completeTagArgs.put("_attrs", tagArgs);
        tagTemplate.internalRenderTemplate(completeTagArgs, false, this);
        this.insertOutput(tagTemplate);
    }

    public abstract boolean validationHasErrors();

    public abstract boolean validationHasError(String var1);

    public final String messagesGet(Object key, Object ... args) {
        return this.resolveMessage(key, args);
    }

    protected abstract String resolveMessage(Object var1, Object[] var2);

    public void clearElseFlag() {
        GTTagContext.singleton.parent().getData().remove(executeNextElseKeyName);
    }

    public void setElseFlag() {
        GTTagContext.singleton.parent().getData().put(executeNextElseKeyName, true);
    }

    public boolean elseFlagIsSet() {
        Boolean v = (Boolean)GTTagContext.singleton.parent().getData().get(executeNextElseKeyName);
        if (v != null) {
            return v;
        }
        return false;
    }

    protected String handleMessageTag(Object _args) {
        List argsList = (List)_args;
        if (argsList.size() == 0) {
            throw new GTTemplateRuntimeException("It looks like you don't have anything in your Message tag");
        }
        Object key = argsList.get(0);
        if (key == null) {
            throw new GTTemplateRuntimeException("You are trying to resolve a message with an expression that is resolved to null - have you forgotten quotes around the message-key?");
        }
        if (argsList.size() == 1) {
            String m = this.messagesGet(key, new Object[0]);
            return m;
        }
        Object[] args = new Object[argsList.size() - 1];
        for (int i = 1; i < argsList.size(); ++i) {
            args[i - 1] = argsList.get(i);
        }
        String m = this.messagesGet(key, args);
        return m;
    }

    protected Iterator convertToIterator(final Object o) {
        if (o instanceof Iterator) {
            return (Iterator)o;
        }
        if (o instanceof Iterable) {
            return ((Iterable)o).iterator();
        }
        if (o instanceof Map) {
            return ((Map)o).entrySet().iterator();
        }
        if (o.getClass().isArray()) {
            return new Iterable(){

                public Iterator iterator() {
                    return new ArrayIterator(o);
                }
            }.iterator();
        }
        throw new GTTemplateRuntimeException("Cannot convert object-reference to Iterator");
    }

    public GTTemplateLocationReal resolveTemplateLocation(String name) {
        if (name.startsWith("./")) {
            String ct = this.templateLocation.relativePath;
            if (ct.matches("^/lib/[^/]+/app/views/.*")) {
                ct = ct.substring(ct.indexOf("/", 5));
            }
            ct = ct.substring(0, ct.lastIndexOf("/"));
            name = ct + name.substring(1);
            return GTFileResolver.impl.getTemplateLocationFromRelativePath(name);
        }
        return GTFileResolver.impl.getTemplateLocationReal(name);
    }

    public abstract Object cacheGet(String var1);

    public abstract void cacheSet(String var1, Object var2, String var3);
}

