/*
 * Decompiled with CFR 0.152.
 */
package play.template2;

import groovy.lang.GroovyObjectSupport;
import groovy.lang.MetaMethod;
import java.lang.reflect.Array;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import org.apache.commons.lang.reflect.MethodUtils;
import org.codehaus.groovy.runtime.InvokerHelper;
import play.template2.exceptions.GTRuntimeExceptionForwarder;

public abstract class GTJavaExtensionsInvoker {
    private static final Invoker regularArgsInvoker = new RegularArgsInvoker();
    private static final Invoker regularArgsWithObjectAsCollectionInvoker = new WithObjectAsCollectionInvoker(regularArgsInvoker);
    private static final Invoker withRealArgsAsArrayInvoker = new WithRealArgsAsArrayInvoker(regularArgsInvoker);
    private static final Invoker withRealArgsAsArrayAndObjectAsCollectionInvoker = new WithRealArgsAsArrayInvoker(regularArgsWithObjectAsCollectionInvoker);
    static final InvokeExecutor invokerExecutorMethod = new InvokerExecutorMethod();
    static final InvokeExecutor invokeExecutorGroovySupport = new InvokeExecutorGroovySupport();
    static final InvokeExecutor invokerExecutorRealMethod = new InvokerExecutorRealMethod();
    static final RealMethodInvoker realMethodInvoker = new RealMethodInvoker();
    static ConcurrentMap<InvocationSignatur, InvocationInfo> invocationInfoMap = new ConcurrentHashMap<InvocationSignatur, InvocationInfo>();
    private static final Invoker[] invokers = new Invoker[]{regularArgsInvoker, regularArgsWithObjectAsCollectionInvoker, withRealArgsAsArrayInvoker, withRealArgsAsArrayAndObjectAsCollectionInvoker};

    public static Object invoke(Class jeClazz, String methodName, Object object, Object[] args) {
        if (object == null) {
            return null;
        }
        try {
            InvocationSignatur invocationSignatur = new InvocationSignatur(methodName, object, args);
            InvocationInfo invocationInfo = null;
            invocationInfo = (InvocationInfo)invocationInfoMap.get(invocationSignatur);
            if (invocationInfo != null) {
                Invoker invoker = invocationInfo.invoker;
                return invocationInfo.invokeExecutor.doIt(invocationInfo.method, invocationInfo.methodName, object, invoker != null ? invoker.fixArgs(object, args) : null);
            }
            Invoker invoker = null;
            WrappedMethod m = null;
            InvokeExecutor invokerExecutor = null;
            for (Invoker _invoker : invokers) {
                m = _invoker.findMethod(jeClazz, methodName, object, args);
                if (m == null) continue;
                invoker = _invoker;
                invokerExecutor = invokerExecutorMethod;
                break;
            }
            if (invokerExecutor == null) {
                if (object instanceof GroovyObjectSupport) {
                    invokerExecutor = invokeExecutorGroovySupport;
                } else {
                    m = realMethodInvoker.findMethod(jeClazz, methodName, object, args);
                    if (m != null) {
                        invoker = realMethodInvoker;
                        invokerExecutor = invokerExecutorRealMethod;
                    }
                }
            }
            if (invokerExecutor != null) {
                invocationInfoMap.putIfAbsent(invocationSignatur, new InvocationInfo(m, methodName, invokerExecutor, invoker));
                Object res = invokerExecutor.doIt(m, methodName, object, invoker != null ? invoker.fixArgs(object, args) : null);
                return res;
            }
            throw new NoSuchMethodException(methodName);
        }
        catch (Throwable e) {
            if (e instanceof InvocationTargetException) {
                e = e.getCause();
            }
            throw new GTRuntimeExceptionForwarder(e);
        }
    }

    static class InvocationInfo {
        public final WrappedMethod method;
        public final String methodName;
        public final InvokeExecutor invokeExecutor;
        public final Invoker invoker;

        InvocationInfo(WrappedMethod method, String methodName, InvokeExecutor invokeExecutor, Invoker invoker) {
            this.method = method;
            this.methodName = methodName;
            this.invokeExecutor = invokeExecutor;
            this.invoker = invoker;
        }
    }

    static class InvocationSignatur {
        private final String methodName;
        private final Class objectType;
        private final Class[] argTypes;
        private final int hash;

        InvocationSignatur(String methodName, Object object, Object[] args) {
            this.methodName = methodName;
            this.objectType = object.getClass();
            this.argTypes = new Class[args.length];
            for (int i = 0; i < args.length; ++i) {
                Object arg = args[i];
                if (arg == null) continue;
                this.argTypes[i] = args.getClass();
            }
            this.hash = this.calcHashCode();
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            InvocationSignatur that = (InvocationSignatur)o;
            if (this.hash != that.hash) {
                return false;
            }
            if (!Arrays.equals(this.argTypes, that.argTypes)) {
                return false;
            }
            if (!this.methodName.equals(that.methodName)) {
                return false;
            }
            return this.objectType.equals(that.objectType);
        }

        public int hashCode() {
            return this.hash;
        }

        private int calcHashCode() {
            int result = this.methodName.hashCode();
            result = 31 * result + this.objectType.hashCode();
            result = 31 * result + Arrays.hashCode(this.argTypes);
            return result;
        }
    }

    static class InvokeExecutorGroovySupport
    implements InvokeExecutor {
        InvokeExecutorGroovySupport() {
        }

        @Override
        public Object doIt(WrappedMethod m, String methodName, Object object, Object[] args) throws Exception {
            GroovyObjectSupport gos = (GroovyObjectSupport)object;
            return gos.invokeMethod(methodName, (Object)args);
        }
    }

    static class InvokerExecutorRealMethod
    implements InvokeExecutor {
        InvokerExecutorRealMethod() {
        }

        @Override
        public Object doIt(WrappedMethod m, String methodName, Object object, Object[] args) throws Exception {
            return m.invoke(object, args);
        }
    }

    static class InvokerExecutorMethod
    implements InvokeExecutor {
        InvokerExecutorMethod() {
        }

        @Override
        public Object doIt(WrappedMethod m, String methodName, Object object, Object[] args) throws Exception {
            return m.invoke(null, args);
        }
    }

    static interface InvokeExecutor {
        public Object doIt(WrappedMethod var1, String var2, Object var3, Object[] var4) throws Exception;
    }

    static class RealMethodInvoker
    implements Invoker {
        RealMethodInvoker() {
        }

        @Override
        public Object[] fixArgs(Object object, Object[] args) {
            return args;
        }

        @Override
        public WrappedMethod findMethod(Class jeClazz, String methodName, Object object, Object[] args) {
            Class[] argsTypes = new Class[args.length];
            for (int i = 0; i < args.length; ++i) {
                Object arg = args[i];
                if (arg == null) continue;
                argsTypes[i] = arg.getClass();
            }
            MetaMethod mm = InvokerHelper.getMetaClass((Object)object).pickMethod(methodName, argsTypes);
            if (mm == null) {
                return null;
            }
            return new WrappedGroovyMetaMethod(mm);
        }
    }

    static class WithRealArgsAsArrayInvoker
    implements Invoker {
        private final Invoker baseInvoker;

        WithRealArgsAsArrayInvoker(Invoker baseInvoker) {
            this.baseInvoker = baseInvoker;
        }

        @Override
        public Object[] fixArgs(Object object, Object[] args) {
            Class<?> arrayType = args[0].getClass();
            Object argsArray = Array.newInstance(arrayType, args.length);
            for (int i = 0; i < args.length; ++i) {
                Array.set(argsArray, i, args[i]);
            }
            return this.baseInvoker.fixArgs(object, new Object[]{argsArray});
        }

        @Override
        public WrappedMethod findMethod(Class jeClazz, String methodName, Object object, Object[] args) {
            if (args.length == 0) {
                return null;
            }
            Class<?> arrayType = args[0].getClass();
            Object tmpArray = Array.newInstance(arrayType, 0);
            return this.baseInvoker.findMethod(jeClazz, methodName, object, new Object[]{tmpArray});
        }
    }

    static class WithObjectAsCollectionInvoker
    implements Invoker {
        private final Invoker baseInvoker;

        WithObjectAsCollectionInvoker(Invoker baseInvoker) {
            this.baseInvoker = baseInvoker;
        }

        @Override
        public Object[] fixArgs(Object object, Object[] args) {
            int arrayLength = Array.getLength(object);
            ArrayList<Object> objectCollection = new ArrayList<Object>(arrayLength);
            for (int i = 0; i < arrayLength; ++i) {
                objectCollection.add(Array.get(object, i));
            }
            return this.baseInvoker.fixArgs(objectCollection, args);
        }

        @Override
        public WrappedMethod findMethod(Class jeClazz, String methodName, Object object, Object[] args) {
            if (!object.getClass().isArray()) {
                return null;
            }
            return this.baseInvoker.findMethod(jeClazz, methodName, new ArrayList(0), args);
        }
    }

    static class RegularArgsInvoker
    implements Invoker {
        RegularArgsInvoker() {
        }

        @Override
        public Object[] fixArgs(Object object, Object[] args) {
            Object[] jeArgs = new Object[args.length + 1];
            jeArgs[0] = object;
            for (int i = 0; i < args.length; ++i) {
                Object arg = args[i];
                if (arg == null) continue;
                jeArgs[i + 1] = arg;
            }
            return jeArgs;
        }

        @Override
        public WrappedMethod findMethod(Class jeClazz, String methodName, Object object, Object[] args) {
            Class[] jeArgsTypes = new Class[args.length + 1];
            jeArgsTypes[0] = object.getClass();
            for (int i = 0; i < args.length; ++i) {
                Object arg = args[i];
                if (arg == null) continue;
                jeArgsTypes[i + 1] = arg.getClass();
            }
            Method m = MethodUtils.getMatchingAccessibleMethod((Class)jeClazz, (String)methodName, (Class[])jeArgsTypes);
            if (m == null) {
                return null;
            }
            return new WrappedJavaMethod(m);
        }
    }

    static interface Invoker {
        public Object[] fixArgs(Object var1, Object[] var2);

        public WrappedMethod findMethod(Class var1, String var2, Object var3, Object[] var4);
    }

    static class WrappedGroovyMetaMethod
    implements WrappedMethod {
        private final MetaMethod m;

        WrappedGroovyMetaMethod(MetaMethod m) {
            this.m = m;
        }

        @Override
        public Object invoke(Object o, Object[] args) throws Exception {
            return this.m.invoke(o, args);
        }
    }

    static class WrappedJavaMethod
    implements WrappedMethod {
        private final Method m;

        WrappedJavaMethod(Method m) {
            this.m = m;
        }

        @Override
        public Object invoke(Object o, Object[] args) throws Exception {
            return this.m.invoke(o, args);
        }
    }

    static interface WrappedMethod {
        public Object invoke(Object var1, Object[] var2) throws Exception;
    }
}

