/*
 * Decompiled with CFR 0.152.
 */
package play.template2.compile;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import play.template2.GTFastTagResolver;
import play.template2.GTFileResolver;
import play.template2.GTGroovyBase;
import play.template2.GTJavaBase;
import play.template2.GTLineMapper;
import play.template2.GTTemplateLocation;
import play.template2.GTTemplateLocationReal;
import play.template2.GTTemplateRepo;
import play.template2.compile.GTInternalFastTags;
import play.template2.compile.GTInternalTagsCompiler;
import play.template2.exceptions.GTCompilationException;
import play.template2.exceptions.GTCompilationExceptionWithSourceInfo;
import play.template2.legacy.GTLegacyFastTagResolver;

public class GTPreCompiler {
    public static final int maxPlainTextLength = 60000;
    public static String generatedPackageName = "play.template2.generated_templates";
    private GTInternalTagsCompiler gtInternalTagsCompiler = new GTInternalTagsCompiler();
    private Map<String, String> expression2GroovyMethodLookup = null;
    private Map<String, String> tagArgs2GroovyMethodLookup = null;
    public GTFastTagResolver customFastTagResolver = null;
    private final String varName = "ev";
    private final GTTemplateRepo templateRepo;
    static Pattern alwaysPimpGroovyP = Pattern.compile("^\\s*\\*\\{\\s*alwaysPimpGroovy\\s*\\}\\*\\s*$");
    static final Pattern partsP = Pattern.compile("([#\\$&]|@?@)\\{|(\\*\\{)|(%\\{)");
    final Pattern tagBodyP = Pattern.compile("([^\\s]+)(?:\\s*$|\\s+(.+))");
    static final Pattern endCommentP = Pattern.compile("\\}\\*");
    static final Pattern endScriptP = Pattern.compile("\\}%");
    static final Pattern findEndBracketOrStringStart = Pattern.compile("(\\}|'|\")");
    private static Pattern validCodeString = Pattern.compile("^[A-Za-z_1234567890@]+$");

    public GTPreCompiler(GTTemplateRepo templateRepo) {
        this.templateRepo = templateRepo;
    }

    public Output compile(GTTemplateLocation templateLocation) {
        String src = templateLocation.readSource();
        return this.compile(src, templateLocation);
    }

    public Output compile(String src, GTTemplateLocation templateLocation) {
        String[] lines = src.split("\\n");
        return this.internalCompile(lines, templateLocation);
    }

    protected Output internalCompile(String[] lines, GTTemplateLocation templateLocation) {
        this.expression2GroovyMethodLookup = new HashMap<String, String>();
        this.tagArgs2GroovyMethodLookup = new HashMap<String, String>();
        SourceContext sc = new SourceContext(templateLocation);
        sc.lines = lines;
        GTFragment fragment = null;
        ArrayList<GTFragment> rootFragments = new ArrayList<GTFragment>();
        String templateClassName = GTPreCompiler.generateTemplateClassname(templateLocation.relativePath);
        String templateClassNameGroovy = templateClassName + "G";
        sc.gprintln("package " + generatedPackageName + ";");
        sc.gprintln("class " + templateClassNameGroovy + " extends " + this.getGroovyBaseClass().getName() + " {");
        sc.jprintln("package " + generatedPackageName + ";");
        sc.jprintln("import java.util.*;");
        sc.jprintln("import java.io.*;");
        sc.jprintln("import play.template2.GTLineMapper;");
        sc.jprintln("public class " + templateClassName + " extends " + this.getJavaBaseClass().getName() + " {");
        sc.jprintln(" private " + templateClassNameGroovy + " g;");
        sc.jprintln(" public " + templateClassName + "() {");
        sc.jprintln("  super(" + templateClassNameGroovy + ".class, new play.template2.GTTemplateLocation(\"" + templateLocation.relativePath + "\"));");
        sc.jprintln(" }");
        rootFragments.add(new GTFragmentCode(1, "  this.g = (" + templateClassNameGroovy + ")groovyScript;\n"));
        while ((fragment = this.processNextFragment(sc)) != null) {
            rootFragments.add(fragment);
        }
        this.generateCodeForGTFragments(sc, rootFragments, "_renderTemplate");
        sc.gprintln("}");
        String[] javaLines = sc._out.toString().split("\n");
        GTLineMapper javaLineMapper = new GTLineMapper(javaLines);
        String[] groovyLines = sc._gout.toString().split("\n");
        GTLineMapper groovyLineMapper = new GTLineMapper(groovyLines);
        sc.jprintln(" private static GTLineMapper javaLineMapper = new GTLineMapper(new Integer[]{" + javaLineMapper.getLineLookupAsString() + "});");
        sc.jprintln(" private static GTLineMapper groovyLineMapper = new GTLineMapper(new Integer[]{" + groovyLineMapper.getLineLookupAsString() + "});");
        sc.jprintln(" public static GTLineMapper getJavaLineMapper() { return javaLineMapper;}");
        sc.jprintln(" public static GTLineMapper getGroovyLineMapper() { return groovyLineMapper;}");
        sc.jprintln("}");
        return new Output(generatedPackageName + "." + templateClassName, sc._out.toString(), generatedPackageName + "." + templateClassNameGroovy, sc._gout.toString(), javaLineMapper, groovyLineMapper);
    }

    public static String generateTemplateClassname(String relativePath) {
        return "GTTemplate_" + GTPreCompiler.fixStringForCode(relativePath.replaceAll("[\\{\\}/\\\\\\.:!]", "_"), null);
    }

    protected int findEndBracket(String line, int offset, SourceContext sc, int lineNo) {
        Matcher m = findEndBracketOrStringStart.matcher(line);
        block0: while (offset < line.length()) {
            if (!m.find(offset)) {
                return -1;
            }
            String what = m.group(1);
            if ("}".equals(what)) {
                return m.start(1);
            }
            String stringType = what;
            offset = m.end(1);
            do {
                if ((offset = line.indexOf(what, offset)) < 0) {
                    throw new GTCompilationExceptionWithSourceInfo("Found unclosed string inside tag-definition", sc.templateLocation, lineNo);
                }
                if (line.charAt(offset - 1) == '\\') continue;
                ++offset;
                continue block0;
            } while (++offset < line.length());
            throw new GTCompilationExceptionWithSourceInfo("Found unclosed string inside tag-definition", sc.templateLocation, lineNo);
        }
        return -1;
    }

    /*
     * Enabled aggressive block sorting
     */
    protected GTFragment processNextFragment(SourceContext sc) {
        int startLine = sc.currentLineNo;
        int startOffset = sc.lineOffset;
        boolean insideComment = false;
        boolean insideScript = false;
        boolean insideTagExpressionEtc = false;
        int commentStartLine = 0;
        int scriptStartLine = 0;
        int scriptStartOffset = 0;
        int tagExpressionEtcStartLine = 0;
        int tagExpressionEtcStartOffset = 0;
        String tagExpressionEtcTypeFound = null;
        while (sc.currentLineNo < sc.lines.length) {
            Matcher m;
            String currentLine;
            block29: {
                currentLine = sc.lines[sc.currentLineNo];
                if (insideComment) {
                    Matcher m2 = endCommentP.matcher(currentLine);
                    if (m2.find(sc.lineOffset)) {
                        sc.lineOffset = m2.end();
                        insideComment = false;
                        startLine = sc.currentLineNo;
                        startOffset = sc.lineOffset;
                        continue;
                    }
                    ++sc.currentLineNo;
                    sc.lineOffset = 0;
                    continue;
                }
                if (insideScript) {
                    Matcher m3 = endScriptP.matcher(currentLine);
                    if (m3.find(sc.lineOffset)) {
                        String scriptPlainText = this.checkForPlainText(sc, scriptStartLine, scriptStartOffset, m3.start());
                        sc.lineOffset = m3.end();
                        if (scriptPlainText != null) {
                            return new GTFragmentScript(scriptStartLine, scriptPlainText);
                        }
                        insideScript = false;
                        break block29;
                    } else {
                        ++sc.currentLineNo;
                        sc.lineOffset = 0;
                        continue;
                    }
                }
                if (insideTagExpressionEtc) {
                    int endPos = this.findEndBracket(currentLine, sc.lineOffset, sc, tagExpressionEtcStartLine);
                    if (endPos >= 0) {
                        insideTagExpressionEtc = false;
                        String tagBody = this.checkForPlainText(sc, tagExpressionEtcStartLine, tagExpressionEtcStartOffset, endPos);
                        sc.lineOffset = endPos + 1;
                        if (tagBody == null) {
                            throw new GTCompilationExceptionWithSourceInfo("Found empty inside tag/expression/etc..", sc.templateLocation, tagExpressionEtcStartLine);
                        }
                        tagBody = tagBody.substring(2);
                        tagBody = tagBody.replaceAll("\\r?\\n", " ");
                        if ("#".equals(tagExpressionEtcTypeFound)) {
                            Matcher m4;
                            boolean tagWithoutBody;
                            boolean endedTag = tagBody.startsWith("/");
                            if (endedTag) {
                                tagBody = tagBody.substring(1);
                            }
                            if (tagWithoutBody = tagBody.endsWith("/")) {
                                tagBody = tagBody.substring(0, tagBody.length() - 1);
                            }
                            if (!(m4 = this.tagBodyP.matcher(tagBody)).find()) {
                                throw new GTCompilationExceptionWithSourceInfo("closing tag has no tag-name", sc.templateLocation, tagExpressionEtcStartLine);
                            }
                            String tagName = m4.group(1);
                            String tagArgString = m4.group(2);
                            if (tagArgString == null) {
                                tagArgString = "";
                            }
                            if (endedTag) {
                                return new GTFragmentEndOfMultiLineTag(tagExpressionEtcStartLine, tagName);
                            }
                            return this.processTag(sc, tagName, tagArgString, tagWithoutBody);
                        }
                        if ("$".equals(tagExpressionEtcTypeFound)) {
                            String expression = tagBody;
                            return this.generateExpressionPrinter(expression, sc, tagExpressionEtcStartLine);
                        }
                        if ("@".equals(tagExpressionEtcTypeFound) || "@@".equals(tagExpressionEtcTypeFound)) {
                            boolean absolute = "@@".equals(tagExpressionEtcTypeFound);
                            if (absolute) {
                                tagBody = tagBody.substring(1);
                            }
                            String action = tagBody;
                            return this.generateRegularActionPrinter(absolute, action, sc, tagExpressionEtcStartLine);
                        }
                        if ("&".equals(tagExpressionEtcTypeFound)) {
                            String messageArgs = tagBody;
                            return this.generateMessagePrinter(tagExpressionEtcStartLine, messageArgs, sc);
                        }
                        throw new GTCompilationExceptionWithSourceInfo("Don't know how to handle type '" + tagExpressionEtcTypeFound + "'", sc.templateLocation, tagExpressionEtcStartLine + 1);
                    }
                    ++sc.currentLineNo;
                    sc.lineOffset = 0;
                    continue;
                }
            }
            if ((m = partsP.matcher(currentLine)).find(sc.lineOffset)) {
                boolean scriptStart;
                String plainText = this.checkForPlainText(sc, startLine, startOffset, m.start());
                if (plainText != null) {
                    return this.createGTFragmentCodeForPlainText(startLine, plainText);
                }
                sc.lineOffset = m.end();
                int correctOffset = m.start();
                tagExpressionEtcTypeFound = m.group(1);
                boolean commentStart = m.group(2) != null;
                boolean bl = scriptStart = m.group(3) != null;
                if (commentStart) {
                    insideComment = true;
                    commentStartLine = sc.currentLineNo;
                    continue;
                }
                if (scriptStart) {
                    insideScript = true;
                    scriptStartLine = sc.currentLineNo;
                    scriptStartOffset = m.end();
                    continue;
                }
                if (tagExpressionEtcTypeFound == null) {
                    throw new GTCompilationException("Strange parser error..");
                }
                insideTagExpressionEtc = true;
                tagExpressionEtcStartLine = sc.currentLineNo;
                tagExpressionEtcStartOffset = m.start();
                continue;
            }
            ++sc.currentLineNo;
            sc.lineOffset = 0;
        }
        if (insideComment) {
            throw new GTCompilationExceptionWithSourceInfo("Found open comment", sc.templateLocation, commentStartLine + 1);
        }
        if (insideScript) {
            throw new GTCompilationExceptionWithSourceInfo("Found open script-block", sc.templateLocation, scriptStartLine + 1);
        }
        if (insideTagExpressionEtc) {
            throw new GTCompilationExceptionWithSourceInfo("Found open " + tagExpressionEtcTypeFound + "-declaration", sc.templateLocation, tagExpressionEtcStartLine + 1);
        }
        String plainText = this.checkForPlainText(sc, startLine, startOffset, -1);
        if (plainText != null) {
            return this.createGTFragmentCodeForPlainText(startLine, plainText);
        }
        return null;
    }

    protected String checkAndPatchActionStringsInTagArguments(String tagArguments) {
        return tagArguments;
    }

    protected GTFragmentCode generateRegularActionPrinter(boolean absolute, String expression, SourceContext sc, int lineNo) {
        throw new GTCompilationException("actions not supported - override to implement it");
    }

    private GTFragmentCode generateExpressionPrinter(String expression, SourceContext sc, int lineNo) {
        String methodName = this.generateGroovyExpressionResolver(expression, sc);
        String javaCode = "ev = g." + methodName + "();\n" + "if (" + "ev" + "!=null) out.append( objectToString(" + "ev" + "));\n";
        return new GTFragmentCode(lineNo, javaCode);
    }

    private String generateGroovyExpressionResolver(String expression, SourceContext sc) {
        String methodName = this.expression2GroovyMethodLookup.get(expression);
        if (methodName == null) {
            methodName = "expression_" + sc.nextMethodIndex++;
            sc.gprintln("");
            sc.gprintln("");
            sc.gprintln("Object " + methodName + "() {", sc.currentLineNo);
            sc.gprintln(" try{");
            sc.gprintln("  return " + expression + ";");
            sc.gprintln(" }catch(Throwable e){");
            sc.gprintln("  throw new play.template2.exceptions.GTRuntimeExceptionForwarder(e);");
            sc.gprintln(" }");
            sc.gprintln("}");
            this.expression2GroovyMethodLookup.put(expression, methodName);
        }
        return methodName;
    }

    private GTFragmentCode generateMessagePrinter(int startLine, String messageArgs, SourceContext sc) {
        String methodName = this.generateGroovyExpressionResolver("[" + messageArgs + "]", sc);
        String javaCode = "out.append( handleMessageTag(g." + methodName + "()));\n";
        return new GTFragmentCode(startLine, javaCode);
    }

    private GTFragmentCode createGTFragmentCodeForPlainText(int startLine, String plainText) {
        if (plainText == null) {
            return null;
        }
        String oneLiner = plainText.replace("\\", "\\\\").replaceAll("\"", "\\\\\"").replaceAll("\n", "\\\\n").replaceAll("\r", "\\\\r");
        if (oneLiner.length() > 0) {
            return new GTFragmentCode(startLine, "out.append(\"" + oneLiner + "\");");
        }
        return null;
    }

    private String checkForPlainText(SourceContext sc, int startLine, int startOffset, int endOfLastLine) {
        if (sc.currentLineNo == startLine && sc.lineOffset == startOffset && sc.lineOffset == endOfLastLine) {
            return null;
        }
        StringBuilder sb = new StringBuilder();
        for (int line = startLine; line <= sc.currentLineNo && line < sc.lines.length; ++line) {
            if (line == startLine) {
                if (startLine == sc.currentLineNo) {
                    sb.append(sc.lines[line].substring(startOffset, endOfLastLine));
                    break;
                }
                sb.append(sc.lines[line].substring(startOffset));
                continue;
            }
            if (line < sc.currentLineNo) {
                sb.append("\n");
                sb.append(sc.lines[line]);
                continue;
            }
            sb.append("\n");
            if (endOfLastLine == -1) {
                sb.append(sc.lines[line]);
                continue;
            }
            sb.append(sc.lines[line].substring(0, endOfLastLine));
        }
        sc.lineOffset = endOfLastLine;
        String s = sb.toString();
        if (s.endsWith("\r")) {
            return s.substring(0, s.length() - 1);
        }
        return s;
    }

    protected GTFragment processTag(SourceContext sc, String tagName, String tagArgString, boolean tagWithoutBody) {
        ArrayList<GTFragment> body = new ArrayList<GTFragment>();
        return this.processTag(sc, tagName, tagArgString, tagWithoutBody, body);
    }

    protected GTFragment processTag(SourceContext sc, String tagName, String tagArgString, boolean tagWithoutBody, List<GTFragment> body) {
        int startLine = sc.currentLineNo;
        if (tagWithoutBody) {
            return this.generateTagCode(startLine, tagName, tagArgString, sc, body);
        }
        GTFragment nextFragment = null;
        while ((nextFragment = this.processNextFragment(sc)) != null) {
            if (nextFragment instanceof GTFragmentEndOfMultiLineTag) {
                GTFragmentEndOfMultiLineTag f = (GTFragmentEndOfMultiLineTag)nextFragment;
                if (f.tagName.equals(tagName)) {
                    return this.generateTagCode(startLine, tagName, tagArgString, sc, body);
                }
                throw new GTCompilationExceptionWithSourceInfo("Found unclosed tag #{" + tagName + "}", sc.templateLocation, startLine + 1);
            }
            body.add(nextFragment);
        }
        throw new GTCompilationExceptionWithSourceInfo("Found unclosed tag #{" + tagName + "}", sc.templateLocation, startLine + 1);
    }

    private String generateGroovyCodeForTagArgs(SourceContext sc, String tagName, String tagArgString, int srcLine) {
        if (tagArgString == null || tagArgString.trim().length() == 0) {
            return " Map tagArgs = new HashMap();\n";
        }
        String methodName = this.tagArgs2GroovyMethodLookup.get(tagArgString = tagArgString.trim());
        if (methodName == null) {
            if (!tagArgString.matches("^[_a-zA-Z0-9]+\\s*:.*$")) {
                tagArgString = "arg:" + tagArgString;
            }
            tagArgString = this.checkAndPatchActionStringsInTagArguments(tagArgString);
            methodName = "args_" + GTPreCompiler.fixStringForCode(tagName, sc) + "_" + sc.nextMethodIndex++;
            sc.gprintln("");
            sc.gprintln("");
            sc.gprintln("Map<String, Object> " + methodName + "() {", srcLine);
            sc.gprintln(" try{");
            sc.gprintln("  return [" + tagArgString + "];", srcLine);
            sc.gprintln(" }catch(Throwable e){");
            sc.gprintln("  throw new play.template2.exceptions.GTRuntimeExceptionForwarder(e);");
            sc.gprintln(" }");
            sc.gprintln("}", srcLine);
            this.tagArgs2GroovyMethodLookup.put(tagArgString, methodName);
        }
        return " Map tagArgs = (Map)g." + methodName + "();\n";
    }

    protected static String fixStringForCode(String s, SourceContext sc) {
        if (!validCodeString.matcher(s = s.replaceAll("\\.", "_1").replaceAll("-", "_2").replaceAll("@", "_3")).find()) {
            if (sc != null) {
                throw new GTCompilationExceptionWithSourceInfo("Invalid string for code-usage: '" + s + "'", sc.templateLocation, sc.currentLineNo + 1);
            }
            throw new GTCompilationException("Invalid string for code-usage: '" + s + "'");
        }
        return s;
    }

    private String generateMethodName(String hint, SourceContext sc) {
        hint = GTPreCompiler.fixStringForCode(hint, sc);
        return "m_" + hint + "_" + sc.nextMethodIndex++;
    }

    private GTFragmentMethodCall generateTagCode(int startLine, String tagName, String tagArgString, SourceContext sc, List<GTFragment> body) {
        String javaCodeToGetRefToArgs = this.generateGroovyCodeForTagArgs(sc, tagName, tagArgString, startLine);
        String methodName = this.generateMethodName(tagName, sc);
        String contentMethodName = methodName + "_content";
        this.generateCodeForGTFragments(sc, body, contentMethodName);
        sc.jprintln("public void " + methodName + "() {", startLine);
        sc.jprintln(" this.enterTag(\"" + tagName + "\");", startLine);
        sc.jprintln(" try {", startLine);
        sc.jprintln(javaCodeToGetRefToArgs, startLine);
        if (!this.gtInternalTagsCompiler.generateCodeForGTFragments(tagName, contentMethodName, sc, startLine)) {
            String fullnameToFastTagMethod = new GTInternalFastTags().resolveFastTag(tagName);
            if (fullnameToFastTagMethod != null) {
                this.generateFastTagInvocation(sc, fullnameToFastTagMethod, contentMethodName);
            } else if (this.customFastTagResolver != null && (fullnameToFastTagMethod = this.customFastTagResolver.resolveFastTag(tagName)) != null) {
                this.generateFastTagInvocation(sc, fullnameToFastTagMethod, contentMethodName);
            } else {
                GTLegacyFastTagResolver legacyFastTagResolver = this.getGTLegacyFastTagResolver();
                GTLegacyFastTagResolver.LegacyFastTagInfo legacyFastTagInfo = null;
                if (legacyFastTagResolver != null && (legacyFastTagInfo = legacyFastTagResolver.resolveLegacyFastTag(tagName)) != null) {
                    this.generateLegacyFastTagInvocation(tagName, sc, legacyFastTagInfo, contentMethodName);
                } else {
                    String tagNamePath = tagName.replace('.', '/');
                    String thisTemplateType = this.getTemplateType(sc);
                    String tagFilePath = "tags/" + tagNamePath + "." + thisTemplateType;
                    GTTemplateLocationReal tagTemplateLocation = GTFileResolver.impl.getTemplateLocationReal(tagFilePath);
                    if (this.templateRepo != null && thisTemplateType != null && this.templateRepo.templateExists(tagTemplateLocation)) {
                        this.generateTagFileInvocation(tagName, tagFilePath, sc, contentMethodName);
                    } else {
                        tagFilePath = "tags/" + tagNamePath + ".tag";
                        tagTemplateLocation = GTFileResolver.impl.getTemplateLocationReal(tagFilePath);
                        if (this.templateRepo != null && this.templateRepo.templateExists(tagTemplateLocation)) {
                            this.generateTagFileInvocation(tagName, tagFilePath, sc, contentMethodName);
                        } else {
                            throw new GTCompilationExceptionWithSourceInfo("Cannot find tag-implementation for '" + tagName + "'", sc.templateLocation, sc.currentLineNo + 1);
                        }
                    }
                }
            }
        }
        sc.jprintln("} finally {", startLine);
        sc.jprintln(" this.leaveTag(\"" + tagName + "\");", startLine);
        sc.jprintln("}", startLine);
        sc.jprintln("}", startLine);
        return new GTFragmentMethodCall(startLine, methodName);
    }

    private String getTemplateType(SourceContext sc) {
        String path = sc.templateLocation.relativePath;
        int i = path.lastIndexOf(46);
        if (i < 0) {
            return null;
        }
        return path.substring(i + 1);
    }

    private void generateFastTagInvocation(SourceContext sc, String fullnameToFastTagMethod, String contentMethodName) {
        String contentRendererName = "cr_" + sc.nextMethodIndex++;
        this.generateGTContentRenderer(sc, contentMethodName, contentRendererName);
        sc.jprintln(fullnameToFastTagMethod + "(this, tagArgs, " + contentRendererName + ");", sc.currentLineNo);
    }

    protected static void generateContentOutputCapturing(String contentMethodName, String outputVariableName, SourceContext sc, int line) {
        sc.jprintln("//generateContentOutputCapturing", line);
        sc.jprintln("StringWriter org = out;");
        sc.jprintln("List<StringWriter> orgAllOuts = allOuts;");
        sc.jprintln("allOuts = new ArrayList<StringWriter>();");
        sc.jprintln("initNewOut();");
        sc.jprintln(contentMethodName + "();");
        sc.jprintln("List<StringWriter> " + outputVariableName + " = allOuts;");
        sc.jprintln("out = org;");
        sc.jprintln("allOuts = orgAllOuts;");
    }

    private void generateGTContentRenderer(SourceContext sc, String contentMethodName, String contentRendererName) {
        sc.jprintln(" play.template2.GTContentRenderer " + contentRendererName + " = new play.template2.GTContentRenderer(){\n" + "public play.template2.GTRenderingResult render(){", sc.currentLineNo);
        String outputVariableName = "ovn_" + sc.nextMethodIndex++;
        GTPreCompiler.generateContentOutputCapturing(contentMethodName, outputVariableName, sc, sc.currentLineNo);
        sc.jprintln("return new play.template2.GTRenderingResult(" + outputVariableName + ");", sc.currentLineNo);
        sc.jprintln(" }", sc.currentLineNo);
        sc.jprintln(" public Object getRuntimeProperty(String name){ try { return binding.getProperty(name); } catch (groovy.lang.MissingPropertyException mpe) { return null; }}", sc.currentLineNo);
        sc.jprintln(" public void setRuntimeProperty(String name, Object value){binding.setProperty(name, value);}", sc.currentLineNo);
        sc.jprintln(" };", sc.currentLineNo);
    }

    private void generateLegacyFastTagInvocation(String tagName, SourceContext sc, GTLegacyFastTagResolver.LegacyFastTagInfo legacyFastTagInfo, String contentMethodName) {
        String contentRendererName = "cr_" + sc.nextMethodIndex++;
        this.generateGTContentRenderer(sc, contentMethodName, contentRendererName);
        String fakeClosureName = contentRendererName + "_fc";
        sc.jprintln(" play.template2.legacy.GTContentRendererFakeClosure " + fakeClosureName + " = new play.template2.legacy.GTContentRendererFakeClosure(this, " + contentRendererName + ");", sc.currentLineNo);
        sc.jprintln(legacyFastTagInfo.bridgeFullMethodName + "(\"" + legacyFastTagInfo.legacyFastTagClassname + "\", \"" + legacyFastTagInfo.legacyFastTagMethodName + "\", this, tagArgs, " + fakeClosureName + ");", sc.currentLineNo);
    }

    private void generateTagFileInvocation(String tagName, String tagFilePath, SourceContext sc, String contentMethodName) {
        String contentRendererName = "cr_" + sc.nextMethodIndex++;
        this.generateGTContentRenderer(sc, contentMethodName, contentRendererName);
        sc.jprintln(" this.invokeTagFile(\"" + tagName + "\",\"" + tagFilePath + "\", " + contentRendererName + ", tagArgs);", sc.currentLineNo);
    }

    private void generateCodeForGTFragments(SourceContext sc, List<GTFragment> body, String methodName) {
        sc.jprintln("public void " + methodName + "() {", sc.currentLineNo);
        sc.jprintln(" Object ev;", sc.currentLineNo);
        for (GTFragment f : body) {
            if (f instanceof GTFragmentMethodCall) {
                GTFragmentMethodCall m = (GTFragmentMethodCall)f;
                sc.jprintln("  " + m.methodName + "();", sc.currentLineNo);
                continue;
            }
            if (f instanceof GTFragmentCode) {
                GTFragmentCode c = (GTFragmentCode)f;
                if (c.code.length() <= 0) continue;
                sc.jprintln("  " + c.code + "", sc.currentLineNo);
                continue;
            }
            if (f instanceof GTFragmentScript) {
                GTFragmentScript s = (GTFragmentScript)f;
                String groovyMethodName = "custom_script_" + sc.nextMethodIndex++;
                sc.gprintln("");
                sc.gprintln("");
                sc.gprintln("void " + groovyMethodName + "(java.io.PrintWriter out){", s.startLine);
                int tryStartLine = s.startLine;
                sc.gprintln(" try{");
                int lineNo = s.startLine;
                for (String line : s.scriptSource.split("\\r?\\n", -1)) {
                    sc.gprintln(line, lineNo++);
                }
                sc.gprintln(" }catch(Throwable e){", tryStartLine);
                sc.gprintln("  throw new play.template2.exceptions.GTRuntimeExceptionForwarder(e);");
                sc.gprintln(" }");
                sc.gprintln("}", lineNo);
                sc.jprintln(" g." + groovyMethodName + "(new PrintWriter(out));", s.startLine);
                continue;
            }
            if (f instanceof GTFragmentEndOfMultiLineTag) {
                GTFragmentEndOfMultiLineTag _f = (GTFragmentEndOfMultiLineTag)f;
                throw new GTCompilationExceptionWithSourceInfo("#{/" + _f.tagName + "} is not opened.", sc.templateLocation, f.startLine + 1);
            }
            throw new GTCompilationExceptionWithSourceInfo("Unknown GTFragment-type " + f, sc.templateLocation, f.startLine + 1);
        }
        sc.jprintln("}", sc.currentLineNo);
    }

    public Class<? extends GTGroovyBase> getGroovyBaseClass() {
        return GTGroovyBase.class;
    }

    public Class<? extends GTJavaBase> getJavaBaseClass() {
        return GTJavaBase.class;
    }

    public GTLegacyFastTagResolver getGTLegacyFastTagResolver() {
        return null;
    }

    public static class GTFragmentEndOfMultiLineTag
    extends GTFragment {
        public final String tagName;

        public GTFragmentEndOfMultiLineTag(int startLine, String tagName) {
            super(startLine);
            this.tagName = tagName;
        }
    }

    public static class GTFragmentScript
    extends GTFragment {
        public final String scriptSource;

        public GTFragmentScript(int startLine, String scriptSource) {
            super(startLine);
            this.scriptSource = scriptSource;
        }
    }

    public static class GTFragmentCode
    extends GTFragment {
        public final String code;

        public GTFragmentCode(int startLine, String code) {
            super(startLine);
            this.code = code;
        }
    }

    public static class GTFragmentMethodCall
    extends GTFragment {
        public final String methodName;

        public GTFragmentMethodCall(int startLine, String methodName) {
            super(startLine);
            this.methodName = methodName;
        }
    }

    public static class GTFragment {
        public final int startLine;

        public GTFragment(int startLine) {
            this.startLine = startLine;
        }
    }

    public static class Output {
        public final String javaClassName;
        public final String javaCode;
        public final String groovyClassName;
        public final String groovyCode;
        public final GTLineMapper javaLineMapper;
        public final GTLineMapper groovyLineMapper;

        public Output(String javaClassName, String javaCode, String groovyClassName, String groovyCode, GTLineMapper javaLineMapper, GTLineMapper groovyLineMapper) {
            this.javaClassName = javaClassName;
            this.javaCode = javaCode;
            this.groovyClassName = groovyClassName;
            this.groovyCode = groovyCode;
            this.javaLineMapper = javaLineMapper;
            this.groovyLineMapper = groovyLineMapper;
        }

        public String toString() {
            return "Output[->\njavaCode=\n" + this.javaCode + '\n' + "--------------\n" + "groovyCode=\n" + this.groovyCode + '\n' + "<-]";
        }
    }

    public static class SourceContext {
        public final GTTemplateLocation templateLocation;
        public StringBuilder _out = new StringBuilder();
        public StringBuilder _gout = new StringBuilder();
        public String[] lines;
        public int currentLineNo;
        public int lineOffset;
        public int nextMethodIndex = 0;

        public SourceContext(GTTemplateLocation templateLocation) {
            this.templateLocation = templateLocation;
        }

        public void jprintln(String line) {
            this._out.append(line + "\n");
        }

        public void jprintln(String line, int lineNo) {
            this._out.append(line + "//lineNo:" + (lineNo + 1) + "\n");
        }

        public void gprintln(String line) {
            this._gout.append(line + "\n");
        }

        public void gprintln(String line, int lineNo) {
            this._gout.append(line + "//lineNo:" + (lineNo + 1) + "\n");
        }

        public String toString() {
            return "SourceContext{lineOffset=" + this.lineOffset + ", currentLineNo=" + this.currentLineNo + ", templateLocation=" + this.templateLocation + '}';
        }
    }
}

