/*
 * Decompiled with CFR 0.152.
 */
package play.template2.compile;

import java.io.ByteArrayOutputStream;
import java.io.UnsupportedEncodingException;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import play.template2.GTContentRenderer;
import play.template2.GTFastTag;
import play.template2.GTJavaBase;
import play.template2.GTRenderingResult;
import play.template2.GTTagContext;
import play.template2.GTTemplateLocationReal;
import play.template2.exceptions.GTTemplateRuntimeException;
import play.template2.legacy.GTContentRendererFakeClosure;

public class GTInternalFastTags
extends GTFastTag {
    public static void tag_get(GTJavaBase template, Map<String, Object> args, GTContentRenderer content) {
        String key = args.get("arg").toString();
        if (key == null) {
            throw new GTTemplateRuntimeException("Specify a variable name when using #{get/}");
        }
        Object value = GTJavaBase.layoutData.get().get(key);
        if (value != null) {
            template.out.append(value.toString());
        } else if (content != null) {
            template.insertOutput(content.render());
        }
    }

    public static void tag_set(GTJavaBase template, Map<String, Object> args, GTContentRenderer content) {
        String key = null;
        Object value = null;
        for (String k : args.keySet()) {
            if ("arg".equals(k)) continue;
            key = k;
            Object v = args.get(key);
            if (v instanceof String) {
                value = template.objectToString(v);
                break;
            }
            value = v;
            break;
        }
        if (key == null) {
            key = args.get("arg").toString();
            ByteArrayOutputStream out = new ByteArrayOutputStream();
            String encoding = (String)content.getRuntimeProperty("_response_encoding");
            if (encoding == null) {
                encoding = "utf-8";
            }
            content.render().writeOutput(out, encoding);
            try {
                value = out.toString(encoding);
            }
            catch (UnsupportedEncodingException e) {
                throw new RuntimeException(e);
            }
        }
        if (key != null) {
            GTJavaBase.layoutData.get().put(key, value);
        }
    }

    public static void tag_ifErrors(GTJavaBase template, Map<String, Object> args, GTContentRenderer content) {
        if (template.validationHasErrors()) {
            template.clearElseFlag();
            template.insertOutput(content.render());
        } else {
            template.setElseFlag();
        }
    }

    public static void tag_ifError(GTJavaBase template, Map<String, Object> args, GTContentRenderer content) {
        Object key = args.get("arg");
        if (key == null) {
            throw new GTTemplateRuntimeException("Please specify the error key");
        }
        if (template.validationHasError(key.toString())) {
            template.clearElseFlag();
            template.insertOutput(content.render());
        } else {
            template.setElseFlag();
        }
    }

    public static void tag_include(GTJavaBase template, Map<String, Object> args, GTContentRenderer content) {
        if (!args.containsKey("arg") || args.get("arg") == null) {
            throw new GTTemplateRuntimeException("Specify a template name");
        }
        String name = args.get("arg").toString();
        GTTemplateLocationReal templateLocation = template.resolveTemplateLocation(name);
        if (templateLocation == null) {
            throw new GTTemplateRuntimeException("Cannot find template");
        }
        GTJavaBase newTemplate = template.templateRepo.getTemplateInstance(templateLocation);
        HashMap<String, Object> newArgs = new HashMap<String, Object>();
        newArgs.putAll(template.binding.getVariables());
        newArgs.put("_isInclude", true);
        newTemplate.internalRenderTemplate(newArgs, false, template);
        template.insertOutput(newTemplate);
    }

    public static void tag_render(GTJavaBase template, Map<String, Object> args, GTContentRenderer content) {
        if (!args.containsKey("arg") || args.get("arg") == null) {
            throw new GTTemplateRuntimeException("Specify a template name");
        }
        String name = args.get("arg").toString();
        GTTemplateLocationReal templateLocation = template.resolveTemplateLocation(name);
        if (templateLocation == null) {
            throw new GTTemplateRuntimeException("Cannot find template");
        }
        GTJavaBase newTemplate = template.templateRepo.getTemplateInstance(templateLocation);
        HashMap<String, Object> newArgs = new HashMap<String, Object>();
        newArgs.putAll(args);
        newArgs.put("_isInclude", true);
        newTemplate.internalRenderTemplate(newArgs, false, template);
        template.insertOutput(newTemplate);
    }

    public static void tag_doBody(GTJavaBase template, Map<String, Object> args, GTContentRenderer _content) {
        String as;
        GTContentRenderer body = template.contentRenderer;
        GTContentRendererFakeClosure bodyClosure = (GTContentRendererFakeClosure)((Object)args.get("body"));
        if (bodyClosure != null) {
            body = bodyClosure.contentRenderer;
        }
        Map vars = (Map)args.get("vars");
        HashSet<String> propertiesToResetToNull = new HashSet<String>();
        if (vars != null) {
            for (Map.Entry e : vars.entrySet()) {
                String key = (String)e.getKey();
                if (body.getRuntimeProperty(key) == null) {
                    propertiesToResetToNull.add(key);
                }
                body.setRuntimeProperty(key, e.getValue());
            }
        }
        if ((as = (String)args.get("as")) == null) {
            template.insertOutput(body.render());
        } else {
            String contentString;
            ByteArrayOutputStream out = new ByteArrayOutputStream();
            body.render().writeOutput(out, "utf-8");
            try {
                contentString = out.toString("utf-8");
            }
            catch (UnsupportedEncodingException e) {
                throw new RuntimeException(e);
            }
            body.setRuntimeProperty(as, contentString);
        }
        for (String key : propertiesToResetToNull) {
            body.setRuntimeProperty(key, null);
        }
    }

    public static void tag_cache(GTJavaBase template, Map<String, Object> args, GTContentRenderer _content) {
        Object cached;
        String key = args.get("arg").toString();
        String duration = null;
        if (args.containsKey("for")) {
            duration = args.get("for").toString();
        }
        if ((cached = template.cacheGet(key)) != null) {
            template.out.append(cached.toString());
            return;
        }
        GTRenderingResult renderingResult = _content.render();
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        renderingResult.writeOutput(out, "utf-8");
        String result = null;
        try {
            result = new String(out.toByteArray(), "utf-8");
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException(e);
        }
        template.cacheSet(key, result, duration);
        template.out.append(result);
    }

    public static void tag_verbatim(GTJavaBase template, Map<String, Object> args, GTContentRenderer _content) {
        template.insertOutput(_content.render());
    }

    public static void tag_jsAction(GTJavaBase template, Map<String, Object> args, GTContentRenderer _content) {
        template.out.append("function(options) {var pattern = '" + args.get("arg").toString().replace("&amp;", "&") + "'; for(key in options) { pattern = pattern.replace(':'+key, options[key]); } return pattern }");
    }

    public static void tag_option(GTJavaBase template, Map<String, Object> args, GTContentRenderer _content) {
        Object value = args.get("arg");
        Object selectedValue = GTTagContext.singleton.parent("select").getData().get("selected");
        boolean selected = selectedValue != null && value != null && selectedValue.toString().equals(value.toString());
        template.out.append("<option value=\"" + (value == null ? "" : value) + "\" " + (selected ? "selected=\"selected\"" : "") + " " + GTInternalFastTags.serialize(args, "selected", "value") + ">");
        template.insertOutput(_content.render());
        template.out.append("</option>");
    }

    public static void tag_errorClass(GTJavaBase template, Map<String, Object> args, GTContentRenderer _content) {
        if (args.get("arg") == null) {
            throw new GTTemplateRuntimeException("Please specify the error key");
        }
        if (template.validationHasError(args.get("arg").toString())) {
            template.out.append("hasError");
        }
    }

    public static String serialize(Map<?, ?> args, String ... unless) {
        StringBuilder attrs = new StringBuilder();
        Arrays.sort(unless);
        for (Object o : args.keySet()) {
            String value;
            String attr = o.toString();
            String string = value = args.get(o) == null ? "" : args.get(o).toString();
            if (Arrays.binarySearch(unless, attr) >= 0 || attr.equals("arg")) continue;
            attrs.append(attr);
            attrs.append("=\"");
            attrs.append(value);
            attrs.append("\" ");
        }
        return attrs.toString();
    }
}

