/*
 * Decompiled with CFR 0.152.
 */
package play.template2.compile;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.StringTokenizer;
import org.eclipse.jdt.core.compiler.CategorizedProblem;
import org.eclipse.jdt.internal.compiler.ClassFile;
import org.eclipse.jdt.internal.compiler.CompilationResult;
import org.eclipse.jdt.internal.compiler.Compiler;
import org.eclipse.jdt.internal.compiler.DefaultErrorHandlingPolicies;
import org.eclipse.jdt.internal.compiler.ICompilerRequestor;
import org.eclipse.jdt.internal.compiler.IErrorHandlingPolicy;
import org.eclipse.jdt.internal.compiler.IProblemFactory;
import org.eclipse.jdt.internal.compiler.ast.CompilationUnitDeclaration;
import org.eclipse.jdt.internal.compiler.classfmt.ClassFileReader;
import org.eclipse.jdt.internal.compiler.env.IBinaryType;
import org.eclipse.jdt.internal.compiler.env.ICompilationUnit;
import org.eclipse.jdt.internal.compiler.env.INameEnvironment;
import org.eclipse.jdt.internal.compiler.env.NameEnvironmentAnswer;
import org.eclipse.jdt.internal.compiler.problem.DefaultProblemFactory;
import play.template2.compile.GTTypeResolver;
import play.template2.exceptions.GTCompilationException;

public class GTJavaCompileToClass {
    public static String javaVersion = "1.5";
    public static GTTypeResolver typeResolver;
    private final ClassLoader parentClassLoader;
    Map<String, Boolean> packagesCache = new HashMap<String, Boolean>();
    Map<String, String> settings;

    public GTJavaCompileToClass(ClassLoader parentClassLoader) {
        this.parentClassLoader = parentClassLoader;
        this.settings = new HashMap<String, String>();
        this.settings.put("org.eclipse.jdt.core.compiler.problem.missingSerialVersion", "ignore");
        this.settings.put("org.eclipse.jdt.core.compiler.debug.lineNumber", "generate");
        this.settings.put("org.eclipse.jdt.core.compiler.debug.sourceFile", "generate");
        this.settings.put("org.eclipse.jdt.core.compiler.problem.deprecation", "ignore");
        this.settings.put("org.eclipse.jdt.core.compiler.problem.unusedImport", "ignore");
        this.settings.put("org.eclipse.jdt.core.encoding", "UTF-8");
        this.settings.put("org.eclipse.jdt.core.compiler.debug.localVariable", "generate");
        this.settings.put("org.eclipse.jdt.core.compiler.source", javaVersion);
        this.settings.put("org.eclipse.jdt.core.compiler.codegen.targetPlatform", javaVersion);
        this.settings.put("org.eclipse.jdt.core.compiler.codegen.unusedLocal", "preserve");
        this.settings.put("org.eclipse.jdt.core.compiler.compliance", javaVersion);
    }

    protected byte[] readContent(InputStream is) {
        try {
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            int read = 0;
            byte[] buffer = new byte[8096];
            while ((read = is.read(buffer)) > 0) {
                baos.write(buffer, 0, read);
            }
            return baos.toByteArray();
        }
        catch (IOException e) {
            throw new GTCompilationException(e);
        }
    }

    public CompiledClass[] compile(String className, String source) {
        CompilationUnit compilationUnits = new CompilationUnit(className, source);
        IErrorHandlingPolicy policy = DefaultErrorHandlingPolicies.exitOnFirstError();
        DefaultProblemFactory problemFactory = new DefaultProblemFactory(Locale.ENGLISH);
        INameEnvironment nameEnvironment = new INameEnvironment(){

            public NameEnvironmentAnswer findType(char[][] compoundTypeName) {
                StringBuffer result = new StringBuffer();
                for (int i = 0; i < compoundTypeName.length; ++i) {
                    if (i != 0) {
                        result.append('.');
                    }
                    result.append(compoundTypeName[i]);
                }
                return this.findType(result.toString());
            }

            public NameEnvironmentAnswer findType(char[] typeName, char[][] packageName) {
                StringBuffer result = new StringBuffer();
                for (int i = 0; i < packageName.length; ++i) {
                    result.append(packageName[i]);
                    result.append('.');
                }
                result.append(typeName);
                return this.findType(result.toString());
            }

            private NameEnvironmentAnswer findType(String name) {
                try {
                    byte[] bytes = typeResolver.getTypeBytes(name);
                    if (bytes == null) {
                        String resourceName = name.replace(".", "/") + ".class";
                        InputStream is = GTJavaCompileToClass.this.parentClassLoader.getResourceAsStream(resourceName);
                        if (is == null) {
                            return null;
                        }
                        bytes = GTJavaCompileToClass.this.readContent(is);
                        is.close();
                    }
                    ClassFileReader classFileReader = new ClassFileReader(bytes, name.toCharArray(), true);
                    return new NameEnvironmentAnswer((IBinaryType)classFileReader, null);
                }
                catch (Exception e) {
                    throw new RuntimeException(e);
                }
            }

            public boolean isPackage(char[][] parentPackageName, char[] packageName) {
                StringBuilder sb = new StringBuilder();
                if (parentPackageName != null) {
                    for (char[] p : parentPackageName) {
                        sb.append(new String(p));
                        sb.append(".");
                    }
                }
                sb.append(new String(packageName));
                String name = sb.toString();
                if (GTJavaCompileToClass.this.packagesCache.containsKey(name)) {
                    return GTJavaCompileToClass.this.packagesCache.get(name);
                }
                boolean isClass = false;
                try {
                    GTJavaCompileToClass.this.parentClassLoader.loadClass(name);
                    isClass = true;
                }
                catch (Exception e) {
                    // empty catch block
                }
                boolean isPackage = !isClass;
                GTJavaCompileToClass.this.packagesCache.put(name, isPackage);
                return isPackage;
            }

            public void cleanup() {
            }
        };
        MyICompilerRequestor compilerRequestor = new MyICompilerRequestor();
        Compiler jdtCompiler = new Compiler(nameEnvironment, policy, this.settings, compilerRequestor, (IProblemFactory)problemFactory){

            protected void handleInternalException(Throwable e, CompilationUnitDeclaration ud, CompilationResult result) {
            }
        };
        jdtCompiler.compile(new ICompilationUnit[]{compilationUnits});
        return compilerRequestor.compiledClasses;
    }

    public static class CompiledClass {
        public final String classname;
        public final byte[] bytes;

        public CompiledClass(String classname, byte[] bytes) {
            this.classname = classname;
            this.bytes = bytes;
        }
    }

    public static class MyICompilerRequestor
    implements ICompilerRequestor {
        public CompiledClass[] compiledClasses;

        public void acceptResult(CompilationResult result) {
            CategorizedProblem[] arr$;
            int len$;
            int i$;
            if (result.hasErrors() && (i$ = 0) < (len$ = (arr$ = result.getErrors()).length)) {
                CategorizedProblem problem = arr$[i$];
                String className = new String(problem.getOriginatingFileName()).replace("/", ".");
                className = className.substring(0, className.length() - 5);
                String message = problem.getMessage();
                if (problem.getID() == 268435843) {
                    message = problem.getArguments()[0] + " cannot be resolved";
                }
                throw new GTCompilationException("Compile error. classname: " + className + ". message: " + message + " ln: " + problem.getSourceLineNumber());
            }
            this.compiledClasses = new CompiledClass[result.getClassFiles().length];
            ClassFile[] clazzFiles = result.getClassFiles();
            for (int i = 0; i < clazzFiles.length; ++i) {
                ClassFile clazzFile = clazzFiles[i];
                char[][] compoundName = clazzFile.getCompoundName();
                StringBuffer clazzName = new StringBuffer();
                for (int j = 0; j < compoundName.length; ++j) {
                    if (j != 0) {
                        clazzName.append('.');
                    }
                    clazzName.append(compoundName[j]);
                }
                this.compiledClasses[i] = new CompiledClass(clazzName.toString(), clazzFile.getBytes());
            }
        }
    }

    final class CompilationUnit
    implements ICompilationUnit {
        private final String clazzName;
        private final String fileName;
        private final char[] typeName;
        private final char[][] packageName;
        private final String source;

        CompilationUnit(String pClazzName, String source) {
            this.clazzName = pClazzName;
            this.fileName = pClazzName.replaceAll("\\.", "/") + ".java";
            int dot = pClazzName.lastIndexOf(46);
            this.typeName = dot > 0 ? pClazzName.substring(dot + 1).toCharArray() : pClazzName.toCharArray();
            StringTokenizer izer = new StringTokenizer(pClazzName, ".");
            this.packageName = new char[izer.countTokens() - 1][];
            for (int i = 0; i < this.packageName.length; ++i) {
                this.packageName[i] = izer.nextToken().toCharArray();
            }
            this.source = source;
        }

        public char[] getFileName() {
            return this.fileName.toCharArray();
        }

        public char[] getContents() {
            return this.source.toCharArray();
        }

        public char[] getMainTypeName() {
            return this.typeName;
        }

        public char[][] getPackageName() {
            return this.packageName;
        }
    }
}

