/*
 * Decompiled with CFR 0.152.
 */
package play.template2.compile;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Arrays;
import play.template2.GTTemplateInstanceFactoryLive;
import play.template2.GTTemplateLocation;
import play.template2.GTTemplateRepo;
import play.template2.compile.GTGroovyCompileToClass;
import play.template2.compile.GTJavaCompileToClass;
import play.template2.compile.GTPreCompiler;
import play.template2.compile.GTPreCompilerFactory;

public class GTCompiler {
    public static File srcDestFolder = null;
    private final ClassLoader parentClassloader;
    private final GTTemplateRepo templateRepo;
    private final GTPreCompilerFactory preCompilerFactory;
    private final boolean storeSourceToDisk;

    public GTCompiler(ClassLoader parentClassloader, GTTemplateRepo templateRepo, GTPreCompilerFactory preCompilerFactory, boolean storeSourceToDisk) {
        this.parentClassloader = parentClassloader;
        this.templateRepo = templateRepo;
        this.preCompilerFactory = preCompilerFactory;
        this.storeSourceToDisk = storeSourceToDisk;
    }

    protected static void writeContent(CharSequence content, File file, String encoding) {
        FileOutputStream os = null;
        try {
            os = new FileOutputStream(file);
            PrintWriter printWriter = new PrintWriter(new OutputStreamWriter((OutputStream)os, encoding));
            printWriter.println(content);
            printWriter.flush();
            os.flush();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        finally {
            try {
                if (os != null) {
                    ((OutputStream)os).close();
                }
            }
            catch (Exception e) {}
        }
    }

    public CompiledTemplate compile(GTTemplateLocation templateLocation) {
        GTPreCompiler.Output precompiled = this.preCompilerFactory.createCompiler(this.templateRepo).compile(templateLocation);
        if (srcDestFolder != null && this.storeSourceToDisk) {
            File folder = new File(srcDestFolder, GTPreCompiler.generatedPackageName.replace('.', '/'));
            if (!folder.exists()) {
                folder.mkdirs();
            }
            File file = new File(folder, precompiled.javaClassName + ".java");
            GTCompiler.writeContent(precompiled.javaCode, file, "utf-8");
            file = new File(folder, precompiled.groovyClassName + ".groovy");
            GTCompiler.writeContent(precompiled.groovyCode, file, "utf-8");
        }
        GTJavaCompileToClass.CompiledClass[] groovyClasses = new GTGroovyCompileToClass(this.parentClassloader).compileGroovySource(templateLocation, precompiled.groovyLineMapper, precompiled.groovyCode);
        GTTemplateInstanceFactoryLive.CL cl = new GTTemplateInstanceFactoryLive.CL(this.parentClassloader, groovyClasses);
        GTJavaCompileToClass.CompiledClass[] compiledJavaClasses = new GTJavaCompileToClass(cl).compile(precompiled.javaClassName, precompiled.javaCode);
        ArrayList<GTJavaCompileToClass.CompiledClass> allCompiledClasses = new ArrayList<GTJavaCompileToClass.CompiledClass>();
        allCompiledClasses.addAll(Arrays.asList(compiledJavaClasses));
        allCompiledClasses.addAll(Arrays.asList(groovyClasses));
        return new CompiledTemplate(precompiled.javaClassName, allCompiledClasses.toArray(new GTJavaCompileToClass.CompiledClass[0]));
    }

    public static class CompiledTemplate {
        public final String templateClassName;
        public final GTJavaCompileToClass.CompiledClass[] compiledJavaClasses;

        public CompiledTemplate(String templateClassName, GTJavaCompileToClass.CompiledClass[] compiledJavaClasses) {
            this.templateClassName = templateClassName;
            this.compiledJavaClasses = compiledJavaClasses;
        }
    }
}

