/*
 * Decompiled with CFR 0.152.
 */
package play.modules.gtengineplugin;

import com.jamonapi.Monitor;
import com.jamonapi.MonitorFactory;
import java.io.ByteArrayOutputStream;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.util.Map;
import play.Play;
import play.exceptions.JavaExecutionException;
import play.exceptions.TemplateCompilationException;
import play.exceptions.TemplateExecutionException;
import play.exceptions.TemplateNotFoundException;
import play.i18n.Lang;
import play.i18n.Messages;
import play.modules.gtengineplugin.TemplateLoader;
import play.mvc.Http;
import play.template2.GTJavaBase;
import play.template2.GTRenderingResult;
import play.template2.GTTemplateLocation;
import play.template2.GTTemplateLocationReal;
import play.template2.exceptions.GTAppClassException;
import play.template2.exceptions.GTCompilationExceptionWithSourceInfo;
import play.template2.exceptions.GTRuntimeException;
import play.template2.exceptions.GTRuntimeExceptionWithSourceInfo;
import play.template2.exceptions.GTTemplateNotFoundWithSourceInfo;
import play.templates.Template;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GTTemplate
extends Template {
    private final GTTemplateLocation templateLocation;
    private final GTJavaBase gtJavaBase;

    public GTTemplate(GTTemplateLocation templateLocation, GTJavaBase gtJavaBase) {
        this.templateLocation = templateLocation;
        this.gtJavaBase = gtJavaBase;
        this.name = templateLocation.relativePath;
    }

    public GTTemplate(GTTemplateLocation templateLocation) {
        this.templateLocation = templateLocation;
        this.gtJavaBase = null;
        this.name = templateLocation.relativePath;
    }

    public void compile() {
    }

    protected String internalRender(Map<String, Object> args) {
        GTRenderingResult renderingResult = this.internalGTRender(args);
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        renderingResult.writeOutput((OutputStream)out, "utf-8");
        try {
            return new String(out.toByteArray(), "utf-8");
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException(e);
        }
    }

    public GTRenderingResult internalGTRender(Map<String, Object> args) {
        Http.Request currentResponse = Http.Request.current();
        if (currentResponse != null) {
            args.put("_response_encoding", currentResponse.encoding);
        }
        args.put("play", new Play());
        args.put("messages", new Messages());
        args.put("lang", Lang.get());
        return this.renderGTTemplate(args);
    }

    protected GTJavaBase getGTTemplateInstance() {
        if (this.gtJavaBase == null) {
            return TemplateLoader.getGTTemplateInstance((GTTemplateLocation)((GTTemplateLocationReal)this.templateLocation));
        }
        return this.gtJavaBase;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected GTRenderingResult renderGTTemplate(Map<String, Object> args) {
        try {
            GTJavaBase gtTemplate = this.getGTTemplateInstance();
            Monitor monitor = MonitorFactory.start((String)this.name);
            try {
                gtTemplate.renderTemplate(args);
            }
            finally {
                monitor.stop();
            }
            return gtTemplate;
        }
        catch (GTTemplateNotFoundWithSourceInfo e) {
            GTTemplate t = new GTTemplate(e.templateLocation);
            t.loadSource();
            throw new TemplateNotFoundException(e.queryPath, (Template)t, Integer.valueOf(e.lineNo));
        }
        catch (GTCompilationExceptionWithSourceInfo e) {
            GTTemplate t = new GTTemplate(e.templateLocation);
            t.loadSource();
            throw new TemplateCompilationException((Template)t, Integer.valueOf(e.oneBasedLineNo), e.specialMessage);
        }
        catch (GTRuntimeExceptionWithSourceInfo e) {
            GTTemplate t = new GTTemplate(e.templateLocation);
            t.loadSource();
            Throwable cause = e.getCause();
            throw new TemplateExecutionException((Template)t, Integer.valueOf(e.lineNo), cause.getMessage(), cause);
        }
        catch (GTRuntimeException e) {
            Throwable cause = e.getCause();
            this.loadSource();
            if (cause != null) {
                throw new TemplateExecutionException((Template)this, Integer.valueOf(0), cause.getMessage(), cause);
            }
            throw new TemplateExecutionException((Template)this, Integer.valueOf(0), e.getMessage(), (Throwable)e);
        }
        catch (GTAppClassException e) {
            throw new JavaExecutionException(Play.classes.getApplicationClass(e.className), Integer.valueOf(e.lineNo), e.getCause());
        }
    }

    public String render(Map<String, Object> args) {
        return this.internalRender(args);
    }

    public void loadSource() {
        if (this.source == null) {
            this.source = this.templateLocation.readSource();
        }
    }
}

