/*
 * Decompiled with CFR 0.152.
 */
package play.template2.compile;

import groovy.lang.GroovyClassLoader;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.LinkedList;
import org.codehaus.groovy.control.CompilationUnit;
import org.codehaus.groovy.control.CompilerConfiguration;
import org.codehaus.groovy.control.MultipleCompilationErrorsException;
import org.codehaus.groovy.control.SourceUnit;
import org.codehaus.groovy.control.messages.Message;
import org.codehaus.groovy.control.messages.SyntaxErrorMessage;
import org.codehaus.groovy.syntax.SyntaxException;
import org.codehaus.groovy.tools.GroovyClass;
import play.template2.GTLineMapper;
import play.template2.GTTemplateLocation;
import play.template2.compile.GTJavaCompileToClass;
import play.template2.exceptions.GTCompilationException;
import play.template2.exceptions.GTCompilationExceptionWithSourceInfo;

public class GTGroovyCompileToClass {
    private final ClassLoader parentClassLoader;

    public GTGroovyCompileToClass(ClassLoader parentClassLoader) {
        this.parentClassLoader = parentClassLoader;
    }

    public GTJavaCompileToClass.CompiledClass[] compileGroovySource(GTTemplateLocation templateLocation, GTLineMapper lineMapper, String groovySource) {
        LinkedList<1> output;
        final ArrayList groovyClassesForThisTemplate = new ArrayList();
        GroovyClassLoader classLoader = new GroovyClassLoader(this.parentClassLoader);
        CompilerConfiguration compilerConfiguration = new CompilerConfiguration();
        compilerConfiguration.setSourceEncoding("utf-8");
        GTCompilationUnit compilationUnit = new GTCompilationUnit(compilerConfiguration);
        compilationUnit.addSource(new SourceUnit("", groovySource, compilerConfiguration, classLoader, compilationUnit.getErrorCollector()));
        LinkedList[] phases = compilationUnit.getPhases();
        phases[8] = output = new LinkedList<1>();
        output.add(new CompilationUnit.GroovyClassOperation(){

            public void call(GroovyClass gclass) {
                groovyClassesForThisTemplate.add(gclass);
            }
        });
        try {
            compilationUnit.compile();
        }
        catch (MultipleCompilationErrorsException e) {
            if (e.getErrorCollector().getErrorCount() == 0) {
                throw new GTCompilationException("Error compiling groovy", e);
            }
            Message errorMessage = e.getErrorCollector().getError(0);
            if (errorMessage instanceof SyntaxErrorMessage) {
                SyntaxException se = ((SyntaxErrorMessage)errorMessage).getCause();
                throw new GTCompilationExceptionWithSourceInfo(se.getOriginalMessage(), templateLocation, lineMapper.translateLineNo(se.getLine()));
            }
            throw new GTCompilationException("Error compiling groovy", e);
        }
        GTJavaCompileToClass.CompiledClass[] result = new GTJavaCompileToClass.CompiledClass[groovyClassesForThisTemplate.size()];
        for (int i = 0; i < result.length; ++i) {
            GroovyClass groovyClass = (GroovyClass)groovyClassesForThisTemplate.get(i);
            result[i] = new GTJavaCompileToClass.CompiledClass(groovyClass.getName(), groovyClass.getBytes());
        }
        return result;
    }

    static class GTCompilationUnit
    extends CompilationUnit {
        GTCompilationUnit(CompilerConfiguration configuration) {
            super(configuration, null, null, new GroovyClassLoader(GTCompilationUnit.class.getClassLoader()));
        }

        public LinkedList[] getPhases() {
            try {
                Field phasesF = CompilationUnit.class.getDeclaredField("phaseOperations");
                phasesF.setAccessible(true);
                LinkedList[] phases = (LinkedList[])phasesF.get((Object)this);
                return phases;
            }
            catch (Exception e) {
                throw new RuntimeException("Not supposed to happen", e);
            }
        }
    }
}

