/*
 * Decompiled with CFR 0.152.
 */
package play.modules.fbconnect;

import play.Play;
import play.exceptions.UnexpectedException;
import play.libs.WS;
import play.mvc.Router;

public class FBConnectSession {
    private String id;
    private String apiKey;
    private String secret;
    private String model;
    private String landUrl;

    public String getAppId() {
        return this.id;
    }

    public String getApiKey() {
        return this.apiKey;
    }

    public String getSecret() {
        return this.secret;
    }

    public String getModel() {
        return this.model;
    }

    public String getLandUrl() {
        return this.landUrl;
    }

    public String getLoginUrl() {
        return this.getLoginUrl("email");
    }

    public String getLoginUrl(String scope) {
        String url = String.format("https://www.facebook.com/dialog/oauth?client_id=%s&display=%s&redirect_uri=%s", WS.encode((String)this.id), WS.encode((String)"page"), WS.encode((String)Router.getFullUrl((String)"FBConnect.callback")));
        if (scope != null) {
            url = url + "&scope=" + WS.encode((String)scope);
        }
        return url;
    }

    public String getAuthUrl(String authCode) {
        return String.format("https://graph.facebook.com/oauth/access_token?client_id=%s&redirect_uri=%s&client_secret=%s&code=%s", WS.encode((String)this.id), WS.encode((String)Router.getFullUrl((String)"FBConnect.callback")), WS.encode((String)this.secret), WS.encode((String)authCode));
    }

    public void init() {
        if (!Play.configuration.containsKey("fbconnect.id")) {
            throw new UnexpectedException("Module fbconnect requires that you specify fbconnect.id in your application.conf");
        }
        if (!Play.configuration.containsKey("fbconnect.apiKey")) {
            throw new UnexpectedException("Module fbconnect requires that you specify fbconnect.apiKey in your application.conf");
        }
        if (!Play.configuration.containsKey("fbconnect.secret")) {
            throw new UnexpectedException("Module fbconnect requires that you specify fbconnect.secret in your application.conf");
        }
        if (!Play.configuration.containsKey("fbconnect.model")) {
            throw new UnexpectedException("Module fbconnect requires that you specify fbconnect.model in your application.conf");
        }
        if (!Play.configuration.containsKey("fbconnect.landUrl")) {
            Play.configuration.setProperty("fbconnect.landUrl", "/");
        }
        this.id = Play.configuration.getProperty("fbconnect.id");
        this.apiKey = Play.configuration.getProperty("fbconnect.apiKey");
        this.secret = Play.configuration.getProperty("fbconnect.secret");
        this.model = Play.configuration.getProperty("fbconnect.model");
        this.landUrl = Play.configuration.getProperty("fbconnect.landUrl");
    }
}

