/*
 * Decompiled with CFR 0.152.
 */
package play.modules.facebook;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.restfb.DefaultFacebookClient;
import com.restfb.FacebookClient;
import java.util.HashMap;
import java.util.Map;
import play.Play;
import play.exceptions.UnexpectedException;
import play.libs.WS;
import play.modules.facebook.FbGraphException;
import play.modules.facebook.Parameter;
import play.mvc.Http;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FbGraph {
    public static final String FB_GRAPH_URL = "https://graph.facebook.com/";
    private static String appId;
    private static String appSecret;

    public static void init() {
        if (!Play.configuration.containsKey("fbg.appId")) {
            throw new UnexpectedException("Module FbGraph requires that you specify fbg.appId in your application.conf");
        }
        if (!Play.configuration.containsKey("fbg.appSecret")) {
            throw new UnexpectedException("Module FbGraph requires that you specify fbg.appSecret in your application.conf");
        }
        appId = Play.configuration.getProperty("fbg.appId");
        appSecret = Play.configuration.getProperty("fbg.appSecret");
    }

    public static String getAppId() {
        return appId;
    }

    public static String getAppSecret() {
        return appSecret;
    }

    private static Map<String, String> parseStr(String str) {
        String[] pairs = str.split("&");
        HashMap<String, String> map = new HashMap<String, String>();
        for (String pair : pairs) {
            String[] kv = pair.split("=");
            map.put(kv[0], kv[1]);
        }
        return map;
    }

    public static Map getFacebookCookie() {
        Map<String, String> fbData = null;
        Http.Cookie cookie = (Http.Cookie)Http.Request.current().cookies.get("fbs_" + FbGraph.getAppId());
        if (cookie != null) {
            fbData = FbGraph.parseStr(cookie.value);
        }
        return fbData;
    }

    public static String getAccessToken() {
        String accessToken = null;
        if (FbGraph.getFacebookCookie() != null) {
            accessToken = (String)FbGraph.getFacebookCookie().get("access_token");
        }
        return accessToken;
    }

    private static WS.HttpResponse makeRequest(String path, String method, Map<String, String> params) {
        StringBuilder url = new StringBuilder();
        url.append(FB_GRAPH_URL);
        if (path.startsWith("/")) {
            path = path.substring(1);
        }
        url.append(path);
        if (method != null && method.toUpperCase().equals("POST")) {
            return WS.url((String)url.toString()).setParameters(params).post();
        }
        url.append("?");
        StringBuilder queryStr = new StringBuilder();
        for (Map.Entry<String, String> param : params.entrySet()) {
            if (queryStr.length() > 0) {
                queryStr.append("&");
            }
            queryStr.append(WS.encode((String)param.getKey()));
            queryStr.append("=");
            queryStr.append(WS.encode((String)param.getValue()));
        }
        url.append(queryStr.toString());
        return WS.url((String)url.toString()).get();
    }

    private static WS.HttpResponse oauthRequest(String path, String method, Map<String, String> params) {
        if (params == null) {
            params = new HashMap<String, String>();
        }
        if (!params.containsKey("access_token")) {
            params.put("access_token", FbGraph.getAccessToken());
        }
        return FbGraph.makeRequest(path, method, params);
    }

    public static JsonElement api(String path, String method, Map<String, String> params) throws FbGraphException {
        JsonElement json = null;
        if (FbGraph.getFacebookCookie() != null) {
            JsonObject jsonObject;
            WS.HttpResponse resp = FbGraph.oauthRequest(path, method, params);
            if (resp == null) {
                throw new UnexpectedException("Module FbGraph got an unexpected response from facebook");
            }
            if (resp.getStatus() != 200) {
                throw new FbGraphException("HttpResponse", Integer.toString(resp.getStatus()), resp.getString());
            }
            json = resp.getJson();
            if (json.isJsonObject() && (jsonObject = (JsonObject)json).get("error") != null) {
                throw new FbGraphException(jsonObject);
            }
        }
        return json;
    }

    public static JsonElement api(String path, String method) throws FbGraphException {
        return FbGraph.api(path, method, null);
    }

    public static JsonElement api(String path, Map<String, String> params) throws FbGraphException {
        return FbGraph.api(path, "GET", params);
    }

    public static JsonElement api(String path) throws FbGraphException {
        return FbGraph.api(path, "GET", null);
    }

    public static JsonObject getObject(String object, Map<String, String> params) throws FbGraphException {
        return FbGraph.api(object, params).getAsJsonObject();
    }

    public static JsonObject getObject(String object) throws FbGraphException {
        return FbGraph.api(object).getAsJsonObject();
    }

    public static JsonArray getConnection(String connection, Map<String, String> params) throws FbGraphException {
        return FbGraph.api(connection, params).getAsJsonObject().get("data").getAsJsonArray();
    }

    public static JsonArray getConnection(String connection) throws FbGraphException {
        return FbGraph.getConnection(connection, null);
    }

    public static String getPicture(String id) {
        return FB_GRAPH_URL + id + "/picture?access_token=" + WS.encode((String)FbGraph.getAccessToken());
    }

    public static String getPicture(String id, String type) {
        return FbGraph.getPicture(id) + "&type=" + type;
    }

    public static JsonObject publish(String path, Map<String, String> params) throws FbGraphException {
        return FbGraph.api(path, "POST", params).getAsJsonObject();
    }

    public static Boolean delete(String object) throws FbGraphException {
        return FbGraph.api(object, "POST", Parameter.with("method", "delete").parameters()).getAsBoolean();
    }

    public static FacebookClient getFacebookClient() {
        return new DefaultFacebookClient(FbGraph.getAccessToken());
    }
}

