/*
 * Decompiled with CFR 0.152.
 */
package play.modules.facebook;

import com.google.gson.JsonObject;

public class FbGraphException
extends Exception {
    private String type = null;
    private String code = null;

    public FbGraphException(String error) {
        super(error);
    }

    public FbGraphException(JsonObject json) {
        super(FbGraphException.createMessage(FbGraphException.extractType(json), null, FbGraphException.extractMessage(json)));
        this.type = FbGraphException.extractType(json);
    }

    public FbGraphException(String type, String code, String message) {
        super(FbGraphException.createMessage(type, code, message));
        this.type = type;
        this.code = code;
    }

    public String getType() {
        return this.type;
    }

    public String getCode() {
        return this.code;
    }

    private static String extractType(JsonObject json) {
        return json.get("error").getAsJsonObject().get("type").getAsString();
    }

    private static String extractMessage(JsonObject json) {
        return json.get("error").getAsJsonObject().get("message").getAsString();
    }

    private static String createMessage(String type, String code, String message) {
        return type + ": " + (code != null ? code + ": " : "") + message;
    }
}

