/*
 * Decompiled with CFR 0.152.
 */
package play.modules.facebook;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.restfb.DefaultFacebookClient;
import com.restfb.FacebookClient;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import play.Play;
import play.exceptions.UnexpectedException;
import play.libs.WS;
import play.modules.facebook.FbGraphException;
import play.modules.facebook.JsonUtil;
import play.modules.facebook.Parameter;
import play.mvc.Http;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FbGraph {
    public static final String FB_GRAPH_URL = "https://graph.facebook.com/";
    private static String appId;
    private static String appSecret;

    public static void init() {
        if (!Play.configuration.containsKey("fbg.appId")) {
            throw new UnexpectedException("Module FbGraph requires that you specify fbg.appId in your application.conf");
        }
        if (!Play.configuration.containsKey("fbg.appSecret")) {
            throw new UnexpectedException("Module FbGraph requires that you specify fbg.appSecret in your application.conf");
        }
        appId = Play.configuration.getProperty("fbg.appId");
        appSecret = Play.configuration.getProperty("fbg.appSecret");
    }

    public static String getAppId() {
        return appId;
    }

    public static String getAppSecret() {
        return appSecret;
    }

    private static Map<String, String> parseStr(String str) {
        String[] pairs = str.split("&");
        HashMap<String, String> map = new HashMap<String, String>();
        for (String pair : pairs) {
            String[] kv = pair.split("=");
            map.put(kv[0], kv[1]);
        }
        return map;
    }

    public static Map getFacebookCookie() {
        Map<String, String> fbData = null;
        Http.Cookie cookie = (Http.Cookie)Http.Request.current().cookies.get("fbs_" + FbGraph.getAppId());
        if (cookie != null) {
            fbData = FbGraph.parseStr(cookie.value);
        }
        return fbData;
    }

    public static String getAccessToken() {
        String accessToken = null;
        if (FbGraph.getFacebookCookie() != null) {
            accessToken = (String)FbGraph.getFacebookCookie().get("access_token");
        }
        return accessToken;
    }

    private static WS.HttpResponse makeRequest(String path, String method, Map<String, String> params) {
        StringBuilder url = new StringBuilder();
        url.append(FB_GRAPH_URL);
        if (path.startsWith("/")) {
            path = path.substring(1);
        }
        url.append(path);
        StringBuilder queryStr = new StringBuilder();
        for (Map.Entry<String, String> param : params.entrySet()) {
            if (queryStr.length() > 0) {
                queryStr.append("&");
            }
            queryStr.append(WS.encode((String)param.getKey()));
            queryStr.append("=");
            queryStr.append(WS.encode((String)param.getValue()));
        }
        if (method != null && method.toUpperCase().equals("POST")) {
            return WS.url((String)url.toString()).body((Object)queryStr.toString()).mimeType("multipart/form-data").post();
        }
        url.append("?");
        url.append(queryStr.toString());
        return WS.url((String)url.toString()).get();
    }

    private static WS.HttpResponse oauthRequest(String path, String method, Map<String, String> params) {
        if (params == null) {
            params = new HashMap<String, String>();
        }
        if (!params.containsKey("access_token")) {
            params.put("access_token", FbGraph.getAccessToken());
        }
        return FbGraph.makeRequest(path, method, params);
    }

    public static JsonElement api(String path, String method, Map<String, String> params) throws FbGraphException {
        JsonObject jsonObject;
        if (FbGraph.getFacebookCookie() == null) {
            throw new FbGraphException("No Facebook session associated with the user");
        }
        WS.HttpResponse resp = FbGraph.oauthRequest(path, method, params);
        if (resp == null) {
            throw new UnexpectedException("Module FbGraph got an unexpected response from facebook");
        }
        if (resp.getStatus() != 200) {
            throw new FbGraphException("HttpResponse", Integer.toString(resp.getStatus()), resp.getString());
        }
        JsonElement json = resp.getJson();
        if (json.isJsonObject() && (jsonObject = (JsonObject)json).get("error") != null) {
            throw new FbGraphException(jsonObject);
        }
        return json;
    }

    public static JsonElement api(String path, String method) throws FbGraphException {
        return FbGraph.api(path, method, new HashMap<String, String>());
    }

    public static JsonElement api(String path, Map<String, String> params) throws FbGraphException {
        return FbGraph.api(path, "GET", params);
    }

    public static JsonElement api(String path) throws FbGraphException {
        return FbGraph.api(path, "GET", new HashMap<String, String>());
    }

    public static JsonObject getObject(String objId, Map<String, String> params) throws FbGraphException {
        return FbGraph.api(objId, params).getAsJsonObject();
    }

    public static JsonObject getObject(String objId) throws FbGraphException {
        return FbGraph.getObject(objId, new HashMap<String, String>());
    }

    public static <T> T getObject(String objId, Class<T> clazz, Map<String, String> params) throws FbGraphException {
        return JsonUtil.toJavaObject(FbGraph.getObject(objId, params), clazz);
    }

    public static <T> T getObject(String objId, Class<T> clazz) throws FbGraphException {
        return FbGraph.getObject(objId, clazz, new HashMap<String, String>());
    }

    public static JsonObject getObjects(Map<String, String> ids) throws FbGraphException {
        return FbGraph.getObject("", ids);
    }

    public static JsonArray getConnection(String conId, Map<String, String> params) throws FbGraphException {
        return FbGraph.api(conId, params).getAsJsonObject().get("data").getAsJsonArray();
    }

    public static JsonArray getConnection(String conId) throws FbGraphException {
        return FbGraph.getConnection(conId, new HashMap<String, String>());
    }

    public static <T> List<T> getConnection(String conId, Class<T> clazz, Map<String, String> params) throws FbGraphException {
        return JsonUtil.toJavaObject(FbGraph.getConnection(conId, params), clazz);
    }

    public static <T> List<T> getConnection(String conId, Class<T> clazz) throws FbGraphException {
        return FbGraph.getConnection(conId, clazz, new HashMap<String, String>());
    }

    public static String getPicture(String picId) throws FbGraphException {
        if (FbGraph.getFacebookCookie() == null) {
            throw new FbGraphException("No Facebook session associated with the user");
        }
        return FB_GRAPH_URL + picId + "/picture?access_token=" + WS.encode((String)FbGraph.getAccessToken());
    }

    public static String getPicture(String picId, String picType) throws FbGraphException {
        return FbGraph.getPicture(picId) + "&type=" + picType;
    }

    public static JsonElement publish(String path, Map<String, String> params) throws FbGraphException {
        return FbGraph.api(path, "POST", params);
    }

    public static <T> T publish(String path, Class<T> clazz, Map<String, String> params) throws FbGraphException {
        return JsonUtil.toJavaObject(FbGraph.publish(path, params).toString(), clazz);
    }

    public static Boolean delete(String objId) throws FbGraphException {
        return FbGraph.api(objId, "POST", Parameter.with("method", "delete").parameters()).getAsBoolean();
    }

    public static FacebookClient getFacebookClient() {
        return FbGraph.getFacebookClient(FbGraph.getAccessToken());
    }

    public static FacebookClient getFacebookClient(String accessToken) {
        return new DefaultFacebookClient(accessToken);
    }
}

