/*
 * Decompiled with CFR 0.152.
 */
package com.restfb;

import com.restfb.JsonMapper;
import com.restfb.Parameter;
import com.restfb.WebRequestor;
import com.restfb.exception.FacebookException;
import com.restfb.exception.FacebookExceptionMapper;
import com.restfb.exception.FacebookJsonMappingException;
import com.restfb.exception.FacebookOAuthException;
import com.restfb.exception.FacebookResponseStatusException;
import com.restfb.json.JsonException;
import com.restfb.json.JsonObject;
import com.restfb.util.StringUtils;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.logging.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
abstract class BaseFacebookClient {
    protected WebRequestor webRequestor;
    protected JsonMapper jsonMapper;
    protected FacebookExceptionMapper legacyFacebookExceptionMapper;
    protected final Set<String> illegalParamNames = new HashSet<String>();
    protected final Set<String> readOnlyApiCalls = new HashSet<String>();
    protected static final String LEGACY_ERROR_CODE_ATTRIBUTE_NAME = "error_code";
    protected static final String LEGACY_ERROR_MSG_ATTRIBUTE_NAME = "error_msg";
    protected static final String ACCESS_TOKEN_PARAM_NAME = "access_token";
    protected final Logger logger = Logger.getLogger(this.getClass().getName());

    public BaseFacebookClient() {
        this.initializeReadOnlyApiCalls();
        this.legacyFacebookExceptionMapper = this.createLegacyFacebookExceptionMapper();
    }

    protected FacebookExceptionMapper createLegacyFacebookExceptionMapper() {
        return new DefaultLegacyFacebookExceptionMapper();
    }

    protected void initializeReadOnlyApiCalls() {
        this.readOnlyApiCalls.addAll(Arrays.asList("admin.getallocation", "admin.getappproperties", "admin.getbannedusers", "admin.getlivestreamvialink", "admin.getmetrics", "admin.getrestrictioninfo", "application.getpublicinfo", "auth.getapppublickey", "auth.getsession", "auth.getsignedpublicsessiondata", "comments.get", "connect.getunconnectedfriendscount", "dashboard.getactivity", "dashboard.getcount", "dashboard.getglobalnews", "dashboard.getnews", "dashboard.multigetcount", "dashboard.multigetnews", "data.getcookies", "events.get", "events.getmembers", "fbml.getcustomtags", "feed.getappfriendstories", "feed.getregisteredtemplatebundlebyid", "feed.getregisteredtemplatebundles", "fql.multiquery", "fql.query", "friends.arefriends", "friends.get", "friends.getappusers", "friends.getlists", "friends.getmutualfriends", "gifts.get", "groups.get", "groups.getmembers", "intl.gettranslations", "links.get", "notes.get", "notifications.get", "pages.getinfo", "pages.isadmin", "pages.isappadded", "pages.isfan", "permissions.checkavailableapiaccess", "permissions.checkgrantedapiaccess", "photos.get", "photos.getalbums", "photos.gettags", "profile.getinfo", "profile.getinfooptions", "stream.get", "stream.getcomments", "stream.getfilters", "users.getinfo", "users.getloggedinuser", "users.getstandardinfo", "users.hasapppermission", "users.isappuser", "users.isverified", "video.getuploadlimits"));
    }

    protected void throwLegacyFacebookResponseStatusExceptionIfNecessary(String json) {
        try {
            if (!json.startsWith("{")) {
                return;
            }
            JsonObject errorObject = null;
            try {
                errorObject = new JsonObject(json);
            }
            catch (JsonException jsonException) {
                // empty catch block
            }
            if (errorObject == null || !errorObject.has(LEGACY_ERROR_CODE_ATTRIBUTE_NAME)) {
                return;
            }
            throw this.legacyFacebookExceptionMapper.exceptionForTypeAndMessage(errorObject.getInt(LEGACY_ERROR_CODE_ATTRIBUTE_NAME), null, errorObject.getString(LEGACY_ERROR_MSG_ATTRIBUTE_NAME));
        }
        catch (JsonException e) {
            throw new FacebookJsonMappingException("Unable to process the Facebook API response", e);
        }
    }

    protected Parameter[] parametersWithAdditionalParameter(Parameter parameter, Parameter ... parameters) {
        Parameter[] updatedParameters = new Parameter[parameters.length + 1];
        System.arraycopy(parameters, 0, updatedParameters, 0, parameters.length);
        updatedParameters[parameters.length] = parameter;
        return updatedParameters;
    }

    protected String queriesToJson(Map<String, String> queries) {
        this.verifyParameterPresence("queries", queries);
        if (queries.keySet().size() == 0) {
            throw new IllegalArgumentException("You must specify at least one query.");
        }
        JsonObject jsonObject = new JsonObject();
        for (Map.Entry<String, String> entry : queries.entrySet()) {
            if (StringUtils.isBlank(entry.getKey()) || StringUtils.isBlank(entry.getValue())) {
                throw new IllegalArgumentException("Provided queries must have non-blank keys and values. You provided: " + queries);
            }
            try {
                jsonObject.put(StringUtils.trimToEmpty(entry.getKey()), StringUtils.trimToEmpty(entry.getValue()));
            }
            catch (JsonException e) {
                throw new IllegalArgumentException("Unable to convert " + queries + " to JSON.", e);
            }
        }
        return jsonObject.toString();
    }

    protected String urlEncodedValueForParameterName(String name, String value) {
        return ACCESS_TOKEN_PARAM_NAME.equals(name) && value.contains("%7C") ? value : StringUtils.urlEncode(value);
    }

    protected abstract String createEndpointForApiCall(String var1);

    protected abstract String getFacebookReadOnlyEndpointUrl();

    protected void verifyParameterLegality(Parameter ... parameters) {
        for (Parameter parameter : parameters) {
            if (!this.illegalParamNames.contains(parameter.name)) continue;
            throw new IllegalArgumentException("Parameter '" + parameter.name + "' is reserved for RestFB use - " + "you cannot specify it yourself.");
        }
    }

    protected void verifyParameterPresence(String parameterName, String parameter) {
        this.verifyParameterPresence(parameterName, (Object)parameter);
        if (parameter.trim().length() == 0) {
            throw new IllegalArgumentException("The '" + parameterName + "' parameter cannot be an empty string.");
        }
    }

    protected void verifyParameterPresence(String parameterName, Object parameter) {
        if (parameter == null) {
            throw new NullPointerException("The '" + parameterName + "' parameter cannot be null.");
        }
    }

    protected static class DefaultLegacyFacebookExceptionMapper
    implements FacebookExceptionMapper {
        protected static final int API_EC_PARAM_ACCESS_TOKEN = 190;

        protected DefaultLegacyFacebookExceptionMapper() {
        }

        public FacebookException exceptionForTypeAndMessage(Integer errorCode, String type, String message) {
            if (errorCode == 190) {
                return new FacebookOAuthException(String.valueOf(errorCode), message);
            }
            return new FacebookResponseStatusException(errorCode, message);
        }
    }
}

