/*
 * Decompiled with CFR 0.152.
 */
package com.restfb;

import com.restfb.BaseFacebookClient;
import com.restfb.Connection;
import com.restfb.DefaultJsonMapper;
import com.restfb.DefaultWebRequestor;
import com.restfb.FacebookClient;
import com.restfb.JsonMapper;
import com.restfb.Parameter;
import com.restfb.WebRequestor;
import com.restfb.exception.FacebookException;
import com.restfb.exception.FacebookExceptionMapper;
import com.restfb.exception.FacebookGraphException;
import com.restfb.exception.FacebookJsonMappingException;
import com.restfb.exception.FacebookNetworkException;
import com.restfb.exception.FacebookOAuthException;
import com.restfb.exception.FacebookQueryParseException;
import com.restfb.json.JsonArray;
import com.restfb.json.JsonException;
import com.restfb.json.JsonObject;
import com.restfb.util.StringUtils;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DefaultFacebookClient
extends BaseFacebookClient
implements FacebookClient {
    protected String accessToken;
    protected FacebookExceptionMapper graphFacebookExceptionMapper;
    protected static final String FACEBOOK_GRAPH_ENDPOINT_URL = "https://graph.facebook.com";
    protected static final String FACEBOOK_READ_ONLY_ENDPOINT_URL = "https://api-read.facebook.com/method";
    protected static final String METHOD_PARAM_NAME = "method";
    protected static final String IDS_PARAM_NAME = "ids";
    protected static final String QUERY_PARAM_NAME = "query";
    protected static final String QUERIES_PARAM_NAME = "queries";
    protected static final String FORMAT_PARAM_NAME = "format";
    protected static final String ERROR_ATTRIBUTE_NAME = "error";
    protected static final String ERROR_TYPE_ATTRIBUTE_NAME = "type";
    protected static final String ERROR_MESSAGE_ATTRIBUTE_NAME = "message";

    public DefaultFacebookClient() {
        this(null);
    }

    public DefaultFacebookClient(String accessToken) {
        this(accessToken, new DefaultWebRequestor(), new DefaultJsonMapper());
    }

    public DefaultFacebookClient(String accessToken, WebRequestor webRequestor, JsonMapper jsonMapper) {
        this.verifyParameterPresence("jsonMapper", jsonMapper);
        this.verifyParameterPresence("webRequestor", webRequestor);
        this.accessToken = StringUtils.trimToNull(accessToken);
        this.webRequestor = webRequestor;
        this.jsonMapper = jsonMapper;
        this.graphFacebookExceptionMapper = this.createGraphFacebookExceptionMapper();
        this.illegalParamNames.addAll(Arrays.asList("access_token", METHOD_PARAM_NAME, FORMAT_PARAM_NAME));
    }

    @Override
    public boolean deleteObject(String object) {
        this.verifyParameterPresence("object", object);
        return "true".equals(this.makeRequest(object, true, true, null, new Parameter[0]));
    }

    @Override
    public <T> Connection<T> fetchConnection(String connection, Class<T> connectionType, Parameter ... parameters) {
        this.verifyParameterPresence("connection", connection);
        this.verifyParameterPresence("connectionType", connectionType);
        return this.mapToConnection(this.makeRequest(connection, parameters), connectionType);
    }

    @Override
    public <T> Connection<T> fetchConnectionPage(final String connectionPageUrl, Class<T> connectionType) {
        String connectionJson = this.makeRequestAndProcessResponse(new Requestor(){

            public WebRequestor.Response makeRequest() throws IOException {
                return DefaultFacebookClient.this.webRequestor.executeGet(connectionPageUrl);
            }
        });
        return this.mapToConnection(connectionJson, connectionType);
    }

    protected <T> Connection<T> mapToConnection(String connectionJson, Class<T> connectionType) {
        ArrayList<Object> data = new ArrayList<Object>();
        String previous = null;
        String next = null;
        try {
            JsonObject jsonObject = new JsonObject(connectionJson);
            JsonArray jsonData = jsonObject.getJsonArray("data");
            for (int i = 0; i < jsonData.length(); ++i) {
                data.add(connectionType.equals(JsonObject.class) ? jsonData.get(i) : this.jsonMapper.toJavaObject(jsonData.get(i).toString(), connectionType));
            }
            if (jsonObject.has("paging")) {
                JsonObject jsonPaging = jsonObject.getJsonObject("paging");
                previous = jsonPaging.has("previous") ? jsonPaging.getString("previous") : null;
                next = jsonPaging.has("next") ? jsonPaging.getString("next") : null;
            }
        }
        catch (JsonException e) {
            throw new FacebookJsonMappingException("Unable to map connection JSON to Java objects", e);
        }
        return new Connection(data, previous, next);
    }

    @Override
    public <T> T fetchObject(String object, Class<T> objectType, Parameter ... parameters) {
        this.verifyParameterPresence("object", object);
        this.verifyParameterPresence("objectType", objectType);
        return this.jsonMapper.toJavaObject(this.makeRequest(object, parameters), objectType);
    }

    @Override
    public <T> T fetchObjects(List<String> ids, Class<T> objectType, Parameter ... parameters) {
        this.verifyParameterPresence(IDS_PARAM_NAME, ids);
        this.verifyParameterPresence("connectionType", objectType);
        if (ids.size() == 0) {
            throw new IllegalArgumentException("The list of IDs cannot be empty.");
        }
        for (Parameter parameter : parameters) {
            if (!IDS_PARAM_NAME.equals(parameter.name)) continue;
            throw new IllegalArgumentException("You cannot specify the 'ids' URL parameter yourself - RestFB will populate this for you with the list of IDs you passed to this method.");
        }
        for (int i = 0; i < ids.size(); ++i) {
            String id = ids.get(i).trim().toLowerCase();
            if ("".equals(id)) {
                throw new IllegalArgumentException("The list of IDs cannot contain blank strings.");
            }
            ids.set(i, id);
        }
        try {
            JsonObject jsonObject = new JsonObject(this.makeRequest("", this.parametersWithAdditionalParameter(Parameter.with(IDS_PARAM_NAME, StringUtils.join(ids)), parameters)));
            return (T)(objectType.equals(JsonObject.class) ? jsonObject : this.jsonMapper.toJavaObject(jsonObject.toString(), objectType));
        }
        catch (JsonException e) {
            throw new FacebookJsonMappingException("Unable to map connection JSON to Java objects", e);
        }
    }

    @Override
    public <T> T publish(String connection, Class<T> objectType, InputStream binaryAttachment, Parameter ... parameters) {
        this.verifyParameterPresence("connection", connection);
        return this.jsonMapper.toJavaObject(this.makeRequest(connection, true, false, binaryAttachment, parameters), objectType);
    }

    @Override
    public <T> T publish(String connection, Class<T> objectType, Parameter ... parameters) {
        return this.publish(connection, objectType, (InputStream)null, parameters);
    }

    @Override
    public <T> T executeMultiquery(Map<String, String> queries, Class<T> objectType, Parameter ... parameters) {
        this.verifyParameterPresence("objectType", objectType);
        for (Parameter parameter : parameters) {
            if (!QUERIES_PARAM_NAME.equals(parameter.name)) continue;
            throw new IllegalArgumentException("You cannot specify the 'queries' URL parameter yourself - RestFB will populate this for you with the queries you passed to this method.");
        }
        try {
            JsonArray jsonArray = new JsonArray(this.makeRequest("fql.multiquery", false, false, null, this.parametersWithAdditionalParameter(Parameter.with(QUERIES_PARAM_NAME, this.queriesToJson(queries)), parameters)));
            JsonObject normalizedJson = new JsonObject();
            for (int i = 0; i < jsonArray.length(); ++i) {
                JsonObject jsonObject = jsonArray.getJsonObject(i);
                JsonArray resultsArray = jsonObject.get("fql_result_set") instanceof JsonArray ? jsonObject.getJsonArray("fql_result_set") : new JsonArray();
                normalizedJson.put(jsonObject.getString("name"), resultsArray);
            }
            return (T)(objectType.equals(JsonObject.class) ? normalizedJson : this.jsonMapper.toJavaObject(normalizedJson.toString(), objectType));
        }
        catch (JsonException e) {
            throw new FacebookJsonMappingException("Unable to process fql.multiquery JSON response", e);
        }
    }

    @Override
    public <T> List<T> executeQuery(String query, Class<T> objectType, Parameter ... parameters) {
        this.verifyParameterPresence(QUERY_PARAM_NAME, query);
        this.verifyParameterPresence("objectType", objectType);
        for (Parameter parameter : parameters) {
            if (!QUERY_PARAM_NAME.equals(parameter.name)) continue;
            throw new IllegalArgumentException("You cannot specify the 'query' URL parameter yourself - RestFB will populate this for you with the query you passed to this method.");
        }
        return this.jsonMapper.toJavaList(this.makeRequest("fql.query", false, false, null, this.parametersWithAdditionalParameter(Parameter.with(QUERY_PARAM_NAME, query), parameters)), objectType);
    }

    @Override
    public List<FacebookClient.AccessToken> convertSessionKeysToAccessTokens(String appId, String secretKey, String ... sessionKeys) {
        this.verifyParameterPresence("appId", appId);
        this.verifyParameterPresence("secretKey", secretKey);
        if (sessionKeys == null || sessionKeys.length == 0) {
            return Collections.emptyList();
        }
        String json = this.makeRequest("/oauth/exchange_sessions", true, false, null, Parameter.with("client_id", appId), Parameter.with("client_secret", secretKey), Parameter.with("sessions", StringUtils.join(sessionKeys)));
        return this.jsonMapper.toJavaList(json, FacebookClient.AccessToken.class);
    }

    protected String makeRequest(String endpoint, Parameter ... parameters) {
        return this.makeRequest(endpoint, false, false, null, parameters);
    }

    protected String makeRequest(String endpoint, final boolean executeAsPost, boolean executeAsDelete, final InputStream binaryAttachment, Parameter ... parameters) {
        this.verifyParameterLegality(parameters);
        if (executeAsDelete) {
            parameters = this.parametersWithAdditionalParameter(Parameter.with(METHOD_PARAM_NAME, "delete"), parameters);
        }
        StringUtils.trimToEmpty(endpoint).toLowerCase();
        if (!endpoint.startsWith("/")) {
            endpoint = "/" + endpoint;
        }
        final String fullEndpoint = this.createEndpointForApiCall(endpoint);
        final String parameterString = this.toParameterString(parameters);
        return this.makeRequestAndProcessResponse(new Requestor(){

            public WebRequestor.Response makeRequest() throws IOException {
                return executeAsPost ? DefaultFacebookClient.this.webRequestor.executePost(fullEndpoint, parameterString, binaryAttachment) : DefaultFacebookClient.this.webRequestor.executeGet(fullEndpoint + "?" + parameterString);
            }
        });
    }

    protected String makeRequestAndProcessResponse(Requestor requestor) {
        WebRequestor.Response response = null;
        try {
            response = requestor.makeRequest();
        }
        catch (Throwable t) {
            throw new FacebookNetworkException("Facebook request failed", t);
        }
        if (this.logger.isLoggable(Level.INFO)) {
            this.logger.info("Facebook responded with " + response);
        }
        if (200 != response.getStatusCode() && 400 != response.getStatusCode() && 401 != response.getStatusCode() && 500 != response.getStatusCode() && 403 != response.getStatusCode()) {
            throw new FacebookNetworkException("Facebook request failed", response.getStatusCode());
        }
        String json = response.getBody();
        this.throwFacebookResponseStatusExceptionIfNecessary(json);
        if (500 == response.getStatusCode() || 401 == response.getStatusCode()) {
            throw new FacebookNetworkException("Facebook request failed", response.getStatusCode());
        }
        return json;
    }

    protected void throwFacebookResponseStatusExceptionIfNecessary(String json) {
        this.throwLegacyFacebookResponseStatusExceptionIfNecessary(json);
        try {
            if (!json.startsWith("{")) {
                return;
            }
            JsonObject errorObject = new JsonObject(json);
            if (errorObject == null || !errorObject.has(ERROR_ATTRIBUTE_NAME)) {
                return;
            }
            JsonObject innerErrorObject = errorObject.getJsonObject(ERROR_ATTRIBUTE_NAME);
            throw this.graphFacebookExceptionMapper.exceptionForTypeAndMessage(null, innerErrorObject.getString(ERROR_TYPE_ATTRIBUTE_NAME), innerErrorObject.getString(ERROR_MESSAGE_ATTRIBUTE_NAME));
        }
        catch (JsonException e) {
            throw new FacebookJsonMappingException("Unable to process the Facebook API response", e);
        }
    }

    protected FacebookExceptionMapper createGraphFacebookExceptionMapper() {
        return new DefaultGraphFacebookExceptionMapper();
    }

    protected String toParameterString(Parameter ... parameters) {
        if (!StringUtils.isBlank(this.accessToken)) {
            parameters = this.parametersWithAdditionalParameter(Parameter.with("access_token", this.accessToken), parameters);
        }
        parameters = this.parametersWithAdditionalParameter(Parameter.with(FORMAT_PARAM_NAME, "json"), parameters);
        StringBuilder parameterStringBuilder = new StringBuilder();
        boolean first = true;
        for (Parameter parameter : parameters) {
            if (first) {
                first = false;
            } else {
                parameterStringBuilder.append("&");
            }
            parameterStringBuilder.append(StringUtils.urlEncode(parameter.name));
            parameterStringBuilder.append("=");
            parameterStringBuilder.append(this.urlEncodedValueForParameterName(parameter.name, parameter.value));
        }
        return parameterStringBuilder.toString();
    }

    @Override
    protected String createEndpointForApiCall(String apiCall) {
        StringUtils.trimToEmpty(apiCall).toLowerCase();
        while (apiCall.startsWith("/")) {
            apiCall = apiCall.substring(1);
        }
        return String.format("%s/%s", this.readOnlyApiCalls.contains(apiCall) ? this.getFacebookReadOnlyEndpointUrl() : this.getFacebookGraphEndpointUrl(), apiCall);
    }

    protected String getFacebookGraphEndpointUrl() {
        return FACEBOOK_GRAPH_ENDPOINT_URL;
    }

    @Override
    protected String getFacebookReadOnlyEndpointUrl() {
        return FACEBOOK_READ_ONLY_ENDPOINT_URL;
    }

    protected static class DefaultGraphFacebookExceptionMapper
    implements FacebookExceptionMapper {
        protected DefaultGraphFacebookExceptionMapper() {
        }

        public FacebookException exceptionForTypeAndMessage(Integer errorCode, String type, String message) {
            if ("OAuthException".equals(type) || "OAuthAccessTokenException".equals(type)) {
                return new FacebookOAuthException(type, message);
            }
            if ("QueryParseException".equals(type)) {
                return new FacebookQueryParseException(type, message);
            }
            return new FacebookGraphException(type, message);
        }
    }

    protected static interface Requestor {
        public WebRequestor.Response makeRequest() throws IOException;
    }
}

