/*
 * Decompiled with CFR 0.152.
 */
package com.restfb;

import com.restfb.Facebook;
import com.restfb.JsonMapper;
import com.restfb.exception.FacebookJsonMappingException;
import com.restfb.json.JsonArray;
import com.restfb.json.JsonException;
import com.restfb.json.JsonObject;
import com.restfb.types.Post;
import com.restfb.util.ReflectionUtils;
import com.restfb.util.StringUtils;
import java.lang.reflect.Field;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DefaultJsonMapper
implements JsonMapper {
    protected JsonMappingErrorHandler jsonMappingErrorHandler;
    private static final Logger logger = Logger.getLogger(DefaultJsonMapper.class.getName());

    public DefaultJsonMapper() {
        this(new JsonMappingErrorHandler(){

            @Override
            public boolean handleMappingError(String unmappableJson, Class<?> targetType, Exception e) {
                return false;
            }
        });
    }

    public DefaultJsonMapper(JsonMappingErrorHandler jsonMappingErrorHandler) {
        if (jsonMappingErrorHandler == null) {
            throw new IllegalArgumentException("The jsonMappingErrorHandler parameter cannot be null.");
        }
        this.jsonMappingErrorHandler = jsonMappingErrorHandler;
    }

    @Override
    public <T> List<T> toJavaList(String json, Class<T> type) {
        if (type == null) {
            throw new FacebookJsonMappingException("You must specify the Java type to map to.");
        }
        if (StringUtils.isBlank(json = StringUtils.trimToEmpty(json))) {
            if (this.jsonMappingErrorHandler.handleMappingError(json, type, null)) {
                return null;
            }
            throw new FacebookJsonMappingException("JSON is an empty string - can't map it.");
        }
        if (json.startsWith("{")) {
            if (this.isEmptyObject(json)) {
                if (logger.isLoggable(Level.FINER)) {
                    logger.finer("Encountered {} when we should've seen []. Mapping the {} as an empty list and moving on...");
                }
                return new ArrayList();
            }
            try {
                JsonObject jsonObject = new JsonObject(json);
                String[] fieldNames = JsonObject.getNames(jsonObject);
                if (fieldNames != null) {
                    boolean hasSingleDataProperty = fieldNames.length == 1 && "data".equals(fieldNames[0]);
                    Object jsonDataObject = jsonObject.get("data");
                    if (!hasSingleDataProperty && !(jsonDataObject instanceof JsonArray)) {
                        if (this.jsonMappingErrorHandler.handleMappingError(json, type, null)) {
                            return null;
                        }
                        throw new FacebookJsonMappingException("JSON is an object but is being mapped as a list instead. Offending JSON is '" + json + "'.");
                    }
                    json = jsonDataObject.toString();
                }
            }
            catch (JsonException e) {
                if (this.jsonMappingErrorHandler.handleMappingError(json, type, e)) {
                    return null;
                }
                throw new FacebookJsonMappingException("Unable to convert Facebook response JSON to a list of " + type.getName() + " instances.  Offending JSON is " + json, e);
            }
        }
        try {
            ArrayList<T> list = new ArrayList<T>();
            JsonArray jsonArray = new JsonArray(json);
            for (int i = 0; i < jsonArray.length(); ++i) {
                list.add(this.toJavaObject(jsonArray.get(i).toString(), type));
            }
            return Collections.unmodifiableList(list);
        }
        catch (FacebookJsonMappingException e) {
            throw e;
        }
        catch (Exception e) {
            if (this.jsonMappingErrorHandler.handleMappingError(json, type, e)) {
                return null;
            }
            throw new FacebookJsonMappingException("Unable to convert Facebook response JSON to a list of " + type.getName() + " instances", e);
        }
    }

    @Override
    public <T> T toJavaObject(String json, Class<T> type) {
        if (StringUtils.isBlank(json)) {
            if (this.jsonMappingErrorHandler.handleMappingError(json, type, null)) {
                return null;
            }
            throw new FacebookJsonMappingException("JSON is an empty string - can't map it.");
        }
        if (json.startsWith("[")) {
            if (this.jsonMappingErrorHandler.handleMappingError(json, type, null)) {
                return null;
            }
            throw new FacebookJsonMappingException("JSON is an array but is being mapped as an object - you should map it as a List instead. Offending JSON is '" + json + "'.");
        }
        try {
            if (type.equals(JsonObject.class)) {
                return (T)new JsonObject(json);
            }
            List<ReflectionUtils.FieldWithAnnotation<Facebook>> fieldsWithAnnotation = ReflectionUtils.findFieldsWithAnnotation(type, Facebook.class);
            Set<String> facebookFieldNamesWithMultipleMappings = this.facebookFieldNamesWithMultipleMappings(fieldsWithAnnotation);
            if (fieldsWithAnnotation.size() == 0) {
                if (this.isEmptyObject(json)) {
                    return this.createInstance(type);
                }
                return this.toPrimitiveJavaType(json, type);
            }
            if ("null".equals(json)) {
                return null;
            }
            if ("false".equals(json)) {
                if (logger.isLoggable(Level.FINE)) {
                    logger.fine("Encountered 'false' from Facebook when trying to map to " + type.getSimpleName() + " - mapping null instead.");
                }
                return null;
            }
            JsonObject jsonObject = new JsonObject(json);
            T instance = this.createInstance(type);
            if (instance instanceof JsonObject) {
                return (T)jsonObject;
            }
            for (ReflectionUtils.FieldWithAnnotation<Facebook> fieldWithAnnotation : fieldsWithAnnotation) {
                String facebookFieldName = this.getFacebookFieldName(fieldWithAnnotation);
                if (!jsonObject.has(facebookFieldName)) {
                    if (!logger.isLoggable(Level.FINER)) continue;
                    logger.finer("No JSON value present for '" + facebookFieldName + "', skipping. JSON is '" + json + "'.");
                    continue;
                }
                fieldWithAnnotation.getField().setAccessible(true);
                if (facebookFieldNamesWithMultipleMappings.contains(facebookFieldName)) {
                    try {
                        fieldWithAnnotation.getField().set(instance, this.toJavaType(fieldWithAnnotation, jsonObject, facebookFieldName));
                    }
                    catch (FacebookJsonMappingException e) {
                        this.logMultipleMappingFailedForField(facebookFieldName, fieldWithAnnotation, json);
                    }
                    catch (JsonException e) {
                        this.logMultipleMappingFailedForField(facebookFieldName, fieldWithAnnotation, json);
                    }
                    continue;
                }
                try {
                    fieldWithAnnotation.getField().set(instance, this.toJavaType(fieldWithAnnotation, jsonObject, facebookFieldName));
                }
                catch (Exception e) {
                    if (this.jsonMappingErrorHandler.handleMappingError(json, type, e)) continue;
                    throw e;
                }
            }
            return instance;
        }
        catch (FacebookJsonMappingException e) {
            throw e;
        }
        catch (Exception e) {
            if (this.jsonMappingErrorHandler.handleMappingError(json, type, e)) {
                return null;
            }
            throw new FacebookJsonMappingException("Unable to map JSON to Java. Offending JSON is '" + json + "'.", e);
        }
    }

    protected void logMultipleMappingFailedForField(String facebookFieldName, ReflectionUtils.FieldWithAnnotation<Facebook> fieldWithAnnotation, String json) {
        if (!logger.isLoggable(Level.FINER)) {
            return;
        }
        Field field = fieldWithAnnotation.getField();
        if (logger.isLoggable(Level.FINER)) {
            logger.finer("Could not map '" + facebookFieldName + "' to " + field.getDeclaringClass().getSimpleName() + "." + field.getName() + ", but continuing on because '" + facebookFieldName + "' is mapped to multiple fields in " + field.getDeclaringClass().getSimpleName() + ". JSON is " + json);
        }
    }

    protected String getFacebookFieldName(ReflectionUtils.FieldWithAnnotation<Facebook> fieldWithAnnotation) {
        String facebookFieldName = fieldWithAnnotation.getAnnotation().value();
        Field field = fieldWithAnnotation.getField();
        if (StringUtils.isBlank(facebookFieldName)) {
            if (logger.isLoggable(Level.FINEST)) {
                logger.finest("No explicit Facebook field name found for " + field + ", so defaulting to the field name itself (" + field.getName() + ")");
            }
            facebookFieldName = field.getName();
        }
        return facebookFieldName;
    }

    protected Set<String> facebookFieldNamesWithMultipleMappings(List<ReflectionUtils.FieldWithAnnotation<Facebook>> fieldsWithAnnotation) {
        HashMap<String, Integer> facebookFieldsNamesWithOccurrenceCount = new HashMap<String, Integer>();
        HashSet facebookFieldNamesWithMultipleMappings = new HashSet();
        for (ReflectionUtils.FieldWithAnnotation<Facebook> fieldWithAnnotation : fieldsWithAnnotation) {
            String fieldName = this.getFacebookFieldName(fieldWithAnnotation);
            int occurrenceCount = facebookFieldsNamesWithOccurrenceCount.containsKey(fieldName) ? (Integer)facebookFieldsNamesWithOccurrenceCount.get(fieldName) : 0;
            facebookFieldsNamesWithOccurrenceCount.put(fieldName, occurrenceCount + 1);
        }
        for (Map.Entry entry : facebookFieldsNamesWithOccurrenceCount.entrySet()) {
            if ((Integer)entry.getValue() <= 1) continue;
            facebookFieldNamesWithMultipleMappings.add(entry.getKey());
        }
        return Collections.unmodifiableSet(facebookFieldNamesWithMultipleMappings);
    }

    @Override
    public String toJson(Object object) {
        return this.toJsonInternal(object).toString();
    }

    protected Object toJsonInternal(Object object) {
        if (object == null) {
            return JsonObject.NULL;
        }
        if (object instanceof List) {
            JsonArray jsonArray = new JsonArray();
            for (Object o : (List)object) {
                jsonArray.put(this.toJsonInternal(o));
            }
            return jsonArray;
        }
        if (object instanceof Map) {
            JsonObject jsonObject = new JsonObject();
            for (Map.Entry entry : ((Map)object).entrySet()) {
                if (!(entry.getKey() instanceof String)) {
                    throw new FacebookJsonMappingException("Your Map keys must be of type " + String.class + " in order to be converted to JSON.  Offending map is " + object);
                }
                try {
                    jsonObject.put((String)entry.getKey(), this.toJsonInternal(entry.getValue()));
                }
                catch (JsonException e) {
                    throw new FacebookJsonMappingException("Unable to process value '" + entry.getValue() + "' for key '" + entry.getKey() + "' in Map " + object, e);
                }
            }
            return jsonObject;
        }
        if (ReflectionUtils.isPrimitive(object)) {
            return object;
        }
        if (object instanceof BigInteger) {
            return ((BigInteger)object).longValue();
        }
        if (object instanceof BigDecimal) {
            return ((BigDecimal)object).doubleValue();
        }
        List<ReflectionUtils.FieldWithAnnotation<Facebook>> fieldsWithAnnotation = ReflectionUtils.findFieldsWithAnnotation(object.getClass(), Facebook.class);
        JsonObject jsonObject = new JsonObject();
        Set<String> facebookFieldNamesWithMultipleMappings = this.facebookFieldNamesWithMultipleMappings(fieldsWithAnnotation);
        if (facebookFieldNamesWithMultipleMappings.size() > 0) {
            throw new FacebookJsonMappingException("Unable to convert to JSON because multiple @" + Facebook.class.getSimpleName() + " annotations for the same name are present: " + facebookFieldNamesWithMultipleMappings);
        }
        for (ReflectionUtils.FieldWithAnnotation<Facebook> fieldWithAnnotation : fieldsWithAnnotation) {
            String facebookFieldName = this.getFacebookFieldName(fieldWithAnnotation);
            fieldWithAnnotation.getField().setAccessible(true);
            try {
                jsonObject.put(facebookFieldName, this.toJsonInternal(fieldWithAnnotation.getField().get(object)));
            }
            catch (Exception e) {
                throw new FacebookJsonMappingException("Unable to process field '" + facebookFieldName + "' for " + object.getClass(), e);
            }
        }
        return jsonObject;
    }

    protected <T> T toPrimitiveJavaType(String json, Class<T> type) {
        if (String.class.equals(type)) {
            if (json.length() > 1 && json.startsWith("\"") && json.endsWith("\"")) {
                json = json.replaceFirst("\"", "");
                json = json.substring(0, json.length() - 1);
            }
            return (T)json;
        }
        if (Integer.class.equals(type) || Integer.TYPE.equals(type)) {
            return (T)new Integer(json);
        }
        if (Boolean.class.equals(type) || Boolean.TYPE.equals(type)) {
            return (T)new Boolean(json);
        }
        if (Long.class.equals(type) || Long.TYPE.equals(type)) {
            return (T)new Long(json);
        }
        if (Double.class.equals(type) || Double.TYPE.equals(type)) {
            return (T)new Double(json);
        }
        if (Float.class.equals(type) || Float.TYPE.equals(type)) {
            return (T)new Float(json);
        }
        if (BigInteger.class.equals(type)) {
            return (T)new BigInteger(json);
        }
        if (BigDecimal.class.equals(type)) {
            return (T)new BigDecimal(json);
        }
        if (this.jsonMappingErrorHandler.handleMappingError(json, type, null)) {
            return null;
        }
        throw new FacebookJsonMappingException("Don't know how to map JSON to " + type + ". Are you sure you're mapping to the right class? " + "Offending JSON is '" + json + "'.");
    }

    protected Object toJavaType(ReflectionUtils.FieldWithAnnotation<Facebook> fieldWithAnnotation, JsonObject jsonObject, String facebookFieldName) {
        Class<?> type = fieldWithAnnotation.getField().getType();
        Object rawValue = jsonObject.get(facebookFieldName);
        if (JsonObject.NULL.equals(rawValue)) {
            return null;
        }
        if (String.class.equals(type)) {
            if (rawValue instanceof JsonArray && ((JsonArray)rawValue).length() == 0) {
                if (logger.isLoggable(Level.FINER)) {
                    logger.finer("Coercing an empty JSON array to an empty string for " + fieldWithAnnotation);
                }
                return "";
            }
            return rawValue.toString();
        }
        if (Integer.class.equals(type) || Integer.TYPE.equals(type)) {
            return new Integer(jsonObject.getInt(facebookFieldName));
        }
        if (Boolean.class.equals(type) || Boolean.TYPE.equals(type)) {
            return new Boolean(jsonObject.getBoolean(facebookFieldName));
        }
        if (Long.class.equals(type) || Long.TYPE.equals(type)) {
            return new Long(jsonObject.getLong(facebookFieldName));
        }
        if (Double.class.equals(type) || Double.TYPE.equals(type)) {
            return new Double(jsonObject.getDouble(facebookFieldName));
        }
        if (Float.class.equals(type) || Float.TYPE.equals(type)) {
            return Float.valueOf(new BigDecimal(jsonObject.getString(facebookFieldName)).floatValue());
        }
        if (BigInteger.class.equals(type)) {
            return new BigInteger(jsonObject.getString(facebookFieldName));
        }
        if (BigDecimal.class.equals(type)) {
            return new BigDecimal(jsonObject.getString(facebookFieldName));
        }
        if (List.class.equals(type)) {
            return this.toJavaList(rawValue.toString(), ReflectionUtils.getFirstParameterizedTypeArgument(fieldWithAnnotation.getField()));
        }
        String rawValueAsString = rawValue.toString();
        if (Post.Comments.class.isAssignableFrom(type) && rawValue instanceof JsonArray) {
            if (logger.isLoggable(Level.FINE)) {
                logger.fine("Encountered comment array '" + rawValueAsString + "' but expected a " + Post.Comments.class.getSimpleName() + " object instead.  Working around that " + "by coercing into an empty " + Post.Comments.class.getSimpleName() + " instance...");
            }
            JsonObject workaroundJsonObject = new JsonObject();
            workaroundJsonObject.put("count", 0);
            workaroundJsonObject.put("data", new JsonArray());
            rawValueAsString = workaroundJsonObject.toString();
        }
        return this.toJavaObject(rawValueAsString, type);
    }

    protected <T> T createInstance(Class<T> type) {
        String errorMessage = "Unable to create an instance of " + type + ". Please make sure that it's marked 'public' " + "and, if it's a nested class, is marked 'static'. " + "It should have a public, no-argument constructor.";
        try {
            return type.newInstance();
        }
        catch (IllegalAccessException e) {
            throw new FacebookJsonMappingException(errorMessage, e);
        }
        catch (InstantiationException e) {
            throw new FacebookJsonMappingException(errorMessage, e);
        }
    }

    protected boolean isEmptyObject(String json) {
        return "{}".equals(json);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static interface JsonMappingErrorHandler {
        public boolean handleMappingError(String var1, Class<?> var2, Exception var3);
    }
}

