/*
 * Decompiled with CFR 0.152.
 */
package com.restfb;

import com.restfb.BaseFacebookClient;
import com.restfb.DefaultJsonMapper;
import com.restfb.DefaultWebRequestor;
import com.restfb.JsonMapper;
import com.restfb.LegacyFacebookClient;
import com.restfb.Parameter;
import com.restfb.WebRequestor;
import com.restfb.exception.FacebookJsonMappingException;
import com.restfb.exception.FacebookNetworkException;
import com.restfb.json.JsonArray;
import com.restfb.json.JsonException;
import com.restfb.json.JsonObject;
import com.restfb.util.StringUtils;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import java.util.logging.Level;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DefaultLegacyFacebookClient
extends BaseFacebookClient
implements LegacyFacebookClient {
    protected String apiKey;
    protected String secretKey;
    protected String accessToken;
    protected static final String FACEBOOK_REST_ENDPOINT_URL = "https://api.facebook.com/restserver.php";
    protected static final String FACEBOOK_READ_ONLY_ENDPOINT_URL = "https://api-read.facebook.com/restserver.php";
    protected static final String METHOD_PARAM_NAME = "method";
    protected static final String FORMAT_PARAM_NAME = "format";
    protected static final String FORMAT_PARAM_VALUE = "json";
    protected static final String API_KEY_PARAM_NAME = "api_key";
    protected static final String CALL_ID_PARAM_NAME = "call_id";
    protected static final String SIG_PARAM_NAME = "sig";
    protected static final String SESSION_KEY_PARAM_NAME = "session_key";
    protected static final String VERSION_PARAM_NAME = "v";
    protected static final String VERSION_PARAM_VALUE = "1.0";

    public DefaultLegacyFacebookClient(String accessToken) {
        this(accessToken, new DefaultWebRequestor(), new DefaultJsonMapper());
    }

    @Deprecated
    public DefaultLegacyFacebookClient(String apiKey, String secretKey) {
        this(apiKey, secretKey, new DefaultWebRequestor(), new DefaultJsonMapper());
    }

    @Deprecated
    public DefaultLegacyFacebookClient(String apiKey, String secretKey, WebRequestor webRequestor, JsonMapper jsonMapper) {
        this.verifyParameterPresence("apiKey", apiKey);
        this.verifyParameterPresence("secretKey", secretKey);
        this.verifyParameterPresence("webRequestor", webRequestor);
        this.verifyParameterPresence("jsonMapper", jsonMapper);
        this.apiKey = apiKey.trim();
        this.secretKey = secretKey.trim();
        this.webRequestor = webRequestor;
        this.jsonMapper = jsonMapper;
        this.initializeIllegalParamNames();
    }

    public DefaultLegacyFacebookClient(String accessToken, WebRequestor webRequestor, JsonMapper jsonMapper) {
        this.verifyParameterPresence("accessToken", accessToken);
        this.verifyParameterPresence("webRequestor", webRequestor);
        this.verifyParameterPresence("jsonMapper", jsonMapper);
        this.accessToken = accessToken.trim();
        this.webRequestor = webRequestor;
        this.jsonMapper = jsonMapper;
        this.initializeIllegalParamNames();
    }

    @Override
    public void execute(String method, Parameter ... parameters) {
        this.execute(method, (String)null, parameters);
    }

    @Override
    public void execute(String method, String sessionKey, Parameter ... parameters) {
        this.makeRequest(method, sessionKey, parameters);
    }

    @Override
    public <T> T execute(String method, Class<T> resultType, Parameter ... parameters) {
        return this.execute(method, null, resultType, parameters);
    }

    @Override
    public <T> T execute(String method, String sessionKey, Class<T> resultType, Parameter ... parameters) {
        return this.jsonMapper.toJavaObject(this.makeRequest(method, sessionKey, parameters), resultType);
    }

    @Override
    public <T> List<T> executeForList(String method, Class<T> resultType, Parameter ... parameters) {
        return this.executeForList(method, null, resultType, parameters);
    }

    @Override
    public <T> List<T> executeForList(String method, String sessionKey, Class<T> resultType, Parameter ... parameters) {
        return this.jsonMapper.toJavaList(this.makeRequest(method, sessionKey, parameters), resultType);
    }

    @Override
    public <T> T executeMultiquery(Map<String, String> queries, Class<T> resultType, Parameter ... additionalParameters) {
        return this.executeMultiquery(queries, resultType, additionalParameters);
    }

    @Override
    public <T> T executeMultiquery(Map<String, String> queries, String sessionKey, Class<T> resultType, Parameter ... additionalParameters) {
        ArrayList<Parameter> parameters = new ArrayList<Parameter>();
        parameters.add(Parameter.with("queries", this.queriesToJson(queries)));
        for (Parameter additionalParameter : additionalParameters) {
            if (additionalParameter.name.equals("queries")) {
                throw new IllegalArgumentException("You cannot specify a parameter named 'queries' because it's reserved for use by RestFB for this call. Specify your queries in the Map that gets passed to this method.");
            }
            parameters.add(additionalParameter);
        }
        JsonObject normalizedJson = new JsonObject();
        try {
            JsonArray jsonArray = new JsonArray(this.makeRequest("fql.multiquery", sessionKey, parameters.toArray(new Parameter[0])));
            for (int i = 0; i < jsonArray.length(); ++i) {
                JsonObject jsonObject = jsonArray.getJsonObject(i);
                JsonArray resultsArray = jsonObject.get("fql_result_set") instanceof JsonArray ? jsonObject.getJsonArray("fql_result_set") : new JsonArray();
                normalizedJson.put(jsonObject.getString("name"), resultsArray);
            }
        }
        catch (JsonException e) {
            throw new FacebookJsonMappingException("Unable to process fql.multiquery JSON response", e);
        }
        return this.jsonMapper.toJavaObject(normalizedJson.toString(), resultType);
    }

    protected String makeRequest(String method, String sessionKey, Parameter ... parameters) {
        this.verifyParameterLegality(parameters);
        String parametersAsString = this.toParameterString(method, sessionKey, parameters);
        WebRequestor.Response response = null;
        try {
            response = this.webRequestor.executePost(this.createEndpointForApiCall(method), parametersAsString);
        }
        catch (Throwable t) {
            throw new FacebookNetworkException("Facebook POST failed", t);
        }
        if (this.logger.isLoggable(Level.INFO)) {
            this.logger.info("Facebook responded with " + response);
        }
        if (200 != response.getStatusCode()) {
            throw new FacebookNetworkException("Facebook POST failed", response.getStatusCode());
        }
        String json = response.getBody();
        this.throwLegacyFacebookResponseStatusExceptionIfNecessary(json);
        return json;
    }

    protected String toParameterString(String method, String sessionKey, Parameter ... parameters) {
        TreeMap<String, String> sortedParameters = new TreeMap<String, String>();
        for (Parameter param : parameters) {
            sortedParameters.put(param.name, param.value);
        }
        sortedParameters.put(FORMAT_PARAM_NAME, FORMAT_PARAM_VALUE);
        sortedParameters.put(METHOD_PARAM_NAME, method);
        if (this.usesAccessTokenAuthentication()) {
            if (sessionKey != null) {
                throw new IllegalArgumentException("If you're using the OAuth access token for authentication, you cannot specify a session key.");
            }
            sortedParameters.put("access_token", this.accessToken);
        } else {
            sortedParameters.put(API_KEY_PARAM_NAME, this.apiKey);
            sortedParameters.put(VERSION_PARAM_NAME, VERSION_PARAM_VALUE);
            sortedParameters.put(CALL_ID_PARAM_NAME, String.valueOf(System.currentTimeMillis()));
            if (!StringUtils.isBlank(sessionKey)) {
                sortedParameters.put(SESSION_KEY_PARAM_NAME, sessionKey);
            }
            sortedParameters.put(SIG_PARAM_NAME, this.generateSignature(sortedParameters));
        }
        StringBuilder parameterStringBuilder = new StringBuilder();
        boolean first = true;
        for (Map.Entry entry : sortedParameters.entrySet()) {
            if (first) {
                first = false;
            } else {
                parameterStringBuilder.append("&");
            }
            parameterStringBuilder.append(StringUtils.urlEncode((String)entry.getKey()));
            parameterStringBuilder.append("=");
            parameterStringBuilder.append(this.usesAccessTokenAuthentication() ? this.urlEncodedValueForParameterName((String)entry.getKey(), (String)entry.getValue()) : StringUtils.urlEncode((String)entry.getValue()));
        }
        return parameterStringBuilder.toString();
    }

    protected String generateSignature(Map<String, String> sortedParameters) {
        StringBuilder parameterString = new StringBuilder();
        for (Map.Entry<String, String> entry : sortedParameters.entrySet()) {
            parameterString.append(entry.getKey());
            parameterString.append("=");
            parameterString.append(entry.getValue());
        }
        parameterString.append(this.secretKey);
        return this.generateMd5(parameterString.toString());
    }

    protected String generateMd5(String string) {
        try {
            MessageDigest messageDigest = MessageDigest.getInstance("MD5");
            byte[] bytes = StringUtils.toBytes(string);
            StringBuilder result = new StringBuilder();
            for (byte b : messageDigest.digest(bytes)) {
                result.append(Integer.toHexString((b & 0xF0) >>> 4));
                result.append(Integer.toHexString(b & 0xF));
            }
            return result.toString();
        }
        catch (NoSuchAlgorithmException e) {
            throw new IllegalStateException("MD5 isn't available on this JVM", e);
        }
    }

    protected boolean usesAccessTokenAuthentication() {
        return !StringUtils.isBlank(this.accessToken);
    }

    @Override
    protected String createEndpointForApiCall(String apiCall) {
        return this.readOnlyApiCalls.contains(apiCall = StringUtils.trimToEmpty(apiCall).toLowerCase()) ? this.getFacebookReadOnlyEndpointUrl() : this.getFacebookRestEndpointUrl();
    }

    protected void initializeIllegalParamNames() {
        this.illegalParamNames.addAll(Arrays.asList(API_KEY_PARAM_NAME, CALL_ID_PARAM_NAME, SIG_PARAM_NAME, METHOD_PARAM_NAME, SESSION_KEY_PARAM_NAME, FORMAT_PARAM_NAME, VERSION_PARAM_NAME, "access_token"));
    }

    protected String getFacebookRestEndpointUrl() {
        return FACEBOOK_REST_ENDPOINT_URL;
    }

    @Override
    protected String getFacebookReadOnlyEndpointUrl() {
        return FACEBOOK_READ_ONLY_ENDPOINT_URL;
    }
}

