/*
 * Decompiled with CFR 0.152.
 */
package com.restfb;

import com.restfb.WebRequestor;
import com.restfb.util.StringUtils;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.HttpURLConnection;
import java.net.URL;
import java.util.logging.Level;
import java.util.logging.Logger;

public class DefaultWebRequestor
implements WebRequestor {
    private static final String MULTIPART_BOUNDARY = "**boundarystringwhichwill**neverbeencounteredinthewild**";
    private static final String MULTIPART_CARRIAGE_RETURN_AND_NEWLINE = "\r\n";
    private static final String MULTIPART_TWO_HYPHENS = "--";
    private static final int MULTIPART_DEFAULT_BUFFER_SIZE = 8192;
    private static final int DEFAULT_READ_TIMEOUT_IN_MS = 60000;
    private static final Logger logger = Logger.getLogger(DefaultWebRequestor.class.getName());

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public WebRequestor.Response executeGet(String url) throws IOException {
        if (logger.isLoggable(Level.INFO)) {
            logger.info("Making a GET request to " + url);
        }
        HttpURLConnection httpUrlConnection = null;
        InputStream inputStream = null;
        try {
            block6: {
                httpUrlConnection = this.openConnection(new URL(url));
                httpUrlConnection.setReadTimeout(60000);
                httpUrlConnection.setUseCaches(false);
                this.customizeConnection(httpUrlConnection);
                httpUrlConnection.setRequestMethod("GET");
                httpUrlConnection.connect();
                if (logger.isLoggable(Level.FINER)) {
                    logger.finer("Response headers: " + httpUrlConnection.getHeaderFields());
                }
                try {
                    inputStream = httpUrlConnection.getResponseCode() != 200 ? httpUrlConnection.getErrorStream() : httpUrlConnection.getInputStream();
                }
                catch (IOException e) {
                    if (!logger.isLoggable(Level.WARNING)) break block6;
                    logger.warning("An error occurred while making a GET request to " + url + ": " + e);
                }
            }
            WebRequestor.Response response = new WebRequestor.Response(httpUrlConnection.getResponseCode(), StringUtils.fromInputStream(inputStream));
            this.closeQuietly(httpUrlConnection);
            return response;
        }
        catch (Throwable throwable) {
            this.closeQuietly(httpUrlConnection);
            throw throwable;
        }
    }

    public WebRequestor.Response executePost(String url, String parameters) throws IOException {
        return this.executePost(url, parameters, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public WebRequestor.Response executePost(String url, String parameters, InputStream binaryAttachment) throws IOException {
        boolean hasBinaryAttachment;
        boolean bl = hasBinaryAttachment = binaryAttachment != null;
        if (logger.isLoggable(Level.INFO)) {
            logger.info("Executing a POST to " + url + " with parameters " + (hasBinaryAttachment ? "" : "(sent in request body): ") + parameters + (hasBinaryAttachment ? " and a binary attachment." : ""));
        }
        HttpURLConnection httpUrlConnection = null;
        OutputStream outputStream = null;
        InputStream inputStream = null;
        try {
            block9: {
                httpUrlConnection = this.openConnection(new URL(url + (hasBinaryAttachment ? "?" + parameters : "")));
                httpUrlConnection.setReadTimeout(60000);
                this.customizeConnection(httpUrlConnection);
                httpUrlConnection.setRequestMethod("POST");
                httpUrlConnection.setDoOutput(true);
                httpUrlConnection.setUseCaches(false);
                if (hasBinaryAttachment) {
                    httpUrlConnection.setRequestProperty("Connection", "Keep-Alive");
                    httpUrlConnection.setRequestProperty("Content-Type", "multipart/form-data;boundary=**boundarystringwhichwill**neverbeencounteredinthewild**");
                }
                httpUrlConnection.connect();
                outputStream = httpUrlConnection.getOutputStream();
                if (hasBinaryAttachment) {
                    outputStream.write("--**boundarystringwhichwill**neverbeencounteredinthewild**\r\nContent-Disposition: form-data; filename=\"test.jpg\"\r\n\r\n".getBytes("UTF-8"));
                    this.write(binaryAttachment, outputStream, 8192);
                    outputStream.write("\r\n--**boundarystringwhichwill**neverbeencounteredinthewild**--\r\n".getBytes("UTF-8"));
                } else {
                    outputStream.write(parameters.getBytes("UTF-8"));
                }
                if (logger.isLoggable(Level.FINER)) {
                    logger.finer("Response headers: " + httpUrlConnection.getHeaderFields());
                }
                try {
                    inputStream = httpUrlConnection.getResponseCode() != 200 ? httpUrlConnection.getErrorStream() : httpUrlConnection.getInputStream();
                }
                catch (IOException e) {
                    if (!logger.isLoggable(Level.WARNING)) break block9;
                    logger.warning("An error occurred while POSTing to " + url + ": " + e);
                }
            }
            WebRequestor.Response response = new WebRequestor.Response(httpUrlConnection.getResponseCode(), StringUtils.fromInputStream(inputStream));
            this.closeQuietly(binaryAttachment);
            this.closeQuietly(outputStream);
            this.closeQuietly(httpUrlConnection);
            return response;
        }
        catch (Throwable throwable) {
            this.closeQuietly(binaryAttachment);
            this.closeQuietly(outputStream);
            this.closeQuietly(httpUrlConnection);
            throw throwable;
        }
    }

    protected HttpURLConnection openConnection(URL url) throws IOException {
        return (HttpURLConnection)url.openConnection();
    }

    protected void customizeConnection(HttpURLConnection connection) {
    }

    protected void closeQuietly(Closeable closeable) {
        block3: {
            if (closeable == null) {
                return;
            }
            try {
                closeable.close();
            }
            catch (Throwable t) {
                if (!logger.isLoggable(Level.WARNING)) break block3;
                logger.warning("Unable to close " + closeable + ": " + t);
            }
        }
    }

    protected void closeQuietly(HttpURLConnection httpUrlConnection) {
        block3: {
            if (httpUrlConnection == null) {
                return;
            }
            try {
                httpUrlConnection.disconnect();
            }
            catch (Throwable t) {
                if (!logger.isLoggable(Level.WARNING)) break block3;
                logger.warning("Unable to disconnect " + httpUrlConnection + ": " + t);
            }
        }
    }

    protected void write(InputStream source, OutputStream destination, int bufferSize) throws IOException {
        if (source == null || destination == null) {
            throw new NullPointerException("Must provide non-null source and destination streams.");
        }
        int read = 0;
        byte[] chunk = new byte[bufferSize];
        while ((read = source.read(chunk)) > 0) {
            destination.write(chunk, 0, read);
        }
    }
}

