/*
 * Decompiled with CFR 0.152.
 */
package com.restfb.util;

import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.logging.Level;
import java.util.logging.Logger;

public final class DateUtils {
    public static final String FACEBOOK_LONG_DATE_FORMAT = "yyyy-MM-dd'T'HH:mm:ssZ";
    public static final String FACEBOOK_LONG_DATE_FORMAT_WITHOUT_TIMEZONE = "yyyy-MM-dd'T'HH:mm:ss";
    public static final String FACEBOOK_SHORT_DATE_FORMAT = "MM/dd/yyyy";
    public static final String FACEBOOK_MONTH_YEAR_DATE_FORMAT = "yyyy-MM";
    private static final Logger logger = Logger.getLogger(DateUtils.class.getName());

    private DateUtils() {
    }

    public static Date toDateFromLongFormat(String date) {
        Date parsedDate = DateUtils.toDateWithFormatString(date, FACEBOOK_LONG_DATE_FORMAT);
        if (parsedDate == null) {
            parsedDate = DateUtils.toDateWithFormatString(date, FACEBOOK_LONG_DATE_FORMAT_WITHOUT_TIMEZONE);
        }
        return parsedDate;
    }

    public static Date toDateFromShortFormat(String date) {
        return DateUtils.toDateWithFormatString(date, FACEBOOK_SHORT_DATE_FORMAT);
    }

    public static Date toDateFromMonthYearFormat(String date) {
        if ("0000-00".equals(date)) {
            return null;
        }
        return DateUtils.toDateWithFormatString(date, FACEBOOK_MONTH_YEAR_DATE_FORMAT);
    }

    private static Date toDateWithFormatString(String date, String format) {
        if (date == null) {
            return null;
        }
        try {
            return new SimpleDateFormat(format).parse(date);
        }
        catch (ParseException e) {
            if (logger.isLoggable(Level.FINE)) {
                logger.fine("Unable to parse date '" + date + "' using format string '" + format + "': " + e);
            }
            return null;
        }
    }
}

