/*
 * Decompiled with CFR 0.152.
 */
package com.restfb.util;

import java.lang.annotation.Annotation;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class ReflectionUtils {
    private static final Map<ClassAnnotationCacheKey, List<?>> FIELDS_WITH_ANNOTATION_CACHE = Collections.synchronizedMap(new HashMap());

    private ReflectionUtils() {
    }

    public static boolean isPrimitive(Object object) {
        if (object == null) {
            return false;
        }
        Class<?> type = object.getClass();
        return object instanceof String || object instanceof Integer || Integer.TYPE.equals(type) || object instanceof Boolean || Boolean.TYPE.equals(type) || object instanceof Long || Long.TYPE.equals(type) || object instanceof Double || Double.TYPE.equals(type) || object instanceof Float || Float.TYPE.equals(type) || object instanceof Byte || Byte.TYPE.equals(type) || object instanceof Short || Short.TYPE.equals(type) || object instanceof Character || Character.TYPE.equals(type);
    }

    public static <T extends Annotation> List<FieldWithAnnotation<T>> findFieldsWithAnnotation(Class<?> type, Class<T> annotationType) {
        ClassAnnotationCacheKey cacheKey = new ClassAnnotationCacheKey(type, annotationType);
        List<FieldWithAnnotation<T>> cachedResults = FIELDS_WITH_ANNOTATION_CACHE.get(cacheKey);
        if (cachedResults != null) {
            return cachedResults;
        }
        ArrayList<FieldWithAnnotation<T>> fieldsWithAnnotation = new ArrayList();
        while (!Object.class.equals(type)) {
            for (Field field : type.getDeclaredFields()) {
                T annotation = field.getAnnotation(annotationType);
                if (annotation == null) continue;
                fieldsWithAnnotation.add(new FieldWithAnnotation<T>(field, annotation));
            }
            type = type.getSuperclass();
        }
        fieldsWithAnnotation = Collections.unmodifiableList(fieldsWithAnnotation);
        FIELDS_WITH_ANNOTATION_CACHE.put(cacheKey, fieldsWithAnnotation);
        return fieldsWithAnnotation;
    }

    public static Class<?> getFirstParameterizedTypeArgument(Field field) {
        Type type = field.getGenericType();
        if (!(type instanceof ParameterizedType)) {
            return null;
        }
        ParameterizedType parameterizedType = (ParameterizedType)type;
        Type firstTypeArgument = parameterizedType.getActualTypeArguments()[0];
        return firstTypeArgument instanceof Class ? (Class)firstTypeArgument : null;
    }

    public static List<Method> getAccessors(Class<?> clazz) {
        if (clazz == null) {
            throw new IllegalArgumentException("The 'clazz' parameter cannot be null.");
        }
        ArrayList<Method> methods = new ArrayList<Method>();
        for (Method method : clazz.getMethods()) {
            String methodName = method.getName();
            if ("getClass".equals(methodName) || "hashCode".equals(methodName) || method.getReturnType() == null || Void.class.equals(method.getReturnType()) || method.getParameterTypes().length != 0 || !(methodName.startsWith("get") && methodName.length() > 3 || methodName.startsWith("is") && methodName.length() > 2) && (!methodName.startsWith("has") || methodName.length() <= 3)) continue;
            methods.add(method);
        }
        Collections.sort(methods, new Comparator<Method>(){

            @Override
            public int compare(Method method1, Method method2) {
                return method1.getName().compareTo(method2.getName());
            }
        });
        return Collections.unmodifiableList(methods);
    }

    public static String toString(Object object) {
        StringBuilder buffer = new StringBuilder(object.getClass().getSimpleName());
        buffer.append("[");
        boolean first = true;
        for (Method method : ReflectionUtils.getAccessors(object.getClass())) {
            if (first) {
                first = false;
            } else {
                buffer.append(" ");
            }
            try {
                String methodName = method.getName();
                int offset = methodName.startsWith("is") ? 2 : 3;
                methodName = methodName.substring(offset, offset + 1).toLowerCase() + methodName.substring(offset + 1);
                buffer.append(methodName);
                buffer.append("=");
                buffer.append(method.invoke(object, new Object[0]));
            }
            catch (Exception e) {
                throw new IllegalStateException("Unable to reflectively invoke " + method + " on " + object.getClass(), e);
            }
        }
        buffer.append("]");
        return buffer.toString();
    }

    public static int hashCode(Object object) {
        if (object == null) {
            return 0;
        }
        int hashCode = 17;
        for (Method method : ReflectionUtils.getAccessors(object.getClass())) {
            try {
                Object result = method.invoke(object, new Object[0]);
                if (result == null) continue;
                hashCode = hashCode * 31 + result.hashCode();
            }
            catch (Exception e) {
                throw new IllegalStateException("Unable to reflectively invoke " + method + " on " + object, e);
            }
        }
        return hashCode;
    }

    public static boolean equals(Object object1, Object object2) {
        if (object1 == null && object2 == null) {
            return true;
        }
        if (object1 == null || object2 == null) {
            return false;
        }
        if (!object1.getClass().isInstance(object2) && !object2.getClass().isInstance(object1)) {
            return false;
        }
        HashSet<Method> accessorMethodsIntersection = new HashSet<Method>(ReflectionUtils.getAccessors(object1.getClass()));
        accessorMethodsIntersection.retainAll(ReflectionUtils.getAccessors(object2.getClass()));
        for (Method method : accessorMethodsIntersection) {
            try {
                Object result1 = method.invoke(object1, new Object[0]);
                Object result2 = method.invoke(object2, new Object[0]);
                if (result1 == null && result2 == null) continue;
                if (result1 == null || result2 == null) {
                    return false;
                }
                if (result1.equals(result2)) continue;
                return false;
            }
            catch (Exception e) {
                throw new IllegalStateException("Unable to reflectively invoke " + method, e);
            }
        }
        return true;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static final class ClassAnnotationCacheKey {
        private final Class<?> clazz;
        private final Class<? extends Annotation> annotation;

        private ClassAnnotationCacheKey(Class<?> clazz, Class<? extends Annotation> annotation) {
            this.clazz = clazz;
            this.annotation = annotation;
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + (this.annotation == null ? 0 : this.annotation.hashCode());
            result = 31 * result + (this.clazz == null ? 0 : this.clazz.hashCode());
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            ClassAnnotationCacheKey other = (ClassAnnotationCacheKey)obj;
            if (this.annotation == null ? other.annotation != null : !this.annotation.equals(other.annotation)) {
                return false;
            }
            return !(this.clazz == null ? other.clazz != null : !this.clazz.equals(other.clazz));
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class FieldWithAnnotation<T extends Annotation> {
        private Field field;
        private T annotation;

        public FieldWithAnnotation(Field field, T annotation) {
            this.field = field;
            this.annotation = annotation;
        }

        public Field getField() {
            return this.field;
        }

        public T getAnnotation() {
            return this.annotation;
        }

        public String toString() {
            return String.format("Field %s.%s (%s): %s", this.field.getDeclaringClass().getName(), this.field.getName(), this.field.getType(), this.annotation);
        }
    }
}

