/*
 * Decompiled with CFR 0.152.
 */
package com.restfb.util;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.util.Arrays;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class StringUtils {
    public static final String ENCODING_CHARSET = "UTF-8";
    private static final Logger logger = Logger.getLogger(StringUtils.class.getName());

    private StringUtils() {
    }

    public static boolean isBlank(String string) {
        return string == null || "".equals(string.trim());
    }

    public static String trimToNull(String string) {
        if (StringUtils.isBlank(string)) {
            return null;
        }
        return string.trim();
    }

    public static String trimToEmpty(String string) {
        if (StringUtils.isBlank(string)) {
            return "";
        }
        return string.trim();
    }

    public static String urlEncode(String string) {
        if (string == null) {
            return null;
        }
        try {
            return URLEncoder.encode(string, ENCODING_CHARSET);
        }
        catch (UnsupportedEncodingException e) {
            throw new IllegalStateException("Platform doesn't support UTF-8", e);
        }
    }

    public static byte[] toBytes(String string) {
        if (string == null) {
            throw new NullPointerException("Parameter 'string' cannot be null.");
        }
        try {
            return string.getBytes(ENCODING_CHARSET);
        }
        catch (UnsupportedEncodingException e) {
            throw new IllegalStateException("Platform doesn't support UTF-8", e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String fromInputStream(InputStream inputStream) throws IOException {
        if (inputStream == null) {
            return null;
        }
        BufferedReader reader = null;
        try {
            reader = new BufferedReader(new InputStreamReader(inputStream, ENCODING_CHARSET));
            StringBuilder response = new StringBuilder();
            String line = null;
            while ((line = reader.readLine()) != null) {
                response.append(line);
            }
            String string = response.toString();
            return string;
        }
        finally {
            block10: {
                if (reader != null) {
                    try {
                        reader.close();
                    }
                    catch (Throwable t) {
                        if (!logger.isLoggable(Level.WARNING)) break block10;
                        logger.warning("Unable to close stream, continuing on: " + t);
                    }
                }
            }
        }
    }

    public static String join(String[] array) {
        return array == null ? null : StringUtils.join(Arrays.asList(array));
    }

    public static String join(List<String> list) {
        if (list == null) {
            return null;
        }
        StringBuilder joined = new StringBuilder();
        boolean first = true;
        for (String element : list) {
            if (first) {
                first = false;
            } else {
                joined.append(",");
            }
            joined.append(element);
        }
        return joined.toString();
    }
}

