/*
 * Decompiled with CFR 0.152.
 */
package com.restfb;

import com.restfb.FacebookClient;
import com.restfb.exception.FacebookJsonMappingException;
import com.restfb.json.JsonArray;
import com.restfb.json.JsonException;
import com.restfb.json.JsonObject;
import com.restfb.util.ReflectionUtils;
import com.restfb.util.StringUtils;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Connection<T>
implements Iterable<List<T>> {
    private FacebookClient facebookClient;
    private Class<T> connectionType;
    private List<T> data;
    private String previousPageUrl;
    private String nextPageUrl;

    @Override
    public Iterator<List<T>> iterator() {
        return new ConnectionIterator(this);
    }

    public Connection(FacebookClient facebookClient, String string, Class<T> clazz) {
        ArrayList<Object> arrayList = new ArrayList<Object>();
        if (string == null) {
            throw new FacebookJsonMappingException("You must supply non-null connection JSON.");
        }
        JsonObject jsonObject = null;
        try {
            jsonObject = new JsonObject(string);
        }
        catch (JsonException jsonException) {
            throw new FacebookJsonMappingException("The connection JSON you provided was invalid: " + string, jsonException);
        }
        JsonArray jsonArray = jsonObject.getJsonArray("data");
        for (int i = 0; i < jsonArray.length(); ++i) {
            arrayList.add(clazz.equals(JsonObject.class) ? jsonArray.get(i) : facebookClient.getJsonMapper().toJavaObject(jsonArray.get(i).toString(), clazz));
        }
        if (jsonObject.has("paging")) {
            JsonObject jsonObject2 = jsonObject.getJsonObject("paging");
            this.previousPageUrl = jsonObject2.has("previous") ? jsonObject2.getString("previous") : null;
            this.nextPageUrl = jsonObject2.has("next") ? jsonObject2.getString("next") : null;
        } else {
            this.previousPageUrl = null;
            this.nextPageUrl = null;
        }
        this.data = Collections.unmodifiableList(arrayList);
        this.facebookClient = facebookClient;
        this.connectionType = clazz;
    }

    protected Connection<T> fetchNextPage() {
        return this.facebookClient.fetchConnectionPage(this.getNextPageUrl(), this.connectionType);
    }

    public String toString() {
        return ReflectionUtils.toString(this);
    }

    public boolean equals(Object object) {
        return ReflectionUtils.equals(this, object);
    }

    public int hashCode() {
        return ReflectionUtils.hashCode(this);
    }

    public List<T> getData() {
        return this.data;
    }

    public String getPreviousPageUrl() {
        return this.previousPageUrl;
    }

    public String getNextPageUrl() {
        return this.nextPageUrl;
    }

    public boolean hasPrevious() {
        return !StringUtils.isBlank(this.getPreviousPageUrl());
    }

    public boolean hasNext() {
        return !StringUtils.isBlank(this.getNextPageUrl());
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected static class ConnectionIterator<T>
    implements Iterator<List<T>> {
        private Connection<T> connection;
        private boolean initialPage = true;

        protected ConnectionIterator(Connection<T> connection) {
            this.connection = connection;
        }

        @Override
        public boolean hasNext() {
            if (this.initialPage) {
                return true;
            }
            return this.connection.hasNext();
        }

        @Override
        public List<T> next() {
            if (this.initialPage) {
                this.initialPage = false;
                return this.connection.getData();
            }
            if (!this.connection.hasNext()) {
                throw new NoSuchElementException("There are no more pages in the connection.");
            }
            this.connection = this.connection.fetchNextPage();
            return this.connection.getData();
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException(ConnectionIterator.class.getSimpleName() + " doesn't support the remove() operation.");
        }
    }
}

