/*
 * Decompiled with CFR 0.152.
 */
package com.restfb;

import com.restfb.BaseFacebookClient;
import com.restfb.BinaryAttachment;
import com.restfb.Connection;
import com.restfb.DefaultJsonMapper;
import com.restfb.DefaultWebRequestor;
import com.restfb.FacebookClient;
import com.restfb.JsonMapper;
import com.restfb.Parameter;
import com.restfb.WebRequestor;
import com.restfb.batch.BatchRequest;
import com.restfb.batch.BatchResponse;
import com.restfb.exception.FacebookException;
import com.restfb.exception.FacebookExceptionMapper;
import com.restfb.exception.FacebookGraphException;
import com.restfb.exception.FacebookJsonMappingException;
import com.restfb.exception.FacebookNetworkException;
import com.restfb.exception.FacebookOAuthException;
import com.restfb.exception.FacebookQueryParseException;
import com.restfb.json.JsonArray;
import com.restfb.json.JsonException;
import com.restfb.json.JsonObject;
import com.restfb.util.StringUtils;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DefaultFacebookClient
extends BaseFacebookClient
implements FacebookClient {
    protected String accessToken;
    protected FacebookExceptionMapper graphFacebookExceptionMapper;
    protected static final String FACEBOOK_GRAPH_ENDPOINT_URL = "https://graph.facebook.com";
    protected static final String FACEBOOK_READ_ONLY_ENDPOINT_URL = "https://api-read.facebook.com/method";
    protected static final String FACEBOOK_GRAPH_VIDEO_ENDPOINT_URL = "https://graph-video.facebook.com";
    protected static final String METHOD_PARAM_NAME = "method";
    protected static final String IDS_PARAM_NAME = "ids";
    protected static final String QUERY_PARAM_NAME = "query";
    protected static final String QUERIES_PARAM_NAME = "queries";
    protected static final String FORMAT_PARAM_NAME = "format";
    protected static final String ERROR_ATTRIBUTE_NAME = "error";
    protected static final String ERROR_TYPE_ATTRIBUTE_NAME = "type";
    protected static final String ERROR_MESSAGE_ATTRIBUTE_NAME = "message";
    protected static final String BATCH_ERROR_ATTRIBUTE_NAME = "error";
    protected static final String BATCH_ERROR_DESCRIPTION_ATTRIBUTE_NAME = "error_description";

    public DefaultFacebookClient() {
        this(null);
    }

    public DefaultFacebookClient(String string) {
        this(string, new DefaultWebRequestor(), new DefaultJsonMapper());
    }

    public DefaultFacebookClient(String string, WebRequestor webRequestor, JsonMapper jsonMapper) {
        this.verifyParameterPresence("jsonMapper", jsonMapper);
        this.verifyParameterPresence("webRequestor", webRequestor);
        this.accessToken = StringUtils.trimToNull(string);
        this.webRequestor = webRequestor;
        this.jsonMapper = jsonMapper;
        this.graphFacebookExceptionMapper = this.createGraphFacebookExceptionMapper();
        this.illegalParamNames.addAll(Arrays.asList("access_token", METHOD_PARAM_NAME, FORMAT_PARAM_NAME));
    }

    @Override
    public boolean deleteObject(String string) {
        this.verifyParameterPresence("object", string);
        return "true".equals(this.makeRequest(string, true, true, null, new Parameter[0]));
    }

    @Override
    public <T> Connection<T> fetchConnection(String string, Class<T> clazz, Parameter ... parameterArray) {
        this.verifyParameterPresence("connection", string);
        this.verifyParameterPresence("connectionType", clazz);
        return new Connection<T>(this, this.makeRequest(string, parameterArray), clazz);
    }

    @Override
    public <T> Connection<T> fetchConnectionPage(final String string, Class<T> clazz) {
        String string2 = this.makeRequestAndProcessResponse(new Requestor(){

            public WebRequestor.Response makeRequest() throws IOException {
                return DefaultFacebookClient.this.webRequestor.executeGet(string);
            }
        });
        return new Connection<T>(this, string2, clazz);
    }

    @Override
    public <T> T fetchObject(String string, Class<T> clazz, Parameter ... parameterArray) {
        this.verifyParameterPresence("object", string);
        this.verifyParameterPresence("objectType", clazz);
        return this.jsonMapper.toJavaObject(this.makeRequest(string, parameterArray), clazz);
    }

    @Override
    public <T> T fetchObjects(List<String> list, Class<T> clazz, Parameter ... parameterArray) {
        this.verifyParameterPresence(IDS_PARAM_NAME, list);
        this.verifyParameterPresence("connectionType", clazz);
        if (list.size() == 0) {
            throw new IllegalArgumentException("The list of IDs cannot be empty.");
        }
        for (Parameter parameter : parameterArray) {
            if (!IDS_PARAM_NAME.equals(parameter.name)) continue;
            throw new IllegalArgumentException("You cannot specify the 'ids' URL parameter yourself - RestFB will populate this for you with the list of IDs you passed to this method.");
        }
        for (int i = 0; i < list.size(); ++i) {
            String string = list.get(i).trim().toLowerCase();
            if ("".equals(string)) {
                throw new IllegalArgumentException("The list of IDs cannot contain blank strings.");
            }
            list.set(i, string);
        }
        try {
            JsonObject jsonObject = new JsonObject(this.makeRequest("", this.parametersWithAdditionalParameter(Parameter.with(IDS_PARAM_NAME, StringUtils.join(list)), parameterArray)));
            return (T)(clazz.equals(JsonObject.class) ? jsonObject : this.jsonMapper.toJavaObject(jsonObject.toString(), clazz));
        }
        catch (JsonException jsonException) {
            throw new FacebookJsonMappingException("Unable to map connection JSON to Java objects", jsonException);
        }
    }

    @Override
    public <T> T publish(String string, Class<T> clazz, BinaryAttachment binaryAttachment, Parameter ... parameterArray) {
        this.verifyParameterPresence("connection", string);
        ArrayList<BinaryAttachment> arrayList = new ArrayList<BinaryAttachment>();
        if (binaryAttachment != null) {
            arrayList.add(binaryAttachment);
        }
        return this.jsonMapper.toJavaObject(this.makeRequest(string, true, false, arrayList, parameterArray), clazz);
    }

    @Override
    public <T> T publish(String string, Class<T> clazz, Parameter ... parameterArray) {
        return this.publish(string, clazz, (BinaryAttachment)null, parameterArray);
    }

    @Override
    public <T> T executeMultiquery(Map<String, String> map, Class<T> clazz, Parameter ... parameterArray) {
        this.verifyParameterPresence("objectType", clazz);
        for (Parameter object : parameterArray) {
            if (!QUERIES_PARAM_NAME.equals(object.name)) continue;
            throw new IllegalArgumentException("You cannot specify the 'queries' URL parameter yourself - RestFB will populate this for you with the queries you passed to this method.");
        }
        try {
            JsonArray jsonArray = new JsonArray(this.makeRequest("fql.multiquery", false, false, null, this.parametersWithAdditionalParameter(Parameter.with(QUERIES_PARAM_NAME, this.queriesToJson(map)), parameterArray)));
            JsonObject jsonObject = new JsonObject();
            for (int i = 0; i < jsonArray.length(); ++i) {
                JsonObject jsonObject2 = jsonArray.getJsonObject(i);
                JsonArray jsonArray2 = jsonObject2.get("fql_result_set") instanceof JsonArray ? jsonObject2.getJsonArray("fql_result_set") : new JsonArray();
                jsonObject.put(jsonObject2.getString("name"), jsonArray2);
            }
            return (T)(clazz.equals(JsonObject.class) ? jsonObject : this.jsonMapper.toJavaObject(jsonObject.toString(), clazz));
        }
        catch (JsonException jsonException) {
            throw new FacebookJsonMappingException("Unable to process fql.multiquery JSON response", jsonException);
        }
    }

    @Override
    public <T> List<T> executeQuery(String string, Class<T> clazz, Parameter ... parameterArray) {
        this.verifyParameterPresence(QUERY_PARAM_NAME, string);
        this.verifyParameterPresence("objectType", clazz);
        for (Parameter parameter : parameterArray) {
            if (!QUERY_PARAM_NAME.equals(parameter.name)) continue;
            throw new IllegalArgumentException("You cannot specify the 'query' URL parameter yourself - RestFB will populate this for you with the query you passed to this method.");
        }
        return this.jsonMapper.toJavaList(this.makeRequest("fql.query", false, false, null, this.parametersWithAdditionalParameter(Parameter.with(QUERY_PARAM_NAME, string), parameterArray)), clazz);
    }

    @Override
    public List<BatchResponse> executeBatch(BatchRequest ... batchRequestArray) {
        return this.executeBatch(Arrays.asList(batchRequestArray), Collections.<BinaryAttachment>emptyList());
    }

    @Override
    public List<BatchResponse> executeBatch(List<BatchRequest> list, List<BinaryAttachment> list2) {
        this.verifyParameterPresence("binaryAttachments", list2);
        if (list == null || list.size() == 0) {
            throw new IllegalArgumentException("You must specify at least one batch request.");
        }
        return this.jsonMapper.toJavaList(this.makeRequest("", true, false, list2, Parameter.with("batch", this.jsonMapper.toJson(list, true))), BatchResponse.class);
    }

    @Override
    public List<FacebookClient.AccessToken> convertSessionKeysToAccessTokens(String string, String string2, String ... stringArray) {
        this.verifyParameterPresence("appId", string);
        this.verifyParameterPresence("secretKey", string2);
        if (stringArray == null || stringArray.length == 0) {
            return Collections.emptyList();
        }
        String string3 = this.makeRequest("/oauth/exchange_sessions", true, false, null, Parameter.with("client_id", string), Parameter.with("client_secret", string2), Parameter.with("sessions", StringUtils.join(stringArray)));
        return this.jsonMapper.toJavaList(string3, FacebookClient.AccessToken.class);
    }

    @Override
    public JsonMapper getJsonMapper() {
        return this.jsonMapper;
    }

    @Override
    public WebRequestor getWebRequestor() {
        return this.webRequestor;
    }

    protected String makeRequest(String string, Parameter ... parameterArray) {
        return this.makeRequest(string, false, false, null, parameterArray);
    }

    protected String makeRequest(String string, final boolean bl, boolean bl2, final List<BinaryAttachment> list, Parameter ... parameterArray) {
        this.verifyParameterLegality(parameterArray);
        if (bl2) {
            parameterArray = this.parametersWithAdditionalParameter(Parameter.with(METHOD_PARAM_NAME, "delete"), parameterArray);
        }
        StringUtils.trimToEmpty(string).toLowerCase();
        if (!string.startsWith("/")) {
            string = "/" + string;
        }
        final String string2 = this.createEndpointForApiCall(string, list != null && list.size() > 0);
        final String string3 = this.toParameterString(parameterArray);
        return this.makeRequestAndProcessResponse(new Requestor(){

            public WebRequestor.Response makeRequest() throws IOException {
                return bl ? DefaultFacebookClient.this.webRequestor.executePost(string2, string3, list == null ? null : list.toArray(new BinaryAttachment[0])) : DefaultFacebookClient.this.webRequestor.executeGet(string2 + "?" + string3);
            }
        });
    }

    protected String makeRequestAndProcessResponse(Requestor requestor) {
        WebRequestor.Response response = null;
        try {
            response = requestor.makeRequest();
        }
        catch (Throwable throwable) {
            throw new FacebookNetworkException("Facebook request failed", throwable);
        }
        if (this.logger.isLoggable(Level.INFO)) {
            this.logger.info("Facebook responded with " + response);
        }
        if (200 != response.getStatusCode() && 400 != response.getStatusCode() && 401 != response.getStatusCode() && 500 != response.getStatusCode() && 403 != response.getStatusCode()) {
            throw new FacebookNetworkException("Facebook request failed", response.getStatusCode());
        }
        String string = response.getBody();
        this.throwFacebookResponseStatusExceptionIfNecessary(string);
        if (500 == response.getStatusCode() || 401 == response.getStatusCode()) {
            throw new FacebookNetworkException("Facebook request failed", response.getStatusCode());
        }
        return string;
    }

    protected void throwFacebookResponseStatusExceptionIfNecessary(String string) {
        this.throwLegacyFacebookResponseStatusExceptionIfNecessary(string);
        this.throwBatchFacebookResponseStatusExceptionIfNecessary(string);
        try {
            if (!string.startsWith("{")) {
                return;
            }
            JsonObject jsonObject = new JsonObject(string);
            if (jsonObject == null || !jsonObject.has("error")) {
                return;
            }
            JsonObject jsonObject2 = jsonObject.getJsonObject("error");
            throw this.graphFacebookExceptionMapper.exceptionForTypeAndMessage(null, jsonObject2.getString(ERROR_TYPE_ATTRIBUTE_NAME), jsonObject2.getString(ERROR_MESSAGE_ATTRIBUTE_NAME));
        }
        catch (JsonException jsonException) {
            throw new FacebookJsonMappingException("Unable to process the Facebook API response", jsonException);
        }
    }

    protected void throwBatchFacebookResponseStatusExceptionIfNecessary(String string) {
        try {
            if (!string.startsWith("{")) {
                return;
            }
            JsonObject jsonObject = null;
            try {
                jsonObject = new JsonObject(string);
            }
            catch (JsonException jsonException) {
                // empty catch block
            }
            if (jsonObject == null || !jsonObject.has("error") || !jsonObject.has(BATCH_ERROR_DESCRIPTION_ATTRIBUTE_NAME)) {
                return;
            }
            throw this.legacyFacebookExceptionMapper.exceptionForTypeAndMessage(jsonObject.getInt("error"), null, jsonObject.getString(BATCH_ERROR_DESCRIPTION_ATTRIBUTE_NAME));
        }
        catch (JsonException jsonException) {
            throw new FacebookJsonMappingException("Unable to process the Facebook API response", jsonException);
        }
    }

    protected FacebookExceptionMapper createGraphFacebookExceptionMapper() {
        return new DefaultGraphFacebookExceptionMapper();
    }

    protected String toParameterString(Parameter ... parameterArray) {
        if (!StringUtils.isBlank(this.accessToken)) {
            parameterArray = this.parametersWithAdditionalParameter(Parameter.with("access_token", this.accessToken), parameterArray);
        }
        parameterArray = this.parametersWithAdditionalParameter(Parameter.with(FORMAT_PARAM_NAME, "json"), parameterArray);
        StringBuilder stringBuilder = new StringBuilder();
        boolean bl = true;
        for (Parameter parameter : parameterArray) {
            if (bl) {
                bl = false;
            } else {
                stringBuilder.append("&");
            }
            stringBuilder.append(StringUtils.urlEncode(parameter.name));
            stringBuilder.append("=");
            stringBuilder.append(this.urlEncodedValueForParameterName(parameter.name, parameter.value));
        }
        return stringBuilder.toString();
    }

    @Override
    protected String createEndpointForApiCall(String string, boolean bl) {
        StringUtils.trimToEmpty(string).toLowerCase();
        while (string.startsWith("/")) {
            string = string.substring(1);
        }
        String string2 = this.getFacebookGraphEndpointUrl();
        if (this.readOnlyApiCalls.contains(string)) {
            string2 = this.getFacebookReadOnlyEndpointUrl();
        } else if (bl && string.endsWith("/videos")) {
            string2 = this.getFacebookGraphVideoEndpointUrl();
        }
        return String.format("%s/%s", string2, string);
    }

    protected String getFacebookGraphEndpointUrl() {
        return FACEBOOK_GRAPH_ENDPOINT_URL;
    }

    protected String getFacebookGraphVideoEndpointUrl() {
        return FACEBOOK_GRAPH_VIDEO_ENDPOINT_URL;
    }

    @Override
    protected String getFacebookReadOnlyEndpointUrl() {
        return FACEBOOK_READ_ONLY_ENDPOINT_URL;
    }

    protected static class DefaultGraphFacebookExceptionMapper
    implements FacebookExceptionMapper {
        protected DefaultGraphFacebookExceptionMapper() {
        }

        public FacebookException exceptionForTypeAndMessage(Integer n, String string, String string2) {
            if ("OAuthException".equals(string) || "OAuthAccessTokenException".equals(string)) {
                return new FacebookOAuthException(string, string2);
            }
            if ("QueryParseException".equals(string)) {
                return new FacebookQueryParseException(string, string2);
            }
            return new FacebookGraphException(string, string2);
        }
    }

    protected static interface Requestor {
        public WebRequestor.Response makeRequest() throws IOException;
    }
}

