/*
 * Decompiled with CFR 0.152.
 */
package com.restfb;

import com.restfb.Facebook;
import com.restfb.JsonMapper;
import com.restfb.exception.FacebookJsonMappingException;
import com.restfb.json.JsonArray;
import com.restfb.json.JsonException;
import com.restfb.json.JsonObject;
import com.restfb.types.Post;
import com.restfb.util.ReflectionUtils;
import com.restfb.util.StringUtils;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DefaultJsonMapper
implements JsonMapper {
    protected JsonMappingErrorHandler jsonMappingErrorHandler;
    private static final Logger logger = Logger.getLogger(DefaultJsonMapper.class.getName());

    public DefaultJsonMapper() {
        this(new JsonMappingErrorHandler(){

            @Override
            public boolean handleMappingError(String string, Class<?> clazz, Exception exception) {
                return false;
            }
        });
    }

    public DefaultJsonMapper(JsonMappingErrorHandler jsonMappingErrorHandler) {
        if (jsonMappingErrorHandler == null) {
            throw new IllegalArgumentException("The jsonMappingErrorHandler parameter cannot be null.");
        }
        this.jsonMappingErrorHandler = jsonMappingErrorHandler;
    }

    @Override
    public <T> List<T> toJavaList(String string, Class<T> clazz) {
        int n;
        String[] stringArray;
        Object object;
        if (clazz == null) {
            throw new FacebookJsonMappingException("You must specify the Java type to map to.");
        }
        if (StringUtils.isBlank(string = StringUtils.trimToEmpty(string))) {
            if (this.jsonMappingErrorHandler.handleMappingError(string, clazz, null)) {
                return null;
            }
            throw new FacebookJsonMappingException("JSON is an empty string - can't map it.");
        }
        if (string.startsWith("{")) {
            if (this.isEmptyObject(string)) {
                if (logger.isLoggable(Level.FINER)) {
                    logger.finer("Encountered {} when we should've seen []. Mapping the {} as an empty list and moving on...");
                }
                return new ArrayList();
            }
            try {
                object = new JsonObject(string);
                stringArray = JsonObject.getNames((JsonObject)object);
                if (stringArray != null) {
                    n = stringArray.length == 1 && "data".equals(stringArray[0]) ? 1 : 0;
                    Object object2 = ((JsonObject)object).get("data");
                    if (n == 0 && !(object2 instanceof JsonArray)) {
                        if (this.jsonMappingErrorHandler.handleMappingError(string, clazz, null)) {
                            return null;
                        }
                        throw new FacebookJsonMappingException("JSON is an object but is being mapped as a list instead. Offending JSON is '" + string + "'.");
                    }
                    string = object2.toString();
                }
            }
            catch (JsonException jsonException) {
                if (this.jsonMappingErrorHandler.handleMappingError(string, clazz, jsonException)) {
                    return null;
                }
                throw new FacebookJsonMappingException("Unable to convert Facebook response JSON to a list of " + clazz.getName() + " instances.  Offending JSON is " + string, jsonException);
            }
        }
        try {
            object = new ArrayList();
            stringArray = new JsonArray(string);
            for (n = 0; n < stringArray.length(); ++n) {
                object.add(this.toJavaObject(stringArray.get(n).toString(), clazz));
            }
            return Collections.unmodifiableList(object);
        }
        catch (FacebookJsonMappingException facebookJsonMappingException) {
            throw facebookJsonMappingException;
        }
        catch (Exception exception) {
            if (this.jsonMappingErrorHandler.handleMappingError(string, clazz, exception)) {
                return null;
            }
            throw new FacebookJsonMappingException("Unable to convert Facebook response JSON to a list of " + clazz.getName() + " instances", exception);
        }
    }

    @Override
    public <T> T toJavaObject(String string, Class<T> clazz) {
        if (StringUtils.isBlank(string)) {
            if (this.jsonMappingErrorHandler.handleMappingError(string, clazz, null)) {
                return null;
            }
            throw new FacebookJsonMappingException("JSON is an empty string - can't map it.");
        }
        if (string.startsWith("[")) {
            if (this.jsonMappingErrorHandler.handleMappingError(string, clazz, null)) {
                return null;
            }
            throw new FacebookJsonMappingException("JSON is an array but is being mapped as an object - you should map it as a List instead. Offending JSON is '" + string + "'.");
        }
        try {
            if (clazz.equals(JsonObject.class)) {
                return (T)new JsonObject(string);
            }
            List<ReflectionUtils.FieldWithAnnotation<Facebook>> list = ReflectionUtils.findFieldsWithAnnotation(clazz, Facebook.class);
            Set<String> set = this.facebookFieldNamesWithMultipleMappings(list);
            if (list.size() == 0) {
                if (this.isEmptyObject(string)) {
                    return this.createInstance(clazz);
                }
                return this.toPrimitiveJavaType(string, clazz);
            }
            if ("null".equals(string)) {
                return null;
            }
            if ("false".equals(string)) {
                if (logger.isLoggable(Level.FINE)) {
                    logger.fine("Encountered 'false' from Facebook when trying to map to " + clazz.getSimpleName() + " - mapping null instead.");
                }
                return null;
            }
            JsonObject jsonObject = new JsonObject(string);
            T t = this.createInstance(clazz);
            if (t instanceof JsonObject) {
                return (T)jsonObject;
            }
            for (ReflectionUtils.FieldWithAnnotation<Facebook> fieldWithAnnotation : list) {
                String string2 = this.getFacebookFieldName(fieldWithAnnotation);
                if (!jsonObject.has(string2)) {
                    if (!logger.isLoggable(Level.FINER)) continue;
                    logger.finer("No JSON value present for '" + string2 + "', skipping. JSON is '" + string + "'.");
                    continue;
                }
                fieldWithAnnotation.getField().setAccessible(true);
                if (set.contains(string2)) {
                    try {
                        fieldWithAnnotation.getField().set(t, this.toJavaType(fieldWithAnnotation, jsonObject, string2));
                    }
                    catch (FacebookJsonMappingException facebookJsonMappingException) {
                        this.logMultipleMappingFailedForField(string2, fieldWithAnnotation, string);
                    }
                    catch (JsonException jsonException) {
                        this.logMultipleMappingFailedForField(string2, fieldWithAnnotation, string);
                    }
                    continue;
                }
                try {
                    fieldWithAnnotation.getField().set(t, this.toJavaType(fieldWithAnnotation, jsonObject, string2));
                }
                catch (Exception exception) {
                    if (this.jsonMappingErrorHandler.handleMappingError(string, clazz, exception)) continue;
                    throw exception;
                }
            }
            return t;
        }
        catch (FacebookJsonMappingException facebookJsonMappingException) {
            throw facebookJsonMappingException;
        }
        catch (Exception exception) {
            if (this.jsonMappingErrorHandler.handleMappingError(string, clazz, exception)) {
                return null;
            }
            throw new FacebookJsonMappingException("Unable to map JSON to Java. Offending JSON is '" + string + "'.", exception);
        }
    }

    protected void logMultipleMappingFailedForField(String string, ReflectionUtils.FieldWithAnnotation<Facebook> fieldWithAnnotation, String string2) {
        if (!logger.isLoggable(Level.FINER)) {
            return;
        }
        Field field = fieldWithAnnotation.getField();
        if (logger.isLoggable(Level.FINER)) {
            logger.finer("Could not map '" + string + "' to " + field.getDeclaringClass().getSimpleName() + "." + field.getName() + ", but continuing on because '" + string + "' is mapped to multiple fields in " + field.getDeclaringClass().getSimpleName() + ". JSON is " + string2);
        }
    }

    protected String getFacebookFieldName(ReflectionUtils.FieldWithAnnotation<Facebook> fieldWithAnnotation) {
        String string = fieldWithAnnotation.getAnnotation().value();
        Field field = fieldWithAnnotation.getField();
        if (StringUtils.isBlank(string)) {
            if (logger.isLoggable(Level.FINEST)) {
                logger.finest("No explicit Facebook field name found for " + field + ", so defaulting to the field name itself (" + field.getName() + ")");
            }
            string = field.getName();
        }
        return string;
    }

    protected Set<String> facebookFieldNamesWithMultipleMappings(List<ReflectionUtils.FieldWithAnnotation<Facebook>> list) {
        HashMap<String, Integer> hashMap = new HashMap<String, Integer>();
        HashSet hashSet = new HashSet();
        for (ReflectionUtils.FieldWithAnnotation<Facebook> object : list) {
            String string = this.getFacebookFieldName(object);
            int n = hashMap.containsKey(string) ? (Integer)hashMap.get(string) : 0;
            hashMap.put(string, n + 1);
        }
        for (Map.Entry entry : hashMap.entrySet()) {
            if ((Integer)entry.getValue() <= 1) continue;
            hashSet.add(entry.getKey());
        }
        return Collections.unmodifiableSet(hashSet);
    }

    @Override
    public String toJson(Object object) {
        return this.toJsonInternal(object, false).toString();
    }

    @Override
    public String toJson(Object object, boolean bl) {
        return this.toJsonInternal(object, bl).toString();
    }

    protected Object toJsonInternal(Object object, boolean bl) {
        if (object == null) {
            return JsonObject.NULL;
        }
        if (object instanceof List) {
            JsonArray jsonArray = new JsonArray();
            for (Object e : (List)object) {
                jsonArray.put(this.toJsonInternal(e, bl));
            }
            return jsonArray;
        }
        if (object instanceof Map) {
            JsonObject jsonObject = new JsonObject();
            for (Map.Entry entry : ((Map)object).entrySet()) {
                if (!(entry.getKey() instanceof String)) {
                    throw new FacebookJsonMappingException("Your Map keys must be of type " + String.class + " in order to be converted to JSON.  Offending map is " + object);
                }
                try {
                    jsonObject.put((String)entry.getKey(), this.toJsonInternal(entry.getValue(), bl));
                }
                catch (JsonException jsonException) {
                    throw new FacebookJsonMappingException("Unable to process value '" + entry.getValue() + "' for key '" + entry.getKey() + "' in Map " + object, jsonException);
                }
            }
            return jsonObject;
        }
        if (ReflectionUtils.isPrimitive(object)) {
            return object;
        }
        if (object instanceof BigInteger) {
            return ((BigInteger)object).longValue();
        }
        if (object instanceof BigDecimal) {
            return ((BigDecimal)object).doubleValue();
        }
        List<ReflectionUtils.FieldWithAnnotation<Facebook>> list = ReflectionUtils.findFieldsWithAnnotation(object.getClass(), Facebook.class);
        JsonObject jsonObject = new JsonObject();
        Set<String> set = this.facebookFieldNamesWithMultipleMappings(list);
        if (set.size() > 0) {
            throw new FacebookJsonMappingException("Unable to convert to JSON because multiple @" + Facebook.class.getSimpleName() + " annotations for the same name are present: " + set);
        }
        for (ReflectionUtils.FieldWithAnnotation<Facebook> fieldWithAnnotation : list) {
            String string = this.getFacebookFieldName(fieldWithAnnotation);
            fieldWithAnnotation.getField().setAccessible(true);
            try {
                Object object2 = fieldWithAnnotation.getField().get(object);
                if (bl && object2 == null) continue;
                jsonObject.put(string, this.toJsonInternal(object2, bl));
            }
            catch (Exception exception) {
                throw new FacebookJsonMappingException("Unable to process field '" + string + "' for " + object.getClass(), exception);
            }
        }
        return jsonObject;
    }

    protected <T> T toPrimitiveJavaType(String string, Class<T> clazz) {
        if (String.class.equals(clazz)) {
            if (string.length() > 1 && string.startsWith("\"") && string.endsWith("\"")) {
                string = string.replaceFirst("\"", "");
                string = string.substring(0, string.length() - 1);
            }
            return (T)string;
        }
        if (Integer.class.equals(clazz) || Integer.TYPE.equals(clazz)) {
            return (T)new Integer(string);
        }
        if (Boolean.class.equals(clazz) || Boolean.TYPE.equals(clazz)) {
            return (T)new Boolean(string);
        }
        if (Long.class.equals(clazz) || Long.TYPE.equals(clazz)) {
            return (T)new Long(string);
        }
        if (Double.class.equals(clazz) || Double.TYPE.equals(clazz)) {
            return (T)new Double(string);
        }
        if (Float.class.equals(clazz) || Float.TYPE.equals(clazz)) {
            return (T)new Float(string);
        }
        if (BigInteger.class.equals(clazz)) {
            return (T)new BigInteger(string);
        }
        if (BigDecimal.class.equals(clazz)) {
            return (T)new BigDecimal(string);
        }
        if (this.jsonMappingErrorHandler.handleMappingError(string, clazz, null)) {
            return null;
        }
        throw new FacebookJsonMappingException("Don't know how to map JSON to " + clazz + ". Are you sure you're mapping to the right class? " + "Offending JSON is '" + string + "'.");
    }

    protected Object toJavaType(ReflectionUtils.FieldWithAnnotation<Facebook> fieldWithAnnotation, JsonObject jsonObject, String string) {
        Class<?> clazz = fieldWithAnnotation.getField().getType();
        Object object = jsonObject.get(string);
        if (JsonObject.NULL.equals(object)) {
            return null;
        }
        if (String.class.equals(clazz)) {
            if (object instanceof JsonArray && ((JsonArray)object).length() == 0) {
                if (logger.isLoggable(Level.FINER)) {
                    logger.finer("Coercing an empty JSON array to an empty string for " + fieldWithAnnotation);
                }
                return "";
            }
            return object.toString();
        }
        if (Integer.class.equals(clazz) || Integer.TYPE.equals(clazz)) {
            return new Integer(jsonObject.getInt(string));
        }
        if (Boolean.class.equals(clazz) || Boolean.TYPE.equals(clazz)) {
            return new Boolean(jsonObject.getBoolean(string));
        }
        if (Long.class.equals(clazz) || Long.TYPE.equals(clazz)) {
            return new Long(jsonObject.getLong(string));
        }
        if (Double.class.equals(clazz) || Double.TYPE.equals(clazz)) {
            return new Double(jsonObject.getDouble(string));
        }
        if (Float.class.equals(clazz) || Float.TYPE.equals(clazz)) {
            return Float.valueOf(new BigDecimal(jsonObject.getString(string)).floatValue());
        }
        if (BigInteger.class.equals(clazz)) {
            return new BigInteger(jsonObject.getString(string));
        }
        if (BigDecimal.class.equals(clazz)) {
            return new BigDecimal(jsonObject.getString(string));
        }
        if (List.class.equals(clazz)) {
            return this.toJavaList(object.toString(), ReflectionUtils.getFirstParameterizedTypeArgument(fieldWithAnnotation.getField()));
        }
        String string2 = object.toString();
        if (Post.Comments.class.isAssignableFrom(clazz) && object instanceof JsonArray) {
            if (logger.isLoggable(Level.FINE)) {
                logger.fine("Encountered comment array '" + string2 + "' but expected a " + Post.Comments.class.getSimpleName() + " object instead.  Working around that " + "by coercing into an empty " + Post.Comments.class.getSimpleName() + " instance...");
            }
            JsonObject jsonObject2 = new JsonObject();
            jsonObject2.put("count", 0);
            jsonObject2.put("data", new JsonArray());
            string2 = jsonObject2.toString();
        }
        return this.toJavaObject(string2, clazz);
    }

    protected <T> T createInstance(Class<T> clazz) {
        String string = "Unable to create an instance of " + clazz + ". Please make sure that if it's a nested class, is marked 'static'. " + "It should have a no-argument constructor.";
        try {
            Constructor<T> constructor = clazz.getDeclaredConstructor(new Class[0]);
            if (constructor == null) {
                throw new FacebookJsonMappingException("Unable to find a default constructor for " + clazz);
            }
            constructor.setAccessible(true);
            return constructor.newInstance(new Object[0]);
        }
        catch (Exception exception) {
            throw new FacebookJsonMappingException(string, exception);
        }
    }

    protected boolean isEmptyObject(String string) {
        return "{}".equals(string);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static interface JsonMappingErrorHandler {
        public boolean handleMappingError(String var1, Class<?> var2, Exception var3);
    }
}

