/*
 * Decompiled with CFR 0.152.
 */
package com.restfb;

import com.restfb.DefaultJsonMapper;
import com.restfb.JsonMapper;
import com.restfb.util.StringUtils;
import java.text.SimpleDateFormat;
import java.util.Date;

public final class Parameter {
    public final String name;
    public final String value;

    private Parameter(String string, Object object, JsonMapper jsonMapper) {
        if (StringUtils.isBlank(string) || object == null) {
            throw new IllegalArgumentException(Parameter.class + " instances must have a non-blank name and non-null value.");
        }
        if (jsonMapper == null) {
            throw new IllegalArgumentException("Provided " + JsonMapper.class + " must not be null.");
        }
        this.name = StringUtils.trimToEmpty(string).toLowerCase();
        this.value = object instanceof Date ? new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ssZ").format(object) : jsonMapper.toJson(object);
    }

    public static Parameter with(String string, Object object) {
        return Parameter.with(string, object, new DefaultJsonMapper());
    }

    public static Parameter with(String string, Object object, JsonMapper jsonMapper) {
        return new Parameter(string, object, jsonMapper);
    }

    public boolean equals(Object object) {
        if (object == null) {
            return false;
        }
        if (!this.getClass().equals(object.getClass())) {
            return false;
        }
        Parameter parameter = (Parameter)object;
        if (this.name != parameter.name && !this.name.equals(parameter.name)) {
            return false;
        }
        return this.value == parameter.value || this.value.equals(parameter.value);
    }

    public int hashCode() {
        int n = 7;
        n = 37 * n + this.name.hashCode();
        n = 41 * n + this.value.hashCode();
        return n;
    }

    public String toString() {
        return String.format("Parameter[%s=%s]", this.name, this.value);
    }
}

