/*
 * Decompiled with CFR 0.152.
 */
package com.restfb.batch;

import com.restfb.Facebook;
import com.restfb.Parameter;
import com.restfb.batch.BatchHeader;
import com.restfb.util.ReflectionUtils;
import com.restfb.util.StringUtils;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BatchRequest {
    @Facebook
    private String method;
    @Facebook(value="relative_url")
    private String relativeUrl;
    @Facebook
    private String body;
    @Facebook(value="attached_files")
    private String attachedFiles;
    @Facebook(value="depends_on")
    private String dependsOn;
    @Facebook
    private String name;
    @Facebook(value="omit_response_on_success")
    private boolean omitResponseOnSuccess;
    @Facebook
    private List<BatchHeader> headers = new ArrayList<BatchHeader>();

    protected BatchRequest(String string, List<Parameter> list, String string2, List<BatchHeader> list2, List<Parameter> list3, String string3, String string4, String string5, boolean bl) {
        if (StringUtils.isBlank(string)) {
            throw new IllegalArgumentException("The 'relativeUrl' parameter is required.");
        }
        this.relativeUrl = string;
        this.method = string2;
        this.headers = list2;
        this.attachedFiles = string3;
        this.dependsOn = string4;
        this.name = string5;
        this.omitResponseOnSuccess = bl;
        if (list.size() > 0) {
            this.relativeUrl = String.format(this.relativeUrl.indexOf("?") == -1 ? "%s?%s" : "%s&%s", this.relativeUrl, this.generateParameterString(list));
        }
        this.body = this.generateParameterString(list3);
    }

    protected String generateParameterString(List<Parameter> list) {
        if (list == null) {
            return "";
        }
        StringBuilder stringBuilder = new StringBuilder();
        boolean bl = true;
        for (Parameter parameter : list) {
            if (bl) {
                bl = false;
            } else {
                stringBuilder.append("&");
            }
            stringBuilder.append(StringUtils.urlEncode(parameter.name));
            stringBuilder.append("=");
            stringBuilder.append(StringUtils.urlEncode(parameter.value));
        }
        return stringBuilder.toString();
    }

    public int hashCode() {
        return ReflectionUtils.hashCode(this);
    }

    public boolean equals(Object object) {
        return ReflectionUtils.equals(this, object);
    }

    public String toString() {
        return ReflectionUtils.toString(this);
    }

    public String getMethod() {
        return this.method;
    }

    public String getRelativeUrl() {
        return this.relativeUrl;
    }

    public String getBody() {
        return this.body;
    }

    public String getAttachedFiles() {
        return this.attachedFiles;
    }

    public String getName() {
        return this.name;
    }

    public String getDependsOn() {
        return this.dependsOn;
    }

    public boolean isOmitResponseOnSuccess() {
        return this.omitResponseOnSuccess;
    }

    public List<BatchHeader> getHeaders() {
        return Collections.unmodifiableList(this.headers);
    }

    public static class BatchRequestBuilder {
        private String method = "GET";
        private String relativeUrl;
        private List<Parameter> parameters = new ArrayList<Parameter>();
        private List<BatchHeader> headers = new ArrayList<BatchHeader>();
        private List<Parameter> bodyParameters = new ArrayList<Parameter>();
        private String attachedFiles;
        private String dependsOn;
        private String name;
        private boolean omitResponseOnSuccess;

        public BatchRequestBuilder(String string) {
            this.relativeUrl = string;
        }

        public BatchRequestBuilder method(String string) {
            this.method = string;
            return this;
        }

        public BatchRequestBuilder name(String string) {
            this.name = string;
            return this;
        }

        public BatchRequestBuilder headers(BatchHeader ... batchHeaderArray) {
            this.headers.clear();
            this.headers.addAll(Arrays.asList(batchHeaderArray));
            return this;
        }

        public BatchRequestBuilder body(Parameter ... parameterArray) {
            this.bodyParameters.clear();
            this.bodyParameters.addAll(Arrays.asList(parameterArray));
            return this;
        }

        public BatchRequestBuilder attachedFiles(String string) {
            this.attachedFiles = string;
            return this;
        }

        public BatchRequestBuilder dependsOn(String string) {
            this.dependsOn = string;
            return this;
        }

        public BatchRequestBuilder omitResponseOnSuccess(boolean bl) {
            this.omitResponseOnSuccess = bl;
            return this;
        }

        public BatchRequestBuilder parameters(Parameter ... parameterArray) {
            this.parameters.clear();
            this.parameters.addAll(Arrays.asList(parameterArray));
            return this;
        }

        public BatchRequest build() {
            return new BatchRequest(this.relativeUrl, this.parameters, this.method, this.headers, this.bodyParameters, this.attachedFiles, this.dependsOn, this.name, this.omitResponseOnSuccess);
        }
    }
}

