/*
 * Decompiled with CFR 0.152.
 */
package com.restfb.json;

import com.restfb.json.JsonArray;
import com.restfb.json.JsonException;
import com.restfb.json.JsonString;
import com.restfb.json.JsonTokener;
import java.io.IOException;
import java.io.Writer;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.TreeSet;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JsonObject {
    private Map<Object, Object> map;
    public static final Object NULL = new Null();

    public JsonObject() {
        this.map = new HashMap<Object, Object>();
    }

    public JsonObject(JsonObject jsonObject, String[] stringArray) {
        this();
        for (int i = 0; i < stringArray.length; ++i) {
            this.putOnce(stringArray[i], jsonObject.opt(stringArray[i]));
        }
    }

    public JsonObject(JsonTokener jsonTokener) {
        this();
        if (jsonTokener.nextClean() != '{') {
            throw jsonTokener.syntaxError("A JsonObject text must begin with '{'");
        }
        block8: while (true) {
            char c = jsonTokener.nextClean();
            switch (c) {
                case '\u0000': {
                    throw jsonTokener.syntaxError("A JsonObject text must end with '}'");
                }
                case '}': {
                    return;
                }
            }
            jsonTokener.back();
            String string = jsonTokener.nextValue().toString();
            c = jsonTokener.nextClean();
            if (c == '=') {
                if (jsonTokener.next() != '>') {
                    jsonTokener.back();
                }
            } else if (c != ':') {
                throw jsonTokener.syntaxError("Expected a ':' after a key");
            }
            this.putOnce(string, jsonTokener.nextValue());
            switch (jsonTokener.nextClean()) {
                case ',': 
                case ';': {
                    if (jsonTokener.nextClean() == '}') {
                        return;
                    }
                    jsonTokener.back();
                    continue block8;
                }
                case '}': {
                    return;
                }
            }
            break;
        }
        throw jsonTokener.syntaxError("Expected a ',' or '}'");
    }

    public JsonObject(Map<Object, Object> hashMap) {
        this.map = hashMap == null ? new HashMap() : hashMap;
    }

    public JsonObject(Map<Object, Object> map, boolean bl) {
        this.map = new HashMap<Object, Object>();
        if (map != null) {
            for (Map.Entry<Object, Object> entry : map.entrySet()) {
                if (JsonObject.isStandardProperty(entry.getValue().getClass())) {
                    this.map.put(entry.getKey(), entry.getValue());
                    continue;
                }
                this.map.put(entry.getKey(), new JsonObject(entry.getValue(), bl));
            }
        }
    }

    public JsonObject(Object object) {
        this();
        this.populateInternalMap(object, false);
    }

    public JsonObject(Object object, boolean bl) {
        this();
        this.populateInternalMap(object, bl);
    }

    private void populateInternalMap(Object object, boolean bl) {
        Class<?> clazz = object.getClass();
        if (clazz.getClassLoader() == null) {
            bl = false;
        }
        Method[] methodArray = bl ? clazz.getMethods() : clazz.getDeclaredMethods();
        for (int i = 0; i < methodArray.length; ++i) {
            try {
                Method method = methodArray[i];
                if (!Modifier.isPublic(method.getModifiers())) continue;
                String string = method.getName();
                String string2 = "";
                if (string.startsWith("get")) {
                    string2 = string.substring(3);
                } else if (string.startsWith("is")) {
                    string2 = string.substring(2);
                }
                if (string2.length() <= 0 || !Character.isUpperCase(string2.charAt(0)) || method.getParameterTypes().length != 0) continue;
                if (string2.length() == 1) {
                    string2 = string2.toLowerCase();
                } else if (!Character.isUpperCase(string2.charAt(1))) {
                    string2 = string2.substring(0, 1).toLowerCase() + string2.substring(1);
                }
                Object object2 = method.invoke(object, (Object[])null);
                if (object2 == null) {
                    this.map.put(string2, NULL);
                    continue;
                }
                if (object2.getClass().isArray()) {
                    this.map.put(string2, new JsonArray(object2, bl));
                    continue;
                }
                if (object2 instanceof Collection) {
                    this.map.put(string2, new JsonArray((Collection)object2, bl));
                    continue;
                }
                if (object2 instanceof Map) {
                    this.map.put(string2, new JsonObject((Object)((Map)object2), bl));
                    continue;
                }
                if (JsonObject.isStandardProperty(object2.getClass())) {
                    this.map.put(string2, object2);
                    continue;
                }
                if (object2.getClass().getPackage().getName().startsWith("java") || object2.getClass().getClassLoader() == null) {
                    this.map.put(string2, object2.toString());
                    continue;
                }
                this.map.put(string2, new JsonObject(object2, bl));
                continue;
            }
            catch (Exception exception) {
                throw new RuntimeException(exception);
            }
        }
    }

    static boolean isStandardProperty(Class<?> clazz) {
        return clazz.isPrimitive() || clazz.isAssignableFrom(Byte.class) || clazz.isAssignableFrom(Short.class) || clazz.isAssignableFrom(Integer.class) || clazz.isAssignableFrom(Long.class) || clazz.isAssignableFrom(Float.class) || clazz.isAssignableFrom(Double.class) || clazz.isAssignableFrom(Character.class) || clazz.isAssignableFrom(String.class) || clazz.isAssignableFrom(Boolean.class);
    }

    public JsonObject(Object object, String[] stringArray) {
        this();
        Class<?> clazz = object.getClass();
        for (int i = 0; i < stringArray.length; ++i) {
            String string = stringArray[i];
            try {
                this.putOpt(string, clazz.getField(string).get(object));
                continue;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public JsonObject(String string) {
        this(new JsonTokener(string));
    }

    public JsonObject accumulate(String string, Object object) {
        JsonObject.testValidity(object);
        Object object2 = this.opt(string);
        if (object2 == null) {
            this.put(string, object instanceof JsonArray ? new JsonArray().put(object) : object);
        } else if (object2 instanceof JsonArray) {
            ((JsonArray)object2).put(object);
        } else {
            this.put(string, new JsonArray().put(object2).put(object));
        }
        return this;
    }

    public JsonObject append(String string, Object object) {
        JsonObject.testValidity(object);
        Object object2 = this.opt(string);
        if (object2 == null) {
            this.put(string, new JsonArray().put(object));
        } else if (object2 instanceof JsonArray) {
            this.put(string, ((JsonArray)object2).put(object));
        } else {
            throw new JsonException("JsonObject[" + string + "] is not a JsonArray.");
        }
        return this;
    }

    public static String doubleToString(double d) {
        if (Double.isInfinite(d) || Double.isNaN(d)) {
            return "null";
        }
        String string = Double.toString(d);
        if (string.indexOf(46) > 0 && string.indexOf(101) < 0 && string.indexOf(69) < 0) {
            while (string.endsWith("0")) {
                string = string.substring(0, string.length() - 1);
            }
            if (string.endsWith(".")) {
                string = string.substring(0, string.length() - 1);
            }
        }
        return string;
    }

    public Object get(String string) {
        Object object = this.opt(string);
        if (object == null) {
            throw new JsonException("JsonObject[" + JsonObject.quote(string) + "] not found.");
        }
        return object;
    }

    public boolean getBoolean(String string) {
        Object object = this.get(string);
        if (object.equals(Boolean.FALSE) || object instanceof String && ((String)object).equalsIgnoreCase("false")) {
            return false;
        }
        if (object.equals(Boolean.TRUE) || object instanceof String && ((String)object).equalsIgnoreCase("true")) {
            return true;
        }
        throw new JsonException("JsonObject[" + JsonObject.quote(string) + "] is not a Boolean.");
    }

    public double getDouble(String string) {
        Object object = this.get(string);
        try {
            return object instanceof Number ? ((Number)object).doubleValue() : Double.valueOf((String)object).doubleValue();
        }
        catch (Exception exception) {
            throw new JsonException("JsonObject[" + JsonObject.quote(string) + "] is not a number.");
        }
    }

    public int getInt(String string) {
        Object object = this.get(string);
        return object instanceof Number ? ((Number)object).intValue() : (int)this.getDouble(string);
    }

    public JsonArray getJsonArray(String string) {
        Object object = this.get(string);
        if (object instanceof JsonArray) {
            return (JsonArray)object;
        }
        throw new JsonException("JsonObject[" + JsonObject.quote(string) + "] is not a JsonArray.");
    }

    public JsonObject getJsonObject(String string) {
        Object object = this.get(string);
        if (object instanceof JsonObject) {
            return (JsonObject)object;
        }
        throw new JsonException("JsonObject[" + JsonObject.quote(string) + "] is not a JsonObject.");
    }

    public long getLong(String string) {
        Object object = this.get(string);
        try {
            return object instanceof Number ? ((Number)object).longValue() : Long.parseLong((String)object);
        }
        catch (Exception exception) {
            throw new JsonException("JSONObject[" + JsonObject.quote(string) + "] is not a long.");
        }
    }

    public static String[] getNames(JsonObject jsonObject) {
        int n = jsonObject.length();
        if (n == 0) {
            return null;
        }
        Iterator<?> iterator = jsonObject.keys();
        String[] stringArray = new String[n];
        int n2 = 0;
        while (iterator.hasNext()) {
            stringArray[n2] = (String)iterator.next();
            ++n2;
        }
        return stringArray;
    }

    public static String[] getNames(Object object) {
        if (object == null) {
            return null;
        }
        Class<?> clazz = object.getClass();
        Field[] fieldArray = clazz.getFields();
        int n = fieldArray.length;
        if (n == 0) {
            return null;
        }
        String[] stringArray = new String[n];
        for (int i = 0; i < n; ++i) {
            stringArray[i] = fieldArray[i].getName();
        }
        return stringArray;
    }

    public String getString(String string) {
        return this.get(string).toString();
    }

    public boolean has(String string) {
        return this.map.containsKey(string);
    }

    public boolean isNull(String string) {
        return NULL.equals(this.opt(string));
    }

    public Iterator<?> keys() {
        return this.map.keySet().iterator();
    }

    public int length() {
        return this.map.size();
    }

    public JsonArray names() {
        JsonArray jsonArray = new JsonArray();
        Iterator<?> iterator = this.keys();
        while (iterator.hasNext()) {
            jsonArray.put(iterator.next());
        }
        return jsonArray.length() == 0 ? null : jsonArray;
    }

    public static String numberToString(Number number) {
        if (number == null) {
            throw new JsonException("Null pointer");
        }
        JsonObject.testValidity(number);
        String string = number.toString();
        if (string.indexOf(46) > 0 && string.indexOf(101) < 0 && string.indexOf(69) < 0) {
            while (string.endsWith("0")) {
                string = string.substring(0, string.length() - 1);
            }
            if (string.endsWith(".")) {
                string = string.substring(0, string.length() - 1);
            }
        }
        return string;
    }

    public Object opt(String string) {
        return string == null ? null : this.map.get(string);
    }

    public boolean optBoolean(String string) {
        return this.optBoolean(string, false);
    }

    public boolean optBoolean(String string, boolean bl) {
        try {
            return this.getBoolean(string);
        }
        catch (Exception exception) {
            return bl;
        }
    }

    public JsonObject put(String string, Collection<?> collection) {
        this.put(string, new JsonArray(collection));
        return this;
    }

    public double optDouble(String string) {
        return this.optDouble(string, Double.NaN);
    }

    public double optDouble(String string, double d) {
        try {
            Object object = this.opt(string);
            return object instanceof Number ? ((Number)object).doubleValue() : new Double((String)object).doubleValue();
        }
        catch (Exception exception) {
            return d;
        }
    }

    public int optInt(String string) {
        return this.optInt(string, 0);
    }

    public int optInt(String string, int n) {
        try {
            return this.getInt(string);
        }
        catch (Exception exception) {
            return n;
        }
    }

    public JsonArray optJsonArray(String string) {
        Object object = this.opt(string);
        return object instanceof JsonArray ? (JsonArray)object : null;
    }

    public JsonObject optJsonObject(String string) {
        Object object = this.opt(string);
        return object instanceof JsonObject ? (JsonObject)object : null;
    }

    public long optLong(String string) {
        return this.optLong(string, 0L);
    }

    public long optLong(String string, long l) {
        try {
            return this.getLong(string);
        }
        catch (Exception exception) {
            return l;
        }
    }

    public String optString(String string) {
        return this.optString(string, "");
    }

    public String optString(String string, String string2) {
        Object object = this.opt(string);
        return object != null ? object.toString() : string2;
    }

    public JsonObject put(String string, boolean bl) {
        this.put(string, bl ? Boolean.TRUE : Boolean.FALSE);
        return this;
    }

    public JsonObject put(String string, double d) {
        this.put(string, new Double(d));
        return this;
    }

    public JsonObject put(String string, int n) {
        this.put(string, new Integer(n));
        return this;
    }

    public JsonObject put(String string, long l) {
        this.put(string, new Long(l));
        return this;
    }

    public JsonObject put(String string, Map<?, ?> map) {
        this.put(string, new JsonObject(map));
        return this;
    }

    public JsonObject put(String string, Object object) {
        if (string == null) {
            throw new JsonException("Null key.");
        }
        if (object != null) {
            JsonObject.testValidity(object);
            this.map.put(string, object);
        } else {
            this.remove(string);
        }
        return this;
    }

    public JsonObject putOnce(String string, Object object) {
        if (string != null && object != null) {
            if (this.opt(string) != null) {
                throw new JsonException("Duplicate key \"" + string + "\"");
            }
            this.put(string, object);
        }
        return this;
    }

    public JsonObject putOpt(String string, Object object) {
        if (string != null && object != null) {
            this.put(string, object);
        }
        return this;
    }

    public static String quote(String string) {
        if (string == null || string.length() == 0) {
            return "\"\"";
        }
        char c = '\u0000';
        int n = string.length();
        StringBuilder stringBuilder = new StringBuilder(n + 4);
        stringBuilder.append('\"');
        block9: for (int i = 0; i < n; ++i) {
            char c2 = c;
            c = string.charAt(i);
            switch (c) {
                case '\"': 
                case '\\': {
                    stringBuilder.append('\\');
                    stringBuilder.append(c);
                    continue block9;
                }
                case '/': {
                    if (c2 == '<') {
                        stringBuilder.append('\\');
                    }
                    stringBuilder.append(c);
                    continue block9;
                }
                case '\b': {
                    stringBuilder.append("\\b");
                    continue block9;
                }
                case '\t': {
                    stringBuilder.append("\\t");
                    continue block9;
                }
                case '\n': {
                    stringBuilder.append("\\n");
                    continue block9;
                }
                case '\f': {
                    stringBuilder.append("\\f");
                    continue block9;
                }
                case '\r': {
                    stringBuilder.append("\\r");
                    continue block9;
                }
                default: {
                    if (c < ' ' || c >= '\u0080' && c < '\u00a0' || c >= '\u2000' && c < '\u2100') {
                        String string2 = "000" + Integer.toHexString(c);
                        stringBuilder.append("\\u" + string2.substring(string2.length() - 4));
                        continue block9;
                    }
                    stringBuilder.append(c);
                }
            }
        }
        stringBuilder.append('\"');
        return stringBuilder.toString();
    }

    public Object remove(String string) {
        return this.map.remove(string);
    }

    public Iterator<?> sortedKeys() {
        return new TreeSet<Object>(this.map.keySet()).iterator();
    }

    public static Object stringToValue(String string) {
        if (string.equals("")) {
            return string;
        }
        if (string.equalsIgnoreCase("true")) {
            return Boolean.TRUE;
        }
        if (string.equalsIgnoreCase("false")) {
            return Boolean.FALSE;
        }
        if (string.equalsIgnoreCase("null")) {
            return NULL;
        }
        char c = string.charAt(0);
        if (c >= '0' && c <= '9' || c == '.' || c == '-' || c == '+') {
            if (c == '0') {
                if (string.length() > 2 && (string.charAt(1) == 'x' || string.charAt(1) == 'X')) {
                    try {
                        return new Integer(Integer.parseInt(string.substring(2), 16));
                    }
                    catch (Exception exception) {
                    }
                } else {
                    try {
                        return new Integer(Integer.parseInt(string, 8));
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
            }
            try {
                if (string.indexOf(46) > -1 || string.indexOf(101) > -1 || string.indexOf(69) > -1) {
                    return Double.valueOf(string);
                }
                Long l = new Long(string);
                if (l == (long)l.intValue()) {
                    return new Integer(l.intValue());
                }
                return l;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return string;
    }

    static void testValidity(Object object) {
        if (object != null && (object instanceof Double ? ((Double)object).isInfinite() || ((Double)object).isNaN() : object instanceof Float && (((Float)object).isInfinite() || ((Float)object).isNaN()))) {
            throw new JsonException("JSON does not allow non-finite numbers.");
        }
    }

    public JsonArray toJsonArray(JsonArray jsonArray) {
        if (jsonArray == null || jsonArray.length() == 0) {
            return null;
        }
        JsonArray jsonArray2 = new JsonArray();
        for (int i = 0; i < jsonArray.length(); ++i) {
            jsonArray2.put(this.opt(jsonArray.getString(i)));
        }
        return jsonArray2;
    }

    public String toString() {
        try {
            Iterator<?> iterator = this.keys();
            StringBuilder stringBuilder = new StringBuilder("{");
            while (iterator.hasNext()) {
                if (stringBuilder.length() > 1) {
                    stringBuilder.append(',');
                }
                Object obj = iterator.next();
                stringBuilder.append(JsonObject.quote(obj.toString()));
                stringBuilder.append(':');
                stringBuilder.append(JsonObject.valueToString(this.map.get(obj)));
            }
            stringBuilder.append('}');
            return stringBuilder.toString();
        }
        catch (Exception exception) {
            return null;
        }
    }

    public String toString(int n) {
        return this.toString(n, 0);
    }

    String toString(int n, int n2) {
        int n3 = this.length();
        if (n3 == 0) {
            return "{}";
        }
        Iterator<?> iterator = this.sortedKeys();
        StringBuilder stringBuilder = new StringBuilder("{");
        int n4 = n2 + n;
        if (n3 == 1) {
            Object obj = iterator.next();
            stringBuilder.append(JsonObject.quote(obj.toString()));
            stringBuilder.append(": ");
            stringBuilder.append(JsonObject.valueToString(this.map.get(obj), n, n2));
        } else {
            int n5;
            while (iterator.hasNext()) {
                Object obj = iterator.next();
                if (stringBuilder.length() > 1) {
                    stringBuilder.append(",\n");
                } else {
                    stringBuilder.append('\n');
                }
                for (n5 = 0; n5 < n4; ++n5) {
                    stringBuilder.append(' ');
                }
                stringBuilder.append(JsonObject.quote(obj.toString()));
                stringBuilder.append(": ");
                stringBuilder.append(JsonObject.valueToString(this.map.get(obj), n, n4));
            }
            if (stringBuilder.length() > 1) {
                stringBuilder.append('\n');
                for (n5 = 0; n5 < n2; ++n5) {
                    stringBuilder.append(' ');
                }
            }
        }
        stringBuilder.append('}');
        return stringBuilder.toString();
    }

    static String valueToString(Object object) {
        if (object == null || object.equals(null)) {
            return "null";
        }
        if (object instanceof JsonString) {
            String string;
            try {
                string = ((JsonString)object).toJsonString();
            }
            catch (Exception exception) {
                throw new JsonException(exception);
            }
            if (string instanceof String) {
                return string;
            }
            throw new JsonException("Bad value from toJSONString: " + string);
        }
        if (object instanceof Number) {
            return JsonObject.numberToString((Number)object);
        }
        if (object instanceof Boolean || object instanceof JsonObject || object instanceof JsonArray) {
            return object.toString();
        }
        if (object instanceof Map) {
            return new JsonObject((Object)((Map)object)).toString();
        }
        if (object instanceof Collection) {
            return new JsonArray((Collection)object).toString();
        }
        if (object.getClass().isArray()) {
            return new JsonArray(object).toString();
        }
        return JsonObject.quote(object.toString());
    }

    static String valueToString(Object object, int n, int n2) {
        if (object == null || object.equals(null)) {
            return "null";
        }
        try {
            String string;
            if (object instanceof JsonString && (string = ((JsonString)object).toJsonString()) instanceof String) {
                return string;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (object instanceof Number) {
            return JsonObject.numberToString((Number)object);
        }
        if (object instanceof Boolean) {
            return object.toString();
        }
        if (object instanceof JsonObject) {
            return ((JsonObject)object).toString(n, n2);
        }
        if (object instanceof JsonArray) {
            return ((JsonArray)object).toString(n, n2);
        }
        if (object instanceof Map) {
            return new JsonObject((Object)((Map)object)).toString(n, n2);
        }
        if (object instanceof Collection) {
            return new JsonArray((Collection)object).toString(n, n2);
        }
        if (object.getClass().isArray()) {
            return new JsonArray(object).toString(n, n2);
        }
        return JsonObject.quote(object.toString());
    }

    public Writer write(Writer writer) {
        try {
            boolean bl = false;
            Iterator<?> iterator = this.keys();
            writer.write(123);
            while (iterator.hasNext()) {
                if (bl) {
                    writer.write(44);
                }
                Object obj = iterator.next();
                writer.write(JsonObject.quote(obj.toString()));
                writer.write(58);
                Object object = this.map.get(obj);
                if (object instanceof JsonObject) {
                    ((JsonObject)object).write(writer);
                } else if (object instanceof JsonArray) {
                    ((JsonArray)object).write(writer);
                } else {
                    writer.write(JsonObject.valueToString(object));
                }
                bl = true;
            }
            writer.write(125);
            return writer;
        }
        catch (IOException iOException) {
            throw new JsonException(iOException);
        }
    }

    private static final class Null {
        private Null() {
        }

        protected final Object clone() {
            return this;
        }

        public boolean equals(Object object) {
            return object == null || object == this;
        }

        public String toString() {
            return "null";
        }
    }
}

