/*
 * Decompiled with CFR 0.152.
 */
package com.restfb.json;

import com.restfb.json.JsonArray;
import com.restfb.json.JsonException;
import com.restfb.json.JsonObject;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;

public class JsonTokener {
    private int index;
    private Reader reader;
    private char lastChar;
    private boolean useLastChar;

    public JsonTokener(Reader reader) {
        this.reader = reader.markSupported() ? reader : new BufferedReader(reader);
        this.useLastChar = false;
        this.index = 0;
    }

    public JsonTokener(String string) {
        this(new StringReader(string));
    }

    public void back() {
        if (this.useLastChar || this.index <= 0) {
            throw new JsonException("Stepping back two steps is not supported");
        }
        --this.index;
        this.useLastChar = true;
    }

    public static int dehexchar(char c) {
        if (c >= '0' && c <= '9') {
            return c - 48;
        }
        if (c >= 'A' && c <= 'F') {
            return c - 55;
        }
        if (c >= 'a' && c <= 'f') {
            return c - 87;
        }
        return -1;
    }

    public boolean more() {
        char c = this.next();
        if (c == '\u0000') {
            return false;
        }
        this.back();
        return true;
    }

    public char next() {
        int n;
        if (this.useLastChar) {
            this.useLastChar = false;
            if (this.lastChar != '\u0000') {
                ++this.index;
            }
            return this.lastChar;
        }
        try {
            n = this.reader.read();
        }
        catch (IOException iOException) {
            throw new JsonException(iOException);
        }
        if (n <= 0) {
            this.lastChar = '\u0000';
            return '\u0000';
        }
        ++this.index;
        this.lastChar = (char)n;
        return this.lastChar;
    }

    public char next(char c) {
        char c2 = this.next();
        if (c2 != c) {
            throw this.syntaxError("Expected '" + c + "' and instead saw '" + c2 + "'");
        }
        return c2;
    }

    public String next(int n) {
        if (n == 0) {
            return "";
        }
        char[] cArray = new char[n];
        int n2 = 0;
        if (this.useLastChar) {
            this.useLastChar = false;
            cArray[0] = this.lastChar;
            n2 = 1;
        }
        try {
            int n3;
            while (n2 < n && (n3 = this.reader.read(cArray, n2, n - n2)) != -1) {
                n2 += n3;
            }
        }
        catch (IOException iOException) {
            throw new JsonException(iOException);
        }
        this.index += n2;
        if (n2 < n) {
            throw this.syntaxError("Substring bounds error");
        }
        this.lastChar = cArray[n - 1];
        return new String(cArray);
    }

    public char nextClean() {
        char c;
        while ((c = this.next()) != '\u0000' && c <= ' ') {
        }
        return c;
    }

    public String nextString(char c) {
        StringBuilder stringBuilder = new StringBuilder();
        block13: while (true) {
            char c2 = this.next();
            switch (c2) {
                case '\u0000': 
                case '\n': 
                case '\r': {
                    throw this.syntaxError("Unterminated string");
                }
                case '\\': {
                    c2 = this.next();
                    switch (c2) {
                        case 'b': {
                            stringBuilder.append('\b');
                            continue block13;
                        }
                        case 't': {
                            stringBuilder.append('\t');
                            continue block13;
                        }
                        case 'n': {
                            stringBuilder.append('\n');
                            continue block13;
                        }
                        case 'f': {
                            stringBuilder.append('\f');
                            continue block13;
                        }
                        case 'r': {
                            stringBuilder.append('\r');
                            continue block13;
                        }
                        case 'u': {
                            stringBuilder.append((char)Integer.parseInt(this.next(4), 16));
                            continue block13;
                        }
                        case '\"': 
                        case '\'': 
                        case '/': 
                        case '\\': {
                            stringBuilder.append(c2);
                            continue block13;
                        }
                    }
                    throw this.syntaxError("Illegal escape.");
                }
            }
            if (c2 == c) {
                return stringBuilder.toString();
            }
            stringBuilder.append(c2);
        }
    }

    public String nextTo(char c) {
        StringBuilder stringBuilder = new StringBuilder();
        while (true) {
            char c2;
            if ((c2 = this.next()) == c || c2 == '\u0000' || c2 == '\n' || c2 == '\r') {
                if (c2 != '\u0000') {
                    this.back();
                }
                return stringBuilder.toString().trim();
            }
            stringBuilder.append(c2);
        }
    }

    public String nextTo(String string) {
        StringBuilder stringBuilder = new StringBuilder();
        while (true) {
            char c;
            if (string.indexOf(c = this.next()) >= 0 || c == '\u0000' || c == '\n' || c == '\r') {
                if (c != '\u0000') {
                    this.back();
                }
                return stringBuilder.toString().trim();
            }
            stringBuilder.append(c);
        }
    }

    public Object nextValue() {
        char c = this.nextClean();
        switch (c) {
            case '\"': 
            case '\'': {
                return this.nextString(c);
            }
            case '{': {
                this.back();
                return new JsonObject(this);
            }
            case '(': 
            case '[': {
                this.back();
                return new JsonArray(this);
            }
        }
        StringBuilder stringBuilder = new StringBuilder();
        while (c >= ' ' && ",:]}/\\\"[{;=#".indexOf(c) < 0) {
            stringBuilder.append(c);
            c = this.next();
        }
        this.back();
        String string = stringBuilder.toString().trim();
        if (string.equals("")) {
            throw this.syntaxError("Missing value");
        }
        return JsonObject.stringToValue(string);
    }

    public char skipTo(char c) {
        char c2;
        try {
            int n = this.index;
            this.reader.mark(Integer.MAX_VALUE);
            do {
                if ((c2 = this.next()) != '\u0000') continue;
                this.reader.reset();
                this.index = n;
                return c2;
            } while (c2 != c);
        }
        catch (IOException iOException) {
            throw new JsonException(iOException);
        }
        this.back();
        return c2;
    }

    public JsonException syntaxError(String string) {
        return new JsonException(string + this.toString());
    }

    public String toString() {
        return " at character " + this.index;
    }
}

