/*
 * Decompiled with CFR 0.152.
 */
package com.restfb.types;

import com.restfb.Facebook;
import com.restfb.types.NamedFacebookType;
import com.restfb.util.DateUtils;
import com.restfb.util.ReflectionUtils;
import com.restfb.util.StringUtils;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class User
extends NamedFacebookType {
    @Facebook(value="first_name")
    private String firstName;
    @Facebook(value="middle_name")
    private String middleName;
    @Facebook(value="last_name")
    private String lastName;
    @Facebook
    private String link;
    @Facebook
    private String bio;
    @Facebook
    private String quotes;
    @Facebook
    private String about;
    @Facebook(value="relationship_status")
    private String relationshipStatus;
    @Facebook
    private String religion;
    @Facebook
    private String website;
    @Facebook
    private String birthday;
    @Facebook
    private String email;
    @Facebook
    private Double timezone;
    @Facebook
    private Boolean verified;
    @Facebook
    private String gender;
    @Facebook
    private String political;
    @Facebook
    private String locale;
    @Facebook
    private String username;
    @Facebook
    private NamedFacebookType hometown;
    @Facebook(value="hometown")
    private String hometownAsString;
    @Facebook
    private NamedFacebookType location;
    @Facebook(value="significant_other")
    private NamedFacebookType significantOther;
    @Facebook(value="updated_time")
    private String updatedTime;
    @Facebook(value="third_party_id")
    private String thirdPartyId;
    @Facebook(value="interested_in")
    private List<String> interestedIn = new ArrayList<String>();
    @Facebook(value="meeting_for")
    private List<String> meetingFor = new ArrayList<String>();
    @Facebook
    private List<Work> work = new ArrayList<Work>();
    @Facebook
    private List<Education> education = new ArrayList<Education>();
    @Facebook
    private List<Sport> sports = new ArrayList<Sport>();
    @Facebook(value="favorite_teams")
    private List<NamedFacebookType> favoriteTeams = new ArrayList<NamedFacebookType>();
    @Facebook(value="favorite_athletes")
    private List<NamedFacebookType> favoriteAthletes = new ArrayList<NamedFacebookType>();
    @Facebook
    private List<NamedFacebookType> languages = new ArrayList<NamedFacebookType>();
    private static final long serialVersionUID = 1L;

    public String getFirstName() {
        return this.firstName;
    }

    public String getMiddleName() {
        return this.middleName;
    }

    public String getLastName() {
        return this.lastName;
    }

    public String getLink() {
        return this.link;
    }

    public String getAbout() {
        return this.about;
    }

    public String getRelationshipStatus() {
        return this.relationshipStatus;
    }

    public String getBirthday() {
        return this.birthday;
    }

    public Date getBirthdayAsDate() {
        if (StringUtils.isBlank(this.getBirthday()) || this.getBirthday().split("/").length < 2) {
            return null;
        }
        return DateUtils.toDateFromShortFormat(this.birthday);
    }

    public String getReligion() {
        return this.religion;
    }

    public String getWebsite() {
        return this.website;
    }

    public String getEmail() {
        return this.email;
    }

    public String getQuotes() {
        return this.quotes;
    }

    public Double getTimezone() {
        return this.timezone;
    }

    public Boolean getVerified() {
        return this.verified;
    }

    public Date getUpdatedTime() {
        return DateUtils.toDateFromLongFormat(this.updatedTime);
    }

    public String getGender() {
        return this.gender;
    }

    public String getBio() {
        return this.bio;
    }

    public String getPolitical() {
        return this.political;
    }

    public String getLocale() {
        return this.locale;
    }

    public String getUsername() {
        return this.username;
    }

    public NamedFacebookType getHometown() {
        return this.hometown;
    }

    public String getHometownName() {
        if (this.getHometown() != null) {
            return this.getHometown().getName();
        }
        return this.hometownAsString;
    }

    public NamedFacebookType getLocation() {
        return this.location;
    }

    public NamedFacebookType getSignificantOther() {
        return this.significantOther;
    }

    public String getThirdPartyId() {
        return this.thirdPartyId;
    }

    public List<String> getInterestedIn() {
        return Collections.unmodifiableList(this.interestedIn);
    }

    public List<String> getMeetingFor() {
        return Collections.unmodifiableList(this.meetingFor);
    }

    public List<Work> getWork() {
        return Collections.unmodifiableList(this.work);
    }

    public List<Education> getEducation() {
        return Collections.unmodifiableList(this.education);
    }

    public List<Sport> getSports() {
        return Collections.unmodifiableList(this.sports);
    }

    public List<NamedFacebookType> getFavoriteTeams() {
        return Collections.unmodifiableList(this.favoriteTeams);
    }

    public List<NamedFacebookType> getFavoriteAthletes() {
        return Collections.unmodifiableList(this.favoriteAthletes);
    }

    public List<NamedFacebookType> getLanguages() {
        return Collections.unmodifiableList(this.languages);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class Sport
    extends NamedFacebookType {
        @Facebook
        private List<NamedFacebookType> with = new ArrayList<NamedFacebookType>();
        private static final long serialVersionUID = 1L;

        public List<NamedFacebookType> getWith() {
            return Collections.unmodifiableList(this.with);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class EducationClass
    extends NamedFacebookType {
        @Facebook
        private List<NamedFacebookType> with = new ArrayList<NamedFacebookType>();
        @Facebook
        private String description;
        private static final long serialVersionUID = 1L;

        public List<NamedFacebookType> getWith() {
            return Collections.unmodifiableList(this.with);
        }

        public String getDescription() {
            return this.description;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class Education
    implements Serializable {
        @Facebook
        private NamedFacebookType school;
        @Facebook
        private NamedFacebookType year;
        @Facebook
        private NamedFacebookType degree;
        @Facebook
        private String type;
        @Facebook
        private List<NamedFacebookType> concentration = new ArrayList<NamedFacebookType>();
        @Facebook
        private List<NamedFacebookType> with = new ArrayList<NamedFacebookType>();
        @Facebook
        private List<EducationClass> classes = new ArrayList<EducationClass>();
        private static final long serialVersionUID = 2L;

        public int hashCode() {
            return ReflectionUtils.hashCode(this);
        }

        public boolean equals(Object object) {
            return ReflectionUtils.equals(this, object);
        }

        public String toString() {
            return ReflectionUtils.toString(this);
        }

        public NamedFacebookType getSchool() {
            return this.school;
        }

        public NamedFacebookType getYear() {
            return this.year;
        }

        public NamedFacebookType getDegree() {
            return this.degree;
        }

        public String getType() {
            return this.type;
        }

        public List<NamedFacebookType> getConcentration() {
            return Collections.unmodifiableList(this.concentration);
        }

        public List<NamedFacebookType> getWith() {
            return Collections.unmodifiableList(this.with);
        }

        public List<EducationClass> getClasses() {
            return Collections.unmodifiableList(this.classes);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class Work
    implements Serializable {
        @Facebook
        private NamedFacebookType employer;
        @Facebook
        private NamedFacebookType location;
        @Facebook
        private NamedFacebookType position;
        @Facebook
        private String description;
        @Facebook(value="start_date")
        private String startDate;
        @Facebook(value="end_date")
        private String endDate;
        @Facebook
        private List<NamedFacebookType> with = new ArrayList<NamedFacebookType>();
        private static final long serialVersionUID = 1L;

        public int hashCode() {
            return ReflectionUtils.hashCode(this);
        }

        public boolean equals(Object object) {
            return ReflectionUtils.equals(this, object);
        }

        public String toString() {
            return ReflectionUtils.toString(this);
        }

        public NamedFacebookType getEmployer() {
            return this.employer;
        }

        public NamedFacebookType getLocation() {
            return this.location;
        }

        public NamedFacebookType getPosition() {
            return this.position;
        }

        public String getDescription() {
            return this.description;
        }

        public Date getStartDate() {
            return DateUtils.toDateFromMonthYearFormat(this.startDate);
        }

        public Date getEndDate() {
            return DateUtils.toDateFromMonthYearFormat(this.endDate);
        }

        public List<NamedFacebookType> getWith() {
            return Collections.unmodifiableList(this.with);
        }
    }
}

