/*
 * Decompiled with CFR 0.152.
 */
package com.restfb.util;

import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.logging.Level;
import java.util.logging.Logger;

public final class DateUtils {
    public static final String FACEBOOK_LONG_DATE_FORMAT = "yyyy-MM-dd'T'HH:mm:ssZ";
    public static final String FACEBOOK_LONG_DATE_FORMAT_WITHOUT_TIMEZONE = "yyyy-MM-dd'T'HH:mm:ss";
    public static final String FACEBOOK_SHORT_DATE_FORMAT = "MM/dd/yyyy";
    public static final String FACEBOOK_MONTH_YEAR_DATE_FORMAT = "yyyy-MM";
    private static final Logger logger = Logger.getLogger(DateUtils.class.getName());

    private DateUtils() {
    }

    public static Date toDateFromLongFormat(String string) {
        Date date = DateUtils.toDateWithFormatString(string, FACEBOOK_LONG_DATE_FORMAT);
        if (date == null) {
            date = DateUtils.toDateWithFormatString(string, FACEBOOK_LONG_DATE_FORMAT_WITHOUT_TIMEZONE);
        }
        return date;
    }

    public static Date toDateFromShortFormat(String string) {
        return DateUtils.toDateWithFormatString(string, FACEBOOK_SHORT_DATE_FORMAT);
    }

    public static Date toDateFromMonthYearFormat(String string) {
        if ("0000-00".equals(string)) {
            return null;
        }
        return DateUtils.toDateWithFormatString(string, FACEBOOK_MONTH_YEAR_DATE_FORMAT);
    }

    private static Date toDateWithFormatString(String string, String string2) {
        if (string == null) {
            return null;
        }
        try {
            return new SimpleDateFormat(string2).parse(string);
        }
        catch (ParseException parseException) {
            if (logger.isLoggable(Level.FINE)) {
                logger.fine("Unable to parse date '" + string + "' using format string '" + string2 + "': " + parseException);
            }
            return null;
        }
    }
}

