/*
 * Decompiled with CFR 0.152.
 */
package play.modules.facebook;

import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import java.util.regex.Pattern;
import javax.crypto.Mac;
import javax.crypto.spec.SecretKeySpec;
import org.apache.commons.codec.binary.Base64;

public class SignedRequest {
    private String encodedSig;
    private String encodedData;
    private String sig;
    private JsonObject data;

    public SignedRequest(String value) {
        String[] splits = value.split(Pattern.quote("."));
        this.encodedSig = splits[0];
        this.sig = this.base64UrlDecode(this.encodedSig);
        this.encodedData = splits[1];
        this.data = (JsonObject)new JsonParser().parse(this.base64UrlDecode(this.encodedData));
    }

    public boolean verify(String secret) {
        boolean sigVerified = false;
        String algorithm = this.data.get("algorithm").getAsString();
        if ("HMAC-SHA256".equals(algorithm)) {
            try {
                SecretKeySpec key = new SecretKeySpec(secret.getBytes("UTF-8"), "HmacSHA256");
                Mac hmac = Mac.getInstance("HmacSHA256");
                hmac.init(key);
                String expectedSig = new String(hmac.doFinal(this.encodedData.getBytes("UTF-8")));
                if (expectedSig.equals(this.sig)) {
                    sigVerified = true;
                }
            }
            catch (Exception ex) {
                // empty catch block
            }
        }
        return sigVerified;
    }

    public String getSignature() {
        return this.sig;
    }

    public JsonObject getData() {
        return this.data;
    }

    private String base64UrlDecode(String encoded) {
        Base64 base64 = new Base64(true);
        return new String(base64.decode(encoded));
    }
}

