/*
 * Decompiled with CFR 0.152.
 */
package com.force.api;

import com.force.api.ApiVersion;
import java.net.URI;
import java.net.URLDecoder;

public class ApiConfig {
    ApiVersion apiVersion = ApiVersion.DEFAULT_VERSION;
    String username;
    String password;
    String refreshToken;
    String loginEndpoint = "https://login.salesforce.com";
    String clientId;
    String clientSecret;
    String redirectURI;

    public ApiConfig clone() {
        return new ApiConfig().setApiVersion(this.apiVersion).setUsername(this.username).setPassword(this.password).setRefreshToken(this.refreshToken).setLoginEndpoint(this.loginEndpoint).setClientId(this.clientId).setClientSecret(this.clientSecret).setRedirectURI(this.redirectURI);
    }

    public ApiConfig setForceURL(String url) {
        try {
            String[] params;
            URI uri = new URI(url);
            this.loginEndpoint = "https://" + uri.getHost() + (uri.getPort() > 0 ? ":" + uri.getPort() : "");
            for (String param : params = uri.getQuery().split("&")) {
                String[] kv = param.split("=");
                if (kv[0].equals("user")) {
                    this.username = URLDecoder.decode(kv[1], "UTF-8");
                    continue;
                }
                if (kv[0].equals("password")) {
                    this.password = URLDecoder.decode(kv[1], "UTF-8");
                    continue;
                }
                if (kv[0].equals("oauth_key")) {
                    this.clientId = URLDecoder.decode(kv[1], "UTF-8");
                    continue;
                }
                if (!kv[0].equals("oauth_secret")) continue;
                this.clientSecret = URLDecoder.decode(kv[1], "UTF-8");
            }
        }
        catch (Exception e) {
            throw new IllegalArgumentException("Couldn't parse URL: " + url, e);
        }
        return this;
    }

    public ApiConfig setRedirectURI(String redirectURI) {
        this.redirectURI = redirectURI;
        return this;
    }

    public ApiConfig setApiVersion(ApiVersion value) {
        this.apiVersion = value;
        return this;
    }

    public ApiConfig setUsername(String value) {
        this.username = value;
        return this;
    }

    public ApiConfig setPassword(String value) {
        this.password = value;
        return this;
    }

    public ApiConfig setRefreshToken(String value) {
        this.refreshToken = value;
        return this;
    }

    public ApiConfig setLoginEndpoint(String value) {
        this.loginEndpoint = value;
        return this;
    }

    public ApiConfig setClientId(String value) {
        this.clientId = value;
        return this;
    }

    public ApiConfig setClientSecret(String value) {
        this.clientSecret = value;
        return this;
    }

    public String getUsername() {
        return this.username;
    }

    public String getPassword() {
        return this.password;
    }

    public String getRefreshToken() {
        return this.refreshToken;
    }

    public String getLoginEndpoint() {
        return this.loginEndpoint;
    }

    public String getClientId() {
        return this.clientId;
    }

    public String getClientSecret() {
        return this.clientSecret;
    }

    public String getRedirectURI() {
        return this.redirectURI;
    }

    public ApiVersion getApiVersion() {
        return this.apiVersion;
    }
}

