/*
 * Decompiled with CFR 0.152.
 */
package com.force.api.http;

import com.force.api.http.HttpRequest;
import com.force.api.http.HttpResponse;
import java.io.BufferedInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;

public class Http {
    static final byte[] readResponse(InputStream stream) throws IOException {
        BufferedInputStream bin = new BufferedInputStream(stream);
        ByteArrayOutputStream bout = new ByteArrayOutputStream();
        byte[] buf = new byte[10000];
        int read = 0;
        while ((read = bin.read(buf)) != -1) {
            bout.write(buf, 0, read);
        }
        return bout.toByteArray();
    }

    public static final HttpResponse send(HttpRequest req) {
        try {
            req.sendContent();
            int code = req.getConnection().getResponseCode();
            if (code < 300 && code >= 200) {
                switch (req.responseFormat) {
                    case BYTE: {
                        return new HttpResponse().setByte(Http.readResponse(req.getConnection().getInputStream())).setResponseCode(code);
                    }
                    case STRING: {
                        return new HttpResponse().setString(new String(Http.readResponse(req.getConnection().getInputStream()), "UTF-8")).setResponseCode(code);
                    }
                }
                return new HttpResponse().setStream(req.getConnection().getInputStream()).setResponseCode(code);
            }
            System.out.println("Bad response code: " + code + " on request:\n" + req);
            HttpResponse r = new HttpResponse().setString(new String(Http.readResponse(req.getConnection().getErrorStream()), "UTF-8")).setResponseCode(code);
            return r;
        }
        catch (IOException e) {
            throw new RuntimeException(req.toString(), e);
        }
    }
}

