/*
 * Decompiled with CFR 0.152.
 */
package com.force.api.http;

import com.force.api.http.HttpRequest;
import java.io.BufferedOutputStream;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.net.ProtocolException;
import java.net.URLEncoder;

public class HttpFormPost
extends HttpRequest {
    StringBuffer body = new StringBuffer();

    @Override
    public HttpFormPost url(String url) {
        this.baseSetUrl(url);
        this.conn.setDoOutput(true);
        try {
            this.conn.setRequestMethod("POST");
        }
        catch (ProtocolException e) {
            throw new RuntimeException(e);
        }
        this.conn.addRequestProperty("Accept", "*/*");
        this.conn.addRequestProperty("Content-Type", "application/x-www-form-urlencoded; charset=UTF-8");
        return this;
    }

    @Override
    public HttpFormPost header(String key, String value) {
        this.baseAddHeader(key, value);
        return this;
    }

    public HttpFormPost param(String key, String value) {
        try {
            if (this.body.length() > 0) {
                this.body.append("&" + key + "=" + URLEncoder.encode(value, "UTF-8"));
            } else {
                this.body.append(key + "=" + URLEncoder.encode(value, "UTF-8"));
            }
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException(e);
        }
        return this;
    }

    public HttpFormPost preEncodedParam(String key, String value) {
        if (this.body.length() > 0) {
            this.body.append("&" + key + "=" + value);
        } else {
            this.body.append(key + "=" + value);
        }
        return this;
    }

    @Override
    public void sendContent() {
        try {
            BufferedOutputStream out = new BufferedOutputStream(this.conn.getOutputStream());
            out.write(this.body.toString().getBytes("UTF-8"));
            out.flush();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public String toString() {
        return super.toString() + "Request Body:\n" + this.body.toString();
    }
}

