/*
 * Decompiled with CFR 0.152.
 */
package com.force.api;

import com.force.api.ApiConfig;
import com.force.api.ApiSession;
import com.force.api.Auth;
import com.force.api.CreateOrUpdateResult;
import com.force.api.CreateResponse;
import com.force.api.Identity;
import com.force.api.OperationFailedException;
import com.force.api.QueryResult;
import com.force.api.ResourceException;
import com.force.api.ResourceRepresentation;
import com.force.api.http.Http;
import com.force.api.http.HttpRequest;
import com.force.api.http.HttpResponse;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.Map;
import org.codehaus.jackson.JsonGenerationException;
import org.codehaus.jackson.JsonNode;
import org.codehaus.jackson.JsonParseException;
import org.codehaus.jackson.map.JsonMappingException;
import org.codehaus.jackson.map.ObjectMapper;
import org.codehaus.jackson.map.annotate.JsonSerialize;

public class ForceApi {
    private static final ObjectMapper jsonMapper = new ObjectMapper();
    ApiConfig config;
    ApiSession session;
    Identity identity;

    public ForceApi(ApiConfig config, ApiSession session) {
        this.config = config;
        this.session = session;
    }

    public ForceApi(ApiConfig apiConfig) {
        this.config = apiConfig;
        this.session = Auth.authenticate(apiConfig);
    }

    public Identity getIdentity() {
        if (this.identity != null) {
            return this.identity;
        }
        try {
            Map resp = (Map)jsonMapper.readValue(Http.send(new HttpRequest().url(this.session.getApiEndpoint() + "/services/data/" + (Object)((Object)this.config.getApiVersion()) + "/").method("GET").header("Accept", "application/json").header("Authorization", "OAuth " + this.session.getAccessToken())).getStream(), Map.class);
            this.identity = (Identity)jsonMapper.readValue(Http.send(new HttpRequest().url((String)resp.get("identity")).method("GET").header("Accept", "application/json").header("Authorization", "OAuth " + this.session.getAccessToken())).getStream(), Identity.class);
            return this.identity;
        }
        catch (JsonParseException e) {
            throw new RuntimeException(e);
        }
        catch (JsonMappingException e) {
            throw new RuntimeException(e);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public ResourceRepresentation getSObject(String type, String id) throws ResourceException {
        return new ResourceRepresentation(Http.send(new HttpRequest().url(this.session.getApiEndpoint() + "/services/data/" + (Object)((Object)this.config.getApiVersion()) + "/sobjects/" + type + "/" + id).method("GET").header("Accept", "application/json").header("Authorization", "OAuth " + this.session.getAccessToken())));
    }

    public String createSObject(String type, Object sObject) {
        try {
            HttpResponse res = Http.send(new HttpRequest().url(this.session.getApiEndpoint() + "/services/data/" + (Object)((Object)this.config.getApiVersion()) + "/sobjects/" + type).method("POST").header("Authorization", "OAuth " + this.session.getAccessToken()).header("Accept", "application/json").header("Content-Type", "application/json").content(jsonMapper.writeValueAsBytes(sObject)));
            if (res.getResponseCode() != 201) {
                System.out.println("Code: " + res.getResponseCode());
                System.out.println("Message: " + res.getString());
                throw new RuntimeException();
            }
            CreateResponse result = (CreateResponse)jsonMapper.readValue(res.getStream(), CreateResponse.class);
            if (result.isSuccess()) {
                return result.getId();
            }
            throw new OperationFailedException(result.getErrors());
        }
        catch (JsonGenerationException e) {
            throw new ResourceException(e);
        }
        catch (JsonMappingException e) {
            throw new ResourceException(e);
        }
        catch (IOException e) {
            throw new ResourceException(e);
        }
    }

    public void updateSObject(String type, String id, Object sObject) {
        try {
            HttpResponse res = Http.send(new HttpRequest().url(this.session.getApiEndpoint() + "/services/data/" + (Object)((Object)this.config.getApiVersion()) + "/sobjects/" + type + "/" + id + "?_HttpMethod=PATCH").method("POST").header("Authorization", "OAuth " + this.session.getAccessToken()).header("Accept", "application/json").header("Content-Type", "application/json").content(jsonMapper.writeValueAsBytes(sObject)));
            if (res.getResponseCode() != 204) {
                System.out.println("Code: " + res.getResponseCode());
                System.out.println("Message: " + res.getString());
                throw new RuntimeException();
            }
        }
        catch (JsonGenerationException e) {
            throw new ResourceException(e);
        }
        catch (JsonMappingException e) {
            throw new ResourceException(e);
        }
        catch (IOException e) {
            throw new ResourceException(e);
        }
    }

    public void deleteSObject(String type, String id) {
        Http.send(new HttpRequest().url(this.session.getApiEndpoint() + "/services/data/" + (Object)((Object)this.config.getApiVersion()) + "/sobjects/" + type + "/" + id).method("DELETE").header("Authorization", "OAuth " + this.session.getAccessToken()));
    }

    public CreateOrUpdateResult createOrUpdateSObject(String type, String externalIdField, String externalIdValue, Object sObject) {
        try {
            HttpResponse res = Http.send(new HttpRequest().url(this.session.getApiEndpoint() + "/services/data/" + (Object)((Object)this.config.getApiVersion()) + "/sobjects/" + type + "/" + externalIdField + "/" + URLEncoder.encode(externalIdValue, "UTF-8") + "?_HttpMethod=PATCH").method("POST").header("Authorization", "OAuth " + this.session.getAccessToken()).header("Accept", "application/json").header("Content-Type", "application/json").content(jsonMapper.writeValueAsBytes(sObject)));
            if (res.getResponseCode() == 201) {
                return CreateOrUpdateResult.CREATED;
            }
            if (res.getResponseCode() == 204) {
                return CreateOrUpdateResult.UPDATED;
            }
            System.out.println("Code: " + res.getResponseCode());
            System.out.println("Message: " + res.getString());
            throw new RuntimeException();
        }
        catch (JsonGenerationException e) {
            throw new ResourceException(e);
        }
        catch (JsonMappingException e) {
            throw new ResourceException(e);
        }
        catch (IOException e) {
            throw new ResourceException(e);
        }
    }

    public <T> QueryResult<T> query(String query, Class<T> clazz) {
        try {
            HttpResponse res = Http.send(new HttpRequest().url(this.session.getApiEndpoint() + "/services/data/" + (Object)((Object)this.config.getApiVersion()) + "/query/?q=" + URLEncoder.encode(query, "UTF-8")).method("GET").header("Accept", "application/json").header("Authorization", "OAuth " + this.session.getAccessToken()));
            if (res.getResponseCode() == 200) {
                QueryResult result = new QueryResult();
                JsonNode root = jsonMapper.readTree(res.getStream());
                result.setDone(root.get("done").getBooleanValue());
                result.setTotalSize(root.get("totalSize").getIntValue());
                if (root.get("nextRecodsUrl") != null) {
                    result.setNextRecordsUrl(root.get("nextRecordsUrl").getTextValue());
                }
                ArrayList<Object> records = new ArrayList<Object>();
                for (JsonNode elem : root.get("records")) {
                    records.add(jsonMapper.readValue(elem, clazz));
                }
                result.setRecords(records);
                return result;
            }
            System.out.println("Code: " + res.getResponseCode());
            System.out.println("Message: " + res.getString());
            throw new RuntimeException();
        }
        catch (JsonParseException e) {
            throw new ResourceException(e);
        }
        catch (JsonMappingException e) {
            throw new ResourceException(e);
        }
        catch (UnsupportedEncodingException e) {
            throw new ResourceException(e);
        }
        catch (IOException e) {
            throw new ResourceException(e);
        }
    }

    static {
        jsonMapper.setSerializationInclusion(JsonSerialize.Inclusion.NON_NULL);
    }
}

