/*
 * Decompiled with CFR 0.152.
 */
package com.force.api.http;

import java.io.BufferedOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.ProtocolException;
import java.net.URL;

public class HttpRequest {
    protected HttpURLConnection conn;
    protected ResponseFormat responseFormat = ResponseFormat.STREAM;
    StringBuffer stringRep = new StringBuffer();
    byte[] contentBytes;
    InputStream contentStream;

    protected void baseSetUrl(String url) {
        try {
            this.conn = (HttpURLConnection)new URL(url).openConnection();
            this.stringRep.append("URL: " + url + "\n");
        }
        catch (MalformedURLException e) {
            throw new RuntimeException(e);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        this.conn.setInstanceFollowRedirects(true);
    }

    protected void baseAddHeader(String key, String value) {
        this.conn.addRequestProperty(key, value);
        this.stringRep.append("Header: " + key + ": " + value + "\n");
    }

    public HttpRequest header(String key, String value) {
        this.baseAddHeader(key, value);
        return this;
    }

    public HttpURLConnection getConnection() {
        return this.conn;
    }

    public ResponseFormat getResponseFormat() {
        return this.responseFormat;
    }

    public HttpRequest responseFormat(ResponseFormat value) {
        this.responseFormat = value;
        return this;
    }

    public void sendContent() {
        try {
            if (this.contentBytes != null) {
                BufferedOutputStream out = new BufferedOutputStream(this.conn.getOutputStream());
                out.write(this.contentBytes);
                out.flush();
            } else if (this.contentStream != null) {
                int n;
                byte[] buf = new byte[2000];
                BufferedOutputStream out = new BufferedOutputStream(this.conn.getOutputStream());
                while ((n = this.contentStream.read(buf)) >= 0) {
                    out.write(buf, 0, n);
                }
                out.flush();
            }
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public HttpRequest url(String value) {
        this.baseSetUrl(value);
        return this;
    }

    public HttpRequest method(String value) {
        try {
            this.conn.setRequestMethod(value);
            this.stringRep.append("Method: " + value + "\n");
        }
        catch (ProtocolException e) {
            throw new RuntimeException(e);
        }
        return this;
    }

    public HttpRequest content(byte[] value) {
        this.contentBytes = value;
        this.conn.setDoOutput(true);
        return this;
    }

    public HttpRequest content(InputStream value) {
        this.contentStream = value;
        this.conn.setDoOutput(true);
        return this;
    }

    public String toString() {
        if (this.conn == null) {
            return "HttpRequest with uninitialized URL";
        }
        return this.stringRep.toString() + (this.contentBytes != null ? "\nBODY\n\n" + new String(this.contentBytes) : "");
    }

    public static enum ResponseFormat {
        STREAM,
        BYTE,
        STRING;

    }
}

