/*
 * Decompiled with CFR 0.152.
 */
package com.force.api;

import com.force.api.ApiConfig;
import com.force.api.ApiException;
import com.force.api.ApiSession;
import com.force.api.ApiTokenException;
import com.force.api.Auth;
import com.force.api.CreateOrUpdateResult;
import com.force.api.CreateResponse;
import com.force.api.DescribeGlobal;
import com.force.api.DescribeSObject;
import com.force.api.Identity;
import com.force.api.QueryResult;
import com.force.api.ResourceException;
import com.force.api.ResourceRepresentation;
import com.force.api.SObjectException;
import com.force.api.http.Http;
import com.force.api.http.HttpRequest;
import com.force.api.http.HttpResponse;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.Map;
import org.codehaus.jackson.JsonGenerationException;
import org.codehaus.jackson.JsonNode;
import org.codehaus.jackson.JsonParseException;
import org.codehaus.jackson.map.JsonMappingException;
import org.codehaus.jackson.map.ObjectMapper;
import org.codehaus.jackson.map.annotate.JsonSerialize;

public class ForceApi {
    private static final ObjectMapper jsonMapper = new ObjectMapper();
    final ApiConfig config;
    ApiSession session;
    private boolean autoRenew = false;

    public ForceApi(ApiConfig config, ApiSession session) {
        this.config = config;
        this.session = session;
        if (session.getRefreshToken() != null) {
            this.autoRenew = true;
        }
    }

    public ForceApi(ApiSession session) {
        this(new ApiConfig(), session);
    }

    public ForceApi(ApiConfig apiConfig) {
        this.config = apiConfig;
        this.session = Auth.authenticate(apiConfig);
        this.autoRenew = true;
    }

    public Identity getIdentity() {
        try {
            Map resp = (Map)jsonMapper.readValue(this.apiRequest(new HttpRequest().url(this.uriBase()).method("GET").header("Accept", "application/json")).getStream(), Map.class);
            return (Identity)jsonMapper.readValue(this.apiRequest(new HttpRequest().url((String)resp.get("identity")).method("GET").header("Accept", "application/json")).getStream(), Identity.class);
        }
        catch (JsonParseException e) {
            throw new RuntimeException(e);
        }
        catch (JsonMappingException e) {
            throw new RuntimeException(e);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public ResourceRepresentation getSObject(String type, String id) throws ResourceException {
        return new ResourceRepresentation(this.apiRequest(new HttpRequest().url(this.uriBase() + "/sobjects/" + type + "/" + id).method("GET").header("Accept", "application/json")));
    }

    public String createSObject(String type, Object sObject) {
        try {
            CreateResponse result = (CreateResponse)jsonMapper.readValue(this.apiRequest(new HttpRequest().url(this.uriBase() + "/sobjects/" + type).method("POST").header("Accept", "application/json").header("Content-Type", "application/json").expectsCode(201).content(jsonMapper.writeValueAsBytes(sObject))).getStream(), CreateResponse.class);
            if (result.isSuccess()) {
                return result.getId();
            }
            throw new SObjectException(result.getErrors());
        }
        catch (JsonGenerationException e) {
            throw new ResourceException(e);
        }
        catch (JsonMappingException e) {
            throw new ResourceException(e);
        }
        catch (IOException e) {
            throw new ResourceException(e);
        }
    }

    public void updateSObject(String type, String id, Object sObject) {
        try {
            this.apiRequest(new HttpRequest().url(this.uriBase() + "/sobjects/" + type + "/" + id + "?_HttpMethod=PATCH").method("POST").header("Accept", "application/json").header("Content-Type", "application/json").expectsCode(204).content(jsonMapper.writeValueAsBytes(sObject)));
        }
        catch (JsonGenerationException e) {
            throw new ResourceException(e);
        }
        catch (JsonMappingException e) {
            throw new ResourceException(e);
        }
        catch (IOException e) {
            throw new ResourceException(e);
        }
    }

    public void deleteSObject(String type, String id) {
        this.apiRequest(new HttpRequest().url(this.uriBase() + "/sobjects/" + type + "/" + id).method("DELETE"));
    }

    public CreateOrUpdateResult createOrUpdateSObject(String type, String externalIdField, String externalIdValue, Object sObject) {
        try {
            HttpResponse res = this.apiRequest(new HttpRequest().url(this.uriBase() + "/sobjects/" + type + "/" + externalIdField + "/" + URLEncoder.encode(externalIdValue, "UTF-8") + "?_HttpMethod=PATCH").method("POST").header("Accept", "application/json").header("Content-Type", "application/json").content(jsonMapper.writeValueAsBytes(sObject)));
            if (res.getResponseCode() == 201) {
                return CreateOrUpdateResult.CREATED;
            }
            if (res.getResponseCode() == 204) {
                return CreateOrUpdateResult.UPDATED;
            }
            System.out.println("Code: " + res.getResponseCode());
            System.out.println("Message: " + res.getString());
            throw new RuntimeException();
        }
        catch (JsonGenerationException e) {
            throw new ResourceException(e);
        }
        catch (JsonMappingException e) {
            throw new ResourceException(e);
        }
        catch (IOException e) {
            throw new ResourceException(e);
        }
    }

    public <T> QueryResult<T> query(String query, Class<T> clazz) {
        try {
            HttpResponse res = this.apiRequest(new HttpRequest().url(this.uriBase() + "/query/?q=" + URLEncoder.encode(query, "UTF-8")).method("GET").header("Accept", "application/json").expectsCode(200));
            QueryResult result = new QueryResult();
            JsonNode root = jsonMapper.readTree(res.getStream());
            result.setDone(root.get("done").getBooleanValue());
            result.setTotalSize(root.get("totalSize").getIntValue());
            if (root.get("nextRecodsUrl") != null) {
                result.setNextRecordsUrl(root.get("nextRecordsUrl").getTextValue());
            }
            ArrayList<Object> records = new ArrayList<Object>();
            for (JsonNode elem : root.get("records")) {
                records.add(jsonMapper.readValue(elem, clazz));
            }
            result.setRecords(records);
            return result;
        }
        catch (JsonParseException e) {
            throw new ResourceException(e);
        }
        catch (JsonMappingException e) {
            throw new ResourceException(e);
        }
        catch (UnsupportedEncodingException e) {
            throw new ResourceException(e);
        }
        catch (IOException e) {
            throw new ResourceException(e);
        }
    }

    public DescribeGlobal describeGlobal() {
        try {
            return (DescribeGlobal)jsonMapper.readValue(this.apiRequest(new HttpRequest().url(this.uriBase() + "/sobjects/").method("GET").header("Accept", "application/json")).getStream(), DescribeGlobal.class);
        }
        catch (JsonParseException e) {
            throw new ResourceException(e);
        }
        catch (JsonMappingException e) {
            throw new ResourceException(e);
        }
        catch (UnsupportedEncodingException e) {
            throw new ResourceException(e);
        }
        catch (IOException e) {
            throw new ResourceException(e);
        }
    }

    public DescribeSObject describeSObject(String sobject) {
        try {
            return (DescribeSObject)jsonMapper.readValue(this.apiRequest(new HttpRequest().url(this.uriBase() + "/sobjects/" + sobject + "/describe").method("GET").header("Accept", "application/json")).getStream(), DescribeSObject.class);
        }
        catch (JsonParseException e) {
            throw new ResourceException(e);
        }
        catch (JsonMappingException e) {
            throw new ResourceException(e);
        }
        catch (UnsupportedEncodingException e) {
            throw new ResourceException(e);
        }
        catch (IOException e) {
            throw new ResourceException(e);
        }
    }

    private final String uriBase() {
        return this.session.getApiEndpoint() + "/services/data/" + (Object)((Object)this.config.getApiVersion());
    }

    private final HttpResponse apiRequest(HttpRequest req) {
        req.setAuthorization("OAuth " + this.session.getAccessToken());
        HttpResponse res = Http.send(req);
        if (res.getResponseCode() == 401 && this.autoRenew) {
            System.out.println("Session expired. Refreshing session...");
            this.session = this.session.getRefreshToken() != null ? Auth.refreshOauthTokenFlow(this.config, this.session.getRefreshToken()) : Auth.authenticate(this.config);
            req.setAuthorization("OAuth " + this.session.getAccessToken());
            res = Http.send(req);
        }
        if (res.getResponseCode() > 299) {
            if (res.getResponseCode() == 401) {
                throw new ApiTokenException(res.getString());
            }
            throw new ApiException(res.getResponseCode(), res.getString());
        }
        if (req.getExpectedCode() != -1 && res.getResponseCode() != req.getExpectedCode()) {
            throw new RuntimeException("Unexpected response from Force API. Got response code " + res.getResponseCode() + ". Was expecing " + req.getExpectedCode());
        }
        return res;
    }

    static {
        jsonMapper.setSerializationInclusion(JsonSerialize.Inclusion.NON_NULL);
    }
}

