/*
 * Decompiled with CFR 0.152.
 */
package play.modules.formee;

import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import play.Logger;
import play.data.validation.Email;
import play.data.validation.Max;
import play.data.validation.MaxSize;
import play.data.validation.Min;
import play.data.validation.MinSize;
import play.data.validation.Range;
import play.data.validation.Required;
import play.data.validation.URL;
import play.i18n.Messages;
import play.modules.formee.FormeeValidation;

public class Formee {
    public static String buildValidationDataString(Field field) throws Exception {
        boolean first;
        Email email;
        URL url;
        MinSize minSize;
        MaxSize maxSize;
        Range range;
        Max max;
        Min min;
        StringBuilder result = new StringBuilder("{");
        ArrayList<String> rules = new ArrayList<String>();
        HashMap<String, String> messages = new HashMap<String, String>();
        Required required = field.getAnnotation(Required.class);
        if (required != null) {
            rules.add("required:true");
            if (required.message() != null) {
                messages.put("required", Messages.get((Object)required.message(), (Object[])new Object[0]));
            }
        }
        if ((min = field.getAnnotation(Min.class)) != null) {
            rules.add("min:" + Double.toString(min.value()));
            if (min.message() != null) {
                messages.put("min", Messages.get((Object)min.message(), (Object[])new Object[]{null, min.value()}));
            }
        }
        if ((max = field.getAnnotation(Max.class)) != null) {
            rules.add("max:" + Double.toString(max.value()));
            if (max.message() != null) {
                messages.put("max", Messages.get((Object)max.message(), (Object[])new Object[]{null, max.value()}));
            }
        }
        if ((range = field.getAnnotation(Range.class)) != null) {
            rules.add("range:[" + Double.toString(range.min()) + ", " + Double.toString(range.max()) + "]");
            if (range.message() != null) {
                messages.put("range", Messages.get((Object)range.message(), (Object[])new Object[]{null, range.min(), range.max()}));
            }
        }
        if ((maxSize = field.getAnnotation(MaxSize.class)) != null) {
            rules.add("maxlength:" + Integer.toString(maxSize.value()));
            if (maxSize.message() != null) {
                messages.put("maxlength", Messages.get((Object)maxSize.message(), (Object[])new Object[]{null, maxSize.value()}));
            }
        }
        if ((minSize = field.getAnnotation(MinSize.class)) != null) {
            rules.add("minlength:" + Integer.toString(minSize.value()));
            if (minSize.message() != null) {
                messages.put("minlength", Messages.get((Object)minSize.message(), (Object[])new Object[]{null, minSize.value()}));
            }
        }
        if ((url = field.getAnnotation(URL.class)) != null) {
            rules.add("url:true");
            if (url.message() != null) {
                messages.put("url", Messages.get((Object)url.message(), (Object[])new Object[0]));
            }
        }
        if ((email = field.getAnnotation(Email.class)) != null) {
            rules.add("email:true");
            if (email.message() != null) {
                messages.put("email", Messages.get((Object)email.message(), (Object[])new Object[0]));
            }
        }
        if (rules.size() > 0) {
            first = true;
            for (String rule : rules) {
                if (first) {
                    first = false;
                } else {
                    result.append(",");
                }
                result.append(rule);
            }
        }
        if (messages.size() > 0) {
            result.append(",messages:{");
            first = true;
            for (String key : messages.keySet()) {
                if (first) {
                    first = false;
                } else {
                    result.append(",");
                }
                result.append("\"");
                result.append(key);
                result.append("\"");
                result.append(":");
                result.append("\"");
                result.append((String)messages.get(key));
                result.append("\"");
            }
            result.append("}");
        }
        result.append("}");
        return result.toString();
    }

    public static void printValidationData() {
        Map<String, Map<String, String>> validations = FormeeValidation.getInstance().getModelFieldValidation();
        StringBuilder out = new StringBuilder("\n");
        for (String model : validations.keySet()) {
            for (String field : validations.get(model).keySet()) {
                String dataValidation = validations.get(model).get(field);
                out.append("[").append(model).append("]").append("\n");
                out.append("    ").append(field).append(" -> ").append(dataValidation).append("\n");
            }
        }
        out.append("\n");
        Logger.debug((String)out.toString(), (Object[])new Object[0]);
    }
}

