/*
 * Decompiled with CFR 0.152.
 */
package play.modules.formee;

import java.io.IOException;
import java.lang.reflect.Field;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.persistence.Entity;
import javax.persistence.MappedSuperclass;
import play.Logger;
import play.Play;
import play.PlayPlugin;
import play.db.jpa.GenericModel;
import play.exceptions.ConfigurationException;
import play.modules.formee.Formee;
import play.modules.formee.FormeeProps;
import play.modules.formee.FormeeValidation;

public class FormeePlugin
extends PlayPlugin {
    private FormeeValidation formeeValidation = FormeeValidation.getInstance();

    public void onConfigurationRead() {
        String namingCase = Play.configuration.getProperty("formee.namingCase", "camelCase");
        if (!(namingCase.equals("camelCase") || namingCase.equals("underscore_case") || namingCase.equals("ProperCase"))) {
            String error = "===== formee.namingCase property is not configured correctly. Check your application.conf =====";
            throw new ConfigurationException(error);
        }
        FormeeProps.namingCase = namingCase;
    }

    public void onApplicationStart() {
        if (Play.mode == Play.Mode.DEV) {
            this.formeeValidation.setModelFieldValidation(null);
        }
        if (this.formeeValidation.getModelFieldValidation() != null) {
            return;
        }
        HashMap<String, Map<String, String>> modelFieldValidation = new HashMap<String, Map<String, String>>();
        try {
            List classes = Play.classloader.getAllClasses();
            Iterator i$ = classes.iterator();
            while (i$.hasNext()) {
                Class c;
                Class entityModel = c = (Class)i$.next();
                if (c.getAnnotation(Entity.class) == null) continue;
                modelFieldValidation.put(entityModel.getName(), new HashMap());
                while (!c.getName().equals(GenericModel.class.getName())) {
                    for (Field f : c.getDeclaredFields()) {
                        String dataValidation = Formee.buildValidationDataString(f);
                        if (dataValidation.isEmpty()) continue;
                        ((Map)modelFieldValidation.get(entityModel.getName())).put(f.getName(), dataValidation);
                    }
                    if ((c = c.getSuperclass()).getAnnotation(MappedSuperclass.class) != null) continue;
                    Logger.debug((String)"This message shall never be printed!!!", (Object[])new Object[0]);
                    break;
                }
                if (!((Map)modelFieldValidation.get(entityModel.getName())).isEmpty()) continue;
                modelFieldValidation.remove(entityModel.getName());
            }
        }
        catch (ClassNotFoundException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        catch (NullPointerException e) {
            e.printStackTrace();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        this.formeeValidation.setModelFieldValidation(modelFieldValidation);
    }
}

