/*
 * Decompiled with CFR 0.152.
 */
package com.google.appengine.api.blobstore.dev;

import com.google.appengine.api.blobstore.BlobInfo;
import com.google.appengine.api.blobstore.BlobInfoFactory;
import com.google.appengine.api.blobstore.BlobKey;
import com.google.appengine.api.datastore.DatastoreService;
import com.google.appengine.api.datastore.DatastoreServiceFactory;
import com.google.appengine.api.datastore.Entity;
import com.google.appengine.api.datastore.Key;
import com.google.appengine.api.datastore.KeyFactory;

public class BlobInfoStorage {
    private final BlobInfoFactory blobInfoFactory = new BlobInfoFactory();
    private final DatastoreService datastoreService = DatastoreServiceFactory.getDatastoreService();

    public BlobInfo loadBlobInfo(BlobKey blobKey) {
        return this.blobInfoFactory.loadBlobInfo(blobKey);
    }

    public void saveBlobInfo(BlobInfo blobInfo) {
        Entity entity = new Entity("__BlobInfo__", blobInfo.getBlobKey().getKeyString());
        entity.setProperty("content_type", (Object)blobInfo.getContentType());
        entity.setProperty("creation", (Object)blobInfo.getCreation());
        entity.setProperty("filename", (Object)blobInfo.getFilename());
        entity.setProperty("size", (Object)blobInfo.getSize());
        this.datastoreService.put(entity);
    }

    public void deleteBlobInfo(BlobKey blobKey) {
        this.datastoreService.delete(new Key[]{this.getMetadataKeyForBlobKey(blobKey)});
    }

    protected Key getMetadataKeyForBlobKey(BlobKey blobKey) {
        return KeyFactory.createKey((String)"__BlobInfo__", (String)blobKey.getKeyString());
    }
}

