/*
 * Decompiled with CFR 0.152.
 */
package com.google.appengine.api.blobstore.dev;

import com.google.appengine.api.blobstore.dev.BlobUploadSession;
import com.google.appengine.api.datastore.DatastoreService;
import com.google.appengine.api.datastore.DatastoreServiceFactory;
import com.google.appengine.api.datastore.Entity;
import com.google.appengine.api.datastore.EntityNotFoundException;
import com.google.appengine.api.datastore.Key;
import com.google.appengine.api.datastore.KeyFactory;

public class BlobUploadSessionStorage {
    static final String KIND = "__BlobUploadSession__";
    static final String SUCCESS_PATH = "success_path";
    private final DatastoreService datastoreService = DatastoreServiceFactory.getDatastoreService();

    public String createSession(BlobUploadSession session) {
        Entity entity = new Entity(KIND);
        entity.setProperty(SUCCESS_PATH, (Object)session.getSuccessPath());
        this.datastoreService.put(entity);
        return KeyFactory.keyToString((Key)entity.getKey());
    }

    public BlobUploadSession loadSession(String sessionId) {
        try {
            return this.convertFromEntity(this.datastoreService.get(this.getKeyForSession(sessionId)));
        }
        catch (EntityNotFoundException ex) {
            return null;
        }
    }

    public void deleteSession(String sessionId) {
        this.datastoreService.delete(new Key[]{this.getKeyForSession(sessionId)});
    }

    private BlobUploadSession convertFromEntity(Entity entity) {
        return new BlobUploadSession((String)entity.getProperty(SUCCESS_PATH));
    }

    private Key getKeyForSession(String sessionId) {
        return KeyFactory.stringToKey((String)sessionId);
    }
}

