/*
 * Decompiled with CFR 0.152.
 */
package com.google.appengine.api.labs.taskqueue.dev;

import com.google.appengine.api.labs.taskqueue.TaskQueuePb;
import com.google.appengine.api.labs.taskqueue.dev.QueueStateInfo;
import com.google.appengine.api.labs.taskqueue.dev.UrlFetchJobDetail;
import com.google.apphosting.api.ApiProxy;
import com.google.apphosting.utils.config.QueueXml;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.List;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.quartz.Job;
import org.quartz.JobDetail;
import org.quartz.JobExecutionContext;
import org.quartz.JobExecutionException;
import org.quartz.Scheduler;
import org.quartz.SchedulerException;
import org.quartz.SimpleTrigger;
import org.quartz.Trigger;
import org.quartz.spi.TriggerFiredBundle;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DevQueue {
    private static final Logger logger = Logger.getLogger(DevQueue.class.getName());
    static final int DEFAULT_BUCKET_SIZE = 5;
    private final QueueXml.Entry queueXmlEntry;
    private final AtomicInteger taskNameGenerator;
    private final Scheduler scheduler;

    DevQueue(QueueXml.Entry queueXmlEntry, AtomicInteger taskNameGenerator, Scheduler scheduler) {
        this.taskNameGenerator = taskNameGenerator;
        this.queueXmlEntry = queueXmlEntry;
        this.scheduler = scheduler;
    }

    private synchronized String scheduleTask(TaskQueuePb.TaskQueueAddRequest addRequest, String url) {
        String taskName = addRequest.hasTaskName() && !addRequest.getTaskName().equals("") ? addRequest.getTaskName() : this.genTaskName();
        try {
            if (this.scheduler.getJobDetail(taskName, this.getQueueName()) != null) {
                throw new ApiProxy.ApplicationException(TaskQueuePb.TaskQueueServiceError.ErrorCode.TASK_ALREADY_EXISTS.getValue());
            }
        }
        catch (SchedulerException e) {
            throw new ApiProxy.ApplicationException(TaskQueuePb.TaskQueueServiceError.ErrorCode.INTERNAL_ERROR.getValue(), e.getMessage());
        }
        long etaMillis = addRequest.getEtaUsec() / 1000L;
        SimpleTrigger trigger = new SimpleTrigger(taskName, this.getQueueName());
        trigger.setStartTime(new Date(etaMillis));
        JobDetail jd = this.newUrlFetchJobDetail(taskName, this.getQueueName(), addRequest, url);
        try {
            this.scheduler.scheduleJob(jd, trigger);
        }
        catch (SchedulerException e) {
            throw new ApiProxy.ApplicationException(TaskQueuePb.TaskQueueServiceError.ErrorCode.INTERNAL_ERROR.getValue(), e.getMessage());
        }
        return taskName;
    }

    JobDetail newUrlFetchJobDetail(String taskName, String queueName, TaskQueuePb.TaskQueueAddRequest addRequest, String url) {
        return new UrlFetchJobDetail(taskName, queueName, addRequest, url);
    }

    String genTaskName() {
        Integer newId = this.taskNameGenerator.incrementAndGet();
        return "task" + newId.toString();
    }

    TaskQueuePb.TaskQueueAddResponse add(TaskQueuePb.TaskQueueAddRequest addRequest, String url) {
        String taskName = this.scheduleTask(addRequest, url);
        TaskQueuePb.TaskQueueAddResponse addResponse = new TaskQueuePb.TaskQueueAddResponse();
        if (addRequest.hasTaskName() && !addRequest.getTaskName().equals("")) {
            return addResponse;
        }
        addResponse.setChosenTaskName(taskName);
        return addResponse;
    }

    private String getQueueName() {
        return this.queueXmlEntry.getName();
    }

    private List<String> getSortedJobNames() throws SchedulerException {
        String[] jobNames = this.scheduler.getJobNames(this.getQueueName());
        List<String> jobNameList = Arrays.asList(jobNames);
        Collections.sort(jobNameList);
        return jobNameList;
    }

    QueueStateInfo getStateInfo() {
        ArrayList<QueueStateInfo.TaskStateInfo> taskInfoList = new ArrayList<QueueStateInfo.TaskStateInfo>();
        try {
            for (String jobName : this.getSortedJobNames()) {
                UrlFetchJobDetail jd = (UrlFetchJobDetail)this.scheduler.getJobDetail(jobName, this.getQueueName());
                if (jd == null) continue;
                Trigger[] triggers = this.scheduler.getTriggersOfJob(jobName, this.getQueueName());
                if (triggers.length != 1) {
                    throw new RuntimeException("Multiple triggers for task " + jobName + " in queue " + this.getQueueName());
                }
                long execTime = triggers[0].getStartTime().getTime();
                taskInfoList.add(new QueueStateInfo.TaskStateInfo(jd.getName(), execTime, jd.getAddRequest()));
            }
        }
        catch (SchedulerException e) {
            throw new RuntimeException(e);
        }
        Collections.sort(taskInfoList, new Comparator<QueueStateInfo.TaskStateInfo>(){

            @Override
            public int compare(QueueStateInfo.TaskStateInfo t1, QueueStateInfo.TaskStateInfo t2) {
                return Long.valueOf(t1.getEtaMillis()).compareTo(t2.getEtaMillis());
            }
        });
        return new QueueStateInfo(this.queueXmlEntry, taskInfoList);
    }

    boolean deleteTask(String taskName) {
        try {
            return this.scheduler.deleteJob(taskName, this.getQueueName());
        }
        catch (SchedulerException e) {
            throw new RuntimeException(e);
        }
    }

    void flush() {
        try {
            for (String name : this.scheduler.getJobNames(this.getQueueName())) {
                this.scheduler.deleteJob(name, this.getQueueName());
            }
        }
        catch (SchedulerException e) {
            throw new RuntimeException(e);
        }
    }

    private JobExecutionContext getExecutionContext(JobDetail jobDetail) {
        SimpleTrigger trigger = new SimpleTrigger();
        trigger.setJobDataMap(jobDetail.getJobDataMap());
        TriggerFiredBundle bundle = new TriggerFiredBundle(jobDetail, trigger, null, false, null, null, null, null);
        return new JobExecutionContext(this.scheduler, bundle, null);
    }

    public boolean runTask(String taskName) {
        Job job;
        JobExecutionContext context;
        try {
            UrlFetchJobDetail jd = (UrlFetchJobDetail)this.scheduler.getJobDetail(taskName, this.getQueueName());
            if (jd == null) {
                return false;
            }
            context = this.getExecutionContext(jd);
            job = (Job)jd.getJobClass().newInstance();
        }
        catch (SchedulerException e) {
            return false;
        }
        catch (IllegalAccessException e) {
            return false;
        }
        catch (InstantiationException e) {
            return false;
        }
        try {
            job.execute(context);
        }
        catch (JobExecutionException e) {
            logger.log(Level.SEVERE, "Exception executing task " + taskName + " on queue " + this.getQueueName(), e);
        }
        catch (RuntimeException rte) {
            logger.log(Level.SEVERE, "Exception executing task " + taskName + " on queue " + this.getQueueName(), rte);
        }
        this.deleteTask(taskName);
        return true;
    }
}

