/*
 * Decompiled with CFR 0.152.
 */
package com.google.appengine.api.users.dev;

import com.google.appengine.tools.development.LocalRpcService;
import com.google.appengine.tools.development.LocalServiceContext;
import com.google.appengine.tools.development.ServiceProvider;
import com.google.apphosting.api.UserServicePb;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@ServiceProvider(value=LocalRpcService.class)
public class LocalUserService
implements LocalRpcService {
    private static final String LOGIN_URL = "/_ah/login";
    private static final String LOGOUT_URL = "/_ah/logout";
    public static final String PACKAGE = "user";

    public UserServicePb.CreateLoginURLResponse createLoginURL(LocalRpcService.Status status, UserServicePb.CreateLoginURLRequest request) {
        UserServicePb.CreateLoginURLResponse response = new UserServicePb.CreateLoginURLResponse();
        response.setLoginUrl("/_ah/login?continue=" + LocalUserService.encode(request.getDestinationUrl()));
        return response;
    }

    public UserServicePb.CreateLogoutURLResponse createLogoutURL(LocalRpcService.Status status, UserServicePb.CreateLogoutURLRequest request) {
        UserServicePb.CreateLogoutURLResponse response = new UserServicePb.CreateLogoutURLResponse();
        response.setLogoutUrl("/_ah/logout?continue=" + LocalUserService.encode(request.getDestinationUrl()));
        return response;
    }

    public String getPackage() {
        return PACKAGE;
    }

    public void init(LocalServiceContext context, Map<String, String> properties) {
    }

    public void start() {
    }

    public void stop() {
    }

    private static String encode(String url) {
        try {
            return URLEncoder.encode(url, "UTF-8");
        }
        catch (UnsupportedEncodingException ex) {
            throw new RuntimeException("Could not find UTF-8 encoding", ex);
        }
    }
}

